/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.common.entity.companion.SoulMageEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SoulMageBookEntity
extends Projectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation OPEN = RawAnimation.begin().thenPlay("open");
    private final RawAnimation DEAD = RawAnimation.begin().thenPlay("dead");
    private final RawAnimation SUMMON = RawAnimation.begin().thenPlay("summon");
    private static final EntityDataAccessor<Integer> TARGET_RED = SynchedEntityData.m_135353_(SoulMageBookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TARGET_GREEN = SynchedEntityData.m_135353_(SoulMageBookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TARGET_BLUE = SynchedEntityData.m_135353_(SoulMageBookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> CURRENT_RED = SynchedEntityData.m_135353_(SoulMageBookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> CURRENT_GREEN = SynchedEntityData.m_135353_(SoulMageBookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> CURRENT_BLUE = SynchedEntityData.m_135353_(SoulMageBookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public SoulMageBookEntity(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19794_ = true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_19749_() == null || this.m_19749_().m_213877_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (!this.m_9236_().f_46443_) {
            this.updateTargetColor();
            this.updateCurrentColor();
        }
        if (this.m_19749_() != null) {
            this.orbit(this.m_19749_());
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TARGET_RED, (Object)255);
        this.f_19804_.m_135372_(TARGET_GREEN, (Object)255);
        this.f_19804_.m_135372_(TARGET_BLUE, (Object)255);
        this.f_19804_.m_135372_(CURRENT_RED, (Object)Float.valueOf(255.0f));
        this.f_19804_.m_135372_(CURRENT_GREEN, (Object)Float.valueOf(255.0f));
        this.f_19804_.m_135372_(CURRENT_BLUE, (Object)Float.valueOf(255.0f));
    }

    public float getCurrentRed() {
        return ((Float)this.f_19804_.m_135370_(CURRENT_RED)).floatValue();
    }

    public float getCurrentGreen() {
        return ((Float)this.f_19804_.m_135370_(CURRENT_GREEN)).floatValue();
    }

    public float getCurrentBlue() {
        return ((Float)this.f_19804_.m_135370_(CURRENT_BLUE)).floatValue();
    }

    public void updateTargetColor() {
        Entity entity = this.m_19749_();
        if (entity instanceof SoulMageEntity) {
            SoulMageEntity soulMageEntity = (SoulMageEntity)entity;
            int[] color = SoulMageEntity.ATTACK_COLORS.getOrDefault(soulMageEntity.getCurrentAttackType(), SoulMageEntity.ATTACK_COLORS.get("NONE"));
            this.f_19804_.m_135381_(TARGET_RED, (Object)color[0]);
            this.f_19804_.m_135381_(TARGET_GREEN, (Object)color[1]);
            this.f_19804_.m_135381_(TARGET_BLUE, (Object)color[2]);
        } else {
            this.f_19804_.m_135381_(TARGET_RED, (Object)255);
            this.f_19804_.m_135381_(TARGET_GREEN, (Object)255);
            this.f_19804_.m_135381_(TARGET_BLUE, (Object)255);
        }
    }

    public void updateCurrentColor() {
        float curR = ((Float)this.f_19804_.m_135370_(CURRENT_RED)).floatValue();
        float curG = ((Float)this.f_19804_.m_135370_(CURRENT_GREEN)).floatValue();
        float curB = ((Float)this.f_19804_.m_135370_(CURRENT_BLUE)).floatValue();
        int targetR = (Integer)this.f_19804_.m_135370_(TARGET_RED);
        int targetG = (Integer)this.f_19804_.m_135370_(TARGET_GREEN);
        int targetB = (Integer)this.f_19804_.m_135370_(TARGET_BLUE);
        curR = this.lerp(curR, targetR);
        curG = this.lerp(curG, targetG);
        curB = this.lerp(curB, targetB);
        this.f_19804_.m_135381_(CURRENT_RED, (Object)Float.valueOf(curR));
        this.f_19804_.m_135381_(CURRENT_GREEN, (Object)Float.valueOf(curG));
        this.f_19804_.m_135381_(CURRENT_BLUE, (Object)Float.valueOf(curB));
    }

    private float lerp(float start, float target) {
        return start + 0.1f * (target - start);
    }

    private void orbit(Entity owner) {
        double angle = 0.05 * (double)this.m_9236_().m_46467_();
        double radius = 2.0;
        Vec3 orbitOffset = new Vec3(radius * Math.cos(angle), 0.0, radius * Math.sin(angle));
        Vec3 targetPos = new Vec3(owner.m_20185_(), owner.m_20186_(), owner.m_20189_()).m_82520_(0.0, (double)owner.m_20206_(), 0.0).m_82549_(orbitOffset);
        Vec3 vel = this.m_20184_();
        double K = 0.006;
        Vec3 accel = targetPos.m_82546_(this.m_20182_()).m_82490_(K).m_82546_(vel.m_82490_(2.0 * Math.sqrt(K)));
        vel = vel.m_82549_(accel);
        this.m_20256_(vel);
        this.m_6478_(MoverType.SELF, vel);
    }

    protected void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("TargetRed", ((Integer)this.f_19804_.m_135370_(TARGET_RED)).intValue());
        pCompound.m_128405_("TargetGreen", ((Integer)this.f_19804_.m_135370_(TARGET_GREEN)).intValue());
        pCompound.m_128405_("TargetBlue", ((Integer)this.f_19804_.m_135370_(TARGET_BLUE)).intValue());
        pCompound.m_128350_("CurrentRed", ((Float)this.f_19804_.m_135370_(CURRENT_RED)).floatValue());
        pCompound.m_128350_("CurrentGreen", ((Float)this.f_19804_.m_135370_(CURRENT_GREEN)).floatValue());
        pCompound.m_128350_("CurrentBlue", ((Float)this.f_19804_.m_135370_(CURRENT_BLUE)).floatValue());
    }

    protected void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("TargetRed")) {
            this.f_19804_.m_135381_(TARGET_RED, (Object)pCompound.m_128451_("TargetRed"));
            this.f_19804_.m_135381_(TARGET_GREEN, (Object)pCompound.m_128451_("TargetGreen"));
            this.f_19804_.m_135381_(TARGET_BLUE, (Object)pCompound.m_128451_("TargetBlue"));
        }
        if (pCompound.m_128441_("CurrentRed")) {
            this.f_19804_.m_135381_(CURRENT_RED, (Object)Float.valueOf(pCompound.m_128457_("CurrentRed")));
            this.f_19804_.m_135381_(CURRENT_GREEN, (Object)Float.valueOf(pCompound.m_128457_("CurrentGreen")));
            this.f_19804_.m_135381_(CURRENT_BLUE, (Object)Float.valueOf(pCompound.m_128457_("CurrentBlue")));
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", this::predicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 1, this::attackPredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "sizeController", 1, this::sizePredicate)});
    }

    private <T extends GeoAnimatable> PlayState attackPredicate(AnimationState<T> event) {
        SoulMageEntity mage;
        Entity entity = this.m_19749_();
        if (entity instanceof SoulMageEntity && (mage = (SoulMageEntity)entity).isAttacking() && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().setAnimation(this.OPEN);
            event.getController().forceAnimationReset();
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        event.getController().setAnimation(this.IDLE);
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState sizePredicate(AnimationState<T> event) {
        Entity entity = this.m_19749_();
        if (entity instanceof SoulMageEntity) {
            SoulMageEntity mage = (SoulMageEntity)entity;
            if (mage.m_21224_()) {
                event.getController().setAnimation(this.DEAD);
            } else if (this.f_19797_ < 20) {
                event.getController().setAnimation(this.SUMMON);
            }
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

