/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.summon;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.SummonFrogEntity;
import dev.xylonity.companions.common.entity.ai.cornelius.summon.goal.FireworkToadGoal;
import dev.xylonity.companions.common.entity.ai.cornelius.summon.goal.SummonHopToOwnerGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsSummonHurtTargetGoal;
import dev.xylonity.companions.common.util.interfaces.IFrogJumpUtil;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class FireworkToadEntity
extends SummonFrogEntity
implements IFrogJumpUtil {
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation FLY = RawAnimation.begin().thenPlay("fly");
    private final RawAnimation ROT = RawAnimation.begin().thenPlayAndHold("rot");
    private static final EntityDataAccessor<Vector3f> PARABOLA_CENTER = SynchedEntityData.m_135353_(FireworkToadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    private static final EntityDataAccessor<Boolean> FLY_ENABLED = SynchedEntityData.m_135353_(FireworkToadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public FireworkToadEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PARABOLA_CENTER, (Object)new Vector3f(0.0f, 0.0f, 0.0f));
        this.f_19804_.m_135372_(FLY_ENABLED, (Object)false);
    }

    public void setParabolaCenter(Vec3 center) {
        if (center == null) {
            this.f_19804_.m_135381_(PARABOLA_CENTER, (Object)new Vector3f(0.0f, 0.0f, 0.0f));
        } else {
            this.f_19804_.m_135381_(PARABOLA_CENTER, (Object)new Vector3f((float)center.f_82479_, (float)center.f_82480_, (float)center.f_82481_));
        }
    }

    private boolean isFlying() {
        return (Boolean)this.f_19804_.m_135370_(FLY_ENABLED);
    }

    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(FLY_ENABLED, (Object)flying);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.isFlying() && this.f_19797_ % 3 == 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * 0.15, this.m_20189_(), 0.0, -0.05, 0.0);
        }
    }

    public Vec3 getParabolaCenter() {
        Vector3f v = (Vector3f)this.f_19804_.m_135370_(PARABOLA_CENTER);
        if (v.x() == 0.0f && v.y() == 0.0f && v.z() == 0.0f) {
            return null;
        }
        return new Vec3((double)v.x(), (double)v.y(), (double)v.z());
    }

    public static AttributeSupplier setAttributes() {
        return TamableAnimal.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.55f).m_22268_(Attributes.f_22277_, 35.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new FireworkToadGoal(this, 20, 80));
        this.f_21345_.m_25352_(4, new SummonHopToOwnerGoal<FireworkToadEntity>(this, 0.725, 6.0f, 2.0f, false));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new CompanionsSummonHurtTargetGoal(this));
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "rot_controller", state -> PlayState.STOP).triggerableAnim("rot", this.ROT)});
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return CompanionsSounds.SMALL_FROG_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return CompanionsSounds.SMALL_FROG_HURT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return CompanionsSounds.SMALL_FROG_IDLE.get();
    }

    @Override
    protected SoundEvent jumpSound() {
        return CompanionsSounds.SMALL_FROG_JUMP.get();
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.isFlying()) {
            event.setAnimation(this.FLY);
        } else if (this.getCycleCount() >= 0) {
            event.setAnimation(this.WALK);
        } else {
            event.setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void setCanAttack(boolean canAttack) {
    }

    @Override
    public int getAttackType() {
        return 0;
    }
}

