/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.event;

import dev.xylonity.companions.common.blockentity.RespawnTotemBlockEntity;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="companions", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CompanionsEntityRespawnTracker {
    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        Player owner;
        TamableAnimal tame;
        UUID ownerId;
        LivingEntity dead = event.getEntity();
        CompoundTag originalTag = dead.getPersistentData();
        if (!originalTag.m_128441_("RespawnTotemPos")) {
            return;
        }
        if (!originalTag.m_128441_("RespawnTotemDim")) {
            return;
        }
        BlockPos pos = BlockPos.m_122022_((long)originalTag.m_128454_("RespawnTotemPos"));
        String dimId = originalTag.m_128461_("RespawnTotemDim");
        MinecraftServer mcServer = dead.m_9236_().m_7654_();
        if (mcServer == null) {
            return;
        }
        ServerLevel totemLevel = mcServer.m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(dimId)));
        if (totemLevel == null) {
            return;
        }
        BlockEntity blockEntity = totemLevel.m_7702_(pos);
        if (!(blockEntity instanceof RespawnTotemBlockEntity)) {
            return;
        }
        RespawnTotemBlockEntity totem = (RespawnTotemBlockEntity)blockEntity;
        if (totem.getCharges() <= 0) {
            totem.savedEntities.remove(dead.m_20148_());
            totem.m_6596_();
            return;
        }
        CompoundTag nbt = new CompoundTag();
        dead.m_20223_(nbt);
        nbt.m_128473_("DeathTime");
        nbt.m_128473_("HurtByTimestamp");
        nbt.m_128473_("HurtTime");
        nbt.m_128473_("FallFlying");
        nbt.m_128473_("Motion");
        nbt.m_128350_("Health", 1.0f);
        totem.queueRespawn(nbt, 20);
        totem.m_6596_();
        if (dead instanceof TamableAnimal && (ownerId = (tame = (TamableAnimal)dead).m_21805_()) != null && (owner = totemLevel.m_46003_(ownerId)) != null) {
            owner.m_213846_((Component)Component.m_237110_((String)"respawn_totem.companions.charges_remaining", (Object[])new Object[]{totem.getCharges() - 1}));
        }
    }
}

