/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.particle;

import dev.xylonity.knightlib.client.particle.AbstractRibbonTrailParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class SpiralLaserParticle
extends AbstractRibbonTrailParticle {
    private static final ResourceLocation TEXTURE = new ResourceLocation("companions", "textures/particle/trail4.png");
    private static final int TRAIL_SEGS = 16;
    private final Vec3 start;
    private final Vec3 end;
    private final Vec3 dir;
    private final Vec3 perp1;
    private final Vec3 perp2;
    private final double amplitude;
    private final double frequency;

    public SpiralLaserParticle(ClientLevel level, Vec3 start, Vec3 end, double amplitude, double frequency) {
        super(level, start.f_82479_, start.f_82480_, start.f_82481_, 0.0, 0.0, 0.0, 1.0f, 1.0f, 1.0f);
        this.start = start;
        this.end = end;
        this.amplitude = amplitude;
        this.frequency = frequency;
        this.dir = end.m_82546_(start).m_82541_();
        Vec3 up = new Vec3(0.0, 1.0, 0.0);
        if (Math.abs(this.dir.m_82526_(up)) > 0.9) {
            up = new Vec3(1.0, 0.0, 0.0);
        }
        this.perp1 = this.dir.m_82537_(up).m_82541_();
        this.perp2 = this.dir.m_82537_(this.perp1).m_82541_();
        this.f_107226_ = 0.0f;
        this.f_107225_ = 12;
    }

    protected ResourceLocation getRibbonSprite() {
        return TEXTURE;
    }

    protected int totalSegments() {
        return Math.min(16, (this.f_107224_ + 1) * 3);
    }

    public void m_5989_() {
        super.m_5989_();
        this.r = 0.8f;
        this.g = 0.19607843f;
        this.b = 0.21176471f - 0.2f * (float)(Math.sin((double)this.f_107224_ * 0.5) * 0.5 + 0.5);
        this.ribbonAlpha = 0.7f + 0.3f * (float)Math.abs(Math.sin((double)this.f_107224_ * this.frequency));
        if (this.f_107224_ >= this.f_107225_ - 4) {
            this.ribbonAlpha *= (float)(this.f_107225_ - this.f_107224_) / 4.0f;
        }
    }

    protected int m_6355_(float partialTicks) {
        return 0xF000F0;
    }

    protected Vec3 sampleTrailPoint(int idx, float partialTicks) {
        float t = (float)idx / 15.0f;
        Vec3 base = this.start.m_165921_(this.end, (double)t);
        double angle = (double)((float)this.f_107224_ + partialTicks) * this.frequency + (double)t * Math.PI * 2.0;
        return base.m_82549_(this.perp1.m_82490_(Math.cos(angle)).m_82549_(this.perp2.m_82490_(Math.sin(angle))).m_82490_(this.amplitude));
    }

    protected float getRibbonHeight() {
        return 0.2f * (1.0f + 0.2f * (float)Math.sin((double)((float)this.f_107224_ + 0.5f) * this.frequency));
    }
}

