/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.tesla.behaviour.dinamo;

import dev.xylonity.companions.common.blockentity.AbstractTeslaBlockEntity;
import dev.xylonity.companions.common.entity.companion.DinamoEntity;
import dev.xylonity.companions.common.event.CompanionsEntityTracker;
import dev.xylonity.companions.common.tesla.TeslaConnectionManager;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.common.util.interfaces.ITeslaGeneratorBehaviour;
import dev.xylonity.companions.common.util.interfaces.ITeslaUtil;
import dev.xylonity.companions.registry.CompanionsEffects;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DinamoPulseBehaviour
implements ITeslaGeneratorBehaviour {
    @Override
    public void tick(DinamoEntity dinamo) {
        if (dinamo.getCycleCounter() < 8) {
            dinamo.setAnimationStartTick(dinamo.getCycleCounter());
            dinamo.setActive(true);
        } else if (dinamo.getCycleCounter() == 8) {
            dinamo.setActive(false);
            dinamo.setAnimationStartTick(0);
        }
        if (dinamo.getCycleCounter() == 5) {
            Set<TeslaConnectionManager.ConnectionNode> nodes = TeslaConnectionManager.getInstance().getOutgoing(dinamo.asConnectionNode());
            for (TeslaConnectionManager.ConnectionNode node : nodes) {
                Vec3 end;
                BlockEntity be;
                if (!node.isEntity() && (be = dinamo.m_9236_().m_7702_(node.blockPos())) instanceof AbstractTeslaBlockEntity) {
                    AbstractTeslaBlockEntity coil = (AbstractTeslaBlockEntity)be;
                    coil.startCycle();
                }
                Vec3 start = dinamo.m_20182_();
                if (node.isBlock()) {
                    end = node.blockPos().m_252807_();
                } else {
                    Entity entity = CompanionsEntityTracker.getEntityByUUID(node.entityId());
                    if (entity != null) {
                        end = entity.m_20182_().m_82520_(0.0, (double)entity.m_20206_() * 0.5, 0.0);
                    } else {
                        return;
                    }
                }
                List entities = dinamo.m_9236_().m_45976_(LivingEntity.class, new AABB(start, end).m_82400_(1.0));
                this.hurtNearLine(dinamo, dinamo.m_9236_(), entities, start, end);
            }
        }
        if (dinamo.getCycleCounter() >= 14) {
            dinamo.setCycleCounter(0);
        }
        dinamo.setCycleCounter(dinamo.getCycleCounter() + 1);
    }

    private void hurtNearLine(DinamoEntity dinamo, Level level, List<LivingEntity> entitiesToHurt, Vec3 origin, Vec3 end) {
        for (LivingEntity victim : entitiesToHurt) {
            if (!ITeslaUtil.isEntityNearLine(origin, end, (Entity)victim, 0.75) || !(level instanceof ServerLevel)) continue;
            ServerLevel sv = (ServerLevel)level;
            if (dinamo.m_21805_() == null || Util.areEntitiesLinked((Entity)dinamo, (Entity)victim) || Util.areEntitiesLinked(sv.m_8791_(dinamo.m_21805_()), (Entity)victim)) continue;
            victim.m_6469_(victim.m_9236_().m_269111_().m_269548_(), 7.0f);
            victim.m_7292_(new MobEffectInstance(CompanionsEffects.ELECTROSHOCK.get(), 50, 0, false, true, true));
        }
    }
}

