/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.mixin;

import dev.xylonity.companions.CompanionsCommon;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Raid.class})
public abstract class IllagerGolemRaidMixin {
    @Shadow
    @Final
    private int f_37686_;
    @Shadow
    @Final
    private RandomSource f_37685_;
    @Unique
    private static final int[] COMPANIONS_ILLAGER_GOLEM_SPAWNWAVE = new int[]{0, 1, 0, 2, 0, 1, 0, 2};

    @Shadow
    public abstract int m_37771_();

    @Shadow
    public abstract Level m_37769_();

    @Shadow
    public abstract void m_37713_(int var1, Raider var2, @Nullable BlockPos var3, boolean var4);

    @Shadow
    protected abstract boolean m_37702_();

    @Inject(method={"spawnGroup"}, at={@At(value="HEAD")})
    private void companions$addCustomEntity(BlockPos pos, CallbackInfo ci) {
        boolean bonus;
        int wave = this.m_37771_() + 1;
        int numIllagerGolems = this.companions$getDefaultNumSpawns(COMPANIONS_ILLAGER_GOLEM_SPAWNWAVE, wave, bonus = this.m_37702_()) + this.companions$getCustomBonusSpawns(this.f_37685_, wave, this.m_37769_().m_6436_(pos), bonus);
        if (numIllagerGolems <= 0) {
            return;
        }
        for (int i = 0; i < numIllagerGolems; ++i) {
            Raider raider = (Raider)CompanionsCommon.COMMON_PLATFORM.getIllagerGolemEntity().m_20615_(this.m_37769_());
            if (raider == null) continue;
            raider.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5);
            this.m_37713_(wave, raider, pos, false);
        }
    }

    @Unique
    private int companions$getDefaultNumSpawns(int[] waves, int pWave, boolean bonus) {
        int idx;
        int n = idx = bonus ? this.f_37686_ : pWave;
        if (idx < 0) {
            idx = 0;
        }
        if (idx >= waves.length) {
            int mod = idx & 3;
            return mod == 1 ? 1 : (mod == 3 ? 2 : 0);
        }
        return waves[idx];
    }

    @Unique
    private int companions$getCustomBonusSpawns(RandomSource random, int wave, DifficultyInstance difficultyInstance, boolean shouldSpawnBonusGroup) {
        int potentialSpawns;
        boolean isNormal;
        Difficulty difficulty = difficultyInstance.m_19048_();
        boolean isEasy = difficulty == Difficulty.EASY;
        boolean bl = isNormal = difficulty == Difficulty.NORMAL;
        if (isEasy) {
            potentialSpawns = wave > 2 ? random.m_188503_(2) : 0;
        } else if (isNormal) {
            potentialSpawns = wave > 3 ? random.m_188503_(2) + 1 : 1;
        } else {
            int n = potentialSpawns = wave > 4 ? 2 : 1;
            if (shouldSpawnBonusGroup) {
                ++potentialSpawns;
            }
        }
        return potentialSpawns > 0 ? random.m_188503_(potentialSpawns + 1) : 0;
    }
}

