/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.entity.renderer;

import dev.xylonity.companions.client.entity.model.IllagerGolemModel;
import dev.xylonity.companions.common.entity.hostile.IllagerGolemEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class IllagerGolemRenderer
extends GeoEntityRenderer<IllagerGolemEntity> {
    public IllagerGolemRenderer(class_5617.class_5618 renderManager, int totalFrames, int ticksPerFrame) {
        super(renderManager, (GeoModel)new IllagerGolemModel());
        this.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer((GeoRenderer)this));
        this.addRenderLayer(new ElectricConnectionLayer((GeoRenderer<IllagerGolemEntity>)this, class_2960.method_60655((String)"companions", (String)"textures/misc/illager_golem_electric_arch.png"), totalFrames, ticksPerFrame));
        this.field_4673 = 1.0f;
    }

    public IllagerGolemRenderer(class_5617.class_5618 renderManager) {
        this(renderManager, 8, 1);
    }

    private static class ElectricConnectionLayer
    extends GeoRenderLayer<IllagerGolemEntity> {
        private final class_2960 texture;
        private final int totalFrames;
        private final int ticksPerFrame;

        public ElectricConnectionLayer(GeoRenderer<IllagerGolemEntity> renderer, class_2960 texture, int totalFrames, int ticksPerFrame) {
            super(renderer);
            this.texture = texture;
            this.totalFrames = totalFrames;
            this.ticksPerFrame = ticksPerFrame;
        }

        public void render(class_4587 poseStack, IllagerGolemEntity animatable, BakedGeoModel bakedModel, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay) {
            if (!animatable.isActive()) {
                return;
            }
            int frame = this.calculateCurrentFrame(animatable);
            if (frame < 0) {
                return;
            }
            for (class_1297 e : animatable.visibleEntities) {
                class_243 offset = new class_243(0.0, (double)animatable.method_17682() * 0.95, 0.0);
                class_243 direction = e.method_19538().method_1020(animatable.method_19538()).method_1031(0.0, (double)e.method_17682() * 0.5, 0.0);
                this.renderConnection(bufferSource, poseStack, offset, direction, frame, packedLight);
            }
        }

        private int calculateCurrentFrame(IllagerGolemEntity animatable) {
            int elapsedTicks = animatable.getTickCount() - animatable.getAnimationStartTick();
            int frame = elapsedTicks / this.ticksPerFrame;
            if (frame >= this.totalFrames) {
                return -1;
            }
            return frame;
        }

        private void renderConnection(class_4597 bufferSource, class_4587 poseStack, class_243 p0, class_243 p1, int frame, int light) {
            int[] indices;
            class_4588 vertexConsumer = bufferSource.getBuffer(class_1921.method_23576((class_2960)this.texture));
            Matrix4f positionMatrix = poseStack.method_23760().method_23761();
            Matrix3f normalMatrix = poseStack.method_23760().method_23762();
            float x0 = (float)p0.field_1352;
            float y0 = (float)p0.field_1351;
            float z0 = (float)p0.field_1350;
            float x1 = (float)p1.field_1352;
            float y1 = (float)p1.field_1351;
            float z1 = (float)p1.field_1350;
            float dx = x1 - x0;
            float dy = y1 - y0;
            float dz = z1 - z0;
            if (dx == 0.0f) {
                dx = 0.001f;
            }
            float dHorizontal = class_3532.method_15355((float)(dx * dx + dz * dz));
            float length = class_3532.method_15355((float)(dHorizontal * dHorizontal + dy * dy));
            float offset = 0.5f;
            float yOffset = offset * (dHorizontal / length);
            float xOffset = offset * (dy / length) * (dx / dHorizontal);
            float zOffset = offset * (dy / length) * (dz / dHorizontal);
            float frameSize = 1.0f / (float)this.totalFrames;
            float v0 = (float)frame * frameSize;
            float v1 = v0 + frameSize;
            VertexCoordinates[] vertices = new VertexCoordinates[]{new VertexCoordinates(x0 + xOffset, y0 - yOffset, z0 + zOffset, 0.0f, v1), new VertexCoordinates(x1 + xOffset, y1 - yOffset, z1 + zOffset, 1.0f, v1), new VertexCoordinates(x1 - xOffset, y1 + yOffset, z1 - zOffset, 1.0f, v0), new VertexCoordinates(x0 - xOffset, y0 + yOffset, z0 - zOffset, 0.0f, v0)};
            for (int i : indices = new int[]{0, 1, 2, 3, 3, 2, 1, 0}) {
                this.produceVertex(vertexConsumer, positionMatrix, poseStack, light, vertices[i].x, vertices[i].y, vertices[i].z, vertices[i].u, vertices[i].v);
            }
        }

        private void produceVertex(class_4588 vertexConsumer, Matrix4f positionMatrix, class_4587 poseStack, int light, float x, float y, float z, float textureU, float textureV) {
            vertexConsumer.method_22918(positionMatrix, x, y, z).method_1336(255, 255, 255, 255).method_22913(textureU, textureV).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(poseStack.method_23760(), 0.0f, 1.0f, 0.0f);
        }

        private record VertexCoordinates(float x, float y, float z, float u, float v) {
        }
    }
}

