/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.xylonity.companions.common.container.CorneliusContainerMenu;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_5244;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;

public class CorneliusScreen
extends class_465<CorneliusContainerMenu> {
    private static final class_2960 TEX_TOP = class_2960.method_60655((String)"companions", (String)"textures/gui/cornelius_gui_top.png");
    private static final class_2960 TEX_BOTTOM = class_2960.method_60655((String)"companions", (String)"textures/gui/cornelius_gui_bottom.png");
    private static final int ANIM_TICKS = 8;
    private static final int DEAL_INTERVAL_TICKS = 6;
    private int dealDelay = 0;
    private final ArrayDeque<Boolean> dealQueue = new ArrayDeque();
    private int resultTicks = 0;
    private final List<FrogCard> playerCards = new ArrayList<FrogCard>();
    private final List<FrogCard> dealerCards = new ArrayList<FrogCard>();
    private FrogCard hoveredCard = null;
    private static final float LERP_DELTA = 0.235f;
    private static final int END_GAME_TIME = 30;
    private static final int CARD_W = 24;
    private static final int CARD_H = 36;
    private static final int V_BACK = 144;
    private static final int PLAYER_Y = 13;
    private static final int DEALER_Y = -41;
    private static final int START_Y = -50;
    private static final int SPACING_PLAYER = -10;
    private static final int SPACING_DEALER = -14;
    private static final int MARGIN_PLAYER = 79;
    private static final int MARGIN_DEALER = 74;
    private static final float HOVER_SCALE = 1.25f;
    private static final float HOVER_W = 30.0f;
    private static final float HOVER_H = 45.0f;
    private class_4185 btnHit;
    private class_4185 btnStand;
    private boolean hitButtonPressed = false;
    private boolean standButtonPressed = false;
    private Phase phase = Phase.WAITING_PLAY;
    private Result result;
    private Result pendingResult = null;

    public CorneliusScreen(CorneliusContainerMenu container, class_1661 inv, class_2561 title) {
        super((class_1703)container, inv, title);
        this.field_2779 = 216;
        this.field_2792 = 208;
    }

    private int generalMarginLeft() {
        return (this.field_22789 - this.field_2792) / 2;
    }

    private int generalMarginTop() {
        return (this.field_22790 - this.field_2779) / 2;
    }

    private FrogCard newCard2Player() {
        return new FrogCard((float)(this.field_22789 - 24) / 2.0f, -50.0f, this.generalMarginLeft() + 79 + this.playerCards.size() * 14, this.generalMarginTop() + 13 + 17, new Random().nextInt(13) + 1, true);
    }

    private FrogCard newCard2Crupier() {
        int idx = this.dealerCards.size();
        float targetX = this.generalMarginLeft() + 74 + idx * 10;
        if (idx >= 1) {
            targetX += 10.0f;
        }
        return new FrogCard((float)(this.field_22789 - 24) / 2.0f, -50.0f, targetX, this.generalMarginTop() + -41, new Random().nextInt(13) + 1, idx != 0);
    }

    protected void method_25426() {
        super.method_25426();
        this.btnHit = this.method_37063(new ImageButtonWrapper(this.generalMarginLeft() + 96, this.generalMarginTop() + 13 + 100, 43, 29, 0, 227, 256, 256, TEX_TOP, b -> {
            int c = 0;
            for (int i = 3; i <= 5; ++i) {
                if (!((class_1735)((CorneliusContainerMenu)this.field_2797).field_7761.get(i)).method_7677().method_7960()) continue;
                ++c;
            }
            if (c == 3) {
                return;
            }
            if (this.phase == Phase.WAITING_PLAY) {
                this.startGame();
            } else if (this.phase == Phase.PLAYER_TURN) {
                this.onHit();
            }
        }){

            public void method_25306() {
                super.method_25306();
                if (CorneliusScreen.this.phase != Phase.WAITING_PLAY) {
                    CorneliusScreen.this.hitButtonPressed = true;
                }
            }

            @Override
            public void method_48579(@NotNull class_332 g, int mx, int my, float pt) {
                if (CorneliusScreen.this.hitButtonPressed) {
                    g.method_25302(TEX_TOP, this.method_46426(), this.method_46427(), 0, 227, 43, 29);
                }
            }
        });
        this.btnStand = this.method_37063(new ImageButtonWrapper(this.generalMarginLeft() + 135, this.generalMarginTop() + 13 + 100, 43, 29, 0, 227, 256, 256, TEX_TOP, b -> this.onStand()){

            public void method_25306() {
                super.method_25306();
                if (CorneliusScreen.this.phase != Phase.WAITING_PLAY) {
                    CorneliusScreen.this.standButtonPressed = true;
                }
            }

            @Override
            public void method_48579(@NotNull class_332 g, int mx, int my, float pt) {
                if (CorneliusScreen.this.standButtonPressed) {
                    g.method_25302(TEX_TOP, this.method_46426(), this.method_46427(), 211, 227, 46, 29);
                }
            }
        });
    }

    private HandValue fullHandValue(List<FrogCard> cards) {
        int total = 0;
        int aces = 0;
        for (FrogCard card : cards) {
            int v = card.value;
            if (v == 1) {
                total += 11;
                ++aces;
                continue;
            }
            total += Math.min(v, 10);
        }
        while (total > 21 && aces > 0) {
            total -= 10;
            --aces;
        }
        return new HandValue(total, aces > 0);
    }

    public void method_25410(@NotNull class_310 mc, int width, int height) {
        int oldLeft = this.generalMarginLeft();
        int oldTop = this.generalMarginTop();
        super.method_25410(mc, width, height);
        CorneliusScreen.shiftCards(this.playerCards, this.generalMarginLeft() - oldLeft, this.generalMarginTop() - oldTop);
        CorneliusScreen.shiftCards(this.dealerCards, this.generalMarginLeft() - oldLeft, this.generalMarginTop() - oldTop);
    }

    private static void shiftCards(List<FrogCard> list, int dx, int dy) {
        for (FrogCard card : list) {
            card.x += (float)dx;
            card.prevX += (float)dx;
            card.targetX += (float)dx;
            card.y += (float)dy;
            card.prevY += (float)dy;
            card.targetY += (float)dy;
        }
    }

    private void startGame() {
        this.phase = Phase.DEALING;
        this.playerCards.clear();
        this.dealerCards.clear();
        this.dealQueue.clear();
        this.dealQueue.addAll(List.of(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        this.dealDelay = 0;
        class_310 mc = class_310.method_1551();
        if (mc.field_1761 != null) {
            mc.field_1761.method_2900(((CorneliusContainerMenu)this.field_2797).field_7763, 0);
        }
    }

    private void onHit() {
        if (this.phase != Phase.PLAYER_TURN) {
            return;
        }
        this.dealQueue.add(true);
        this.btnHit.field_22763 = false;
        this.btnStand.field_22763 = false;
        this.phase = Phase.DEALING;
        this.dealDelay = 0;
    }

    private void onStand() {
        if (this.phase != Phase.PLAYER_TURN) {
            return;
        }
        if (!this.dealerCards.isEmpty()) {
            this.dealerCards.get(0).startFlip();
        }
        this.phase = Phase.DEALER_TURN;
        this.btnHit.field_22764 = false;
        this.btnStand.field_22764 = true;
        this.dealDelay = 6;
        this.standButtonPressed = false;
    }

    protected void method_37432() {
        super.method_37432();
        switch (this.phase.ordinal()) {
            case 1: {
                this.tickCards();
                if (this.dealDelay > 0) {
                    --this.dealDelay;
                }
                if (this.dealDelay == 0 && !this.dealQueue.isEmpty()) {
                    this.spawnNextCard(this.dealQueue.poll());
                    this.dealDelay = 6;
                }
                if (!this.dealQueue.isEmpty() || !this.allArrived()) break;
                this.finishDealing();
                break;
            }
            case 2: {
                if (this.handValue(this.playerCards).total == 21) {
                    this.showResult(Result.BLACKJACK);
                }
                if (this.handValue(this.playerCards).total > 21) {
                    this.showResult(Result.LOSE);
                }
                if (this.handValue(this.dealerCards).total > 21) {
                    this.showResult(Result.WIN);
                }
                if (this.handValue(this.dealerCards).total != 21) break;
                this.showResult(Result.LOSE);
                break;
            }
            case 3: {
                this.tickCards();
                if (this.dealDelay > 0) {
                    --this.dealDelay;
                    break;
                }
                if (this.fullHandValue(this.dealerCards).total < 17 || this.fullHandValue(this.dealerCards).total == 17 && this.fullHandValue(this.dealerCards).soft) {
                    this.spawnNextCard(false);
                    this.dealDelay = 6;
                    break;
                }
                if (!this.allArrived() || !this.noCardIsFlipping()) break;
                this.evaluateGame();
                break;
            }
            case 4: {
                if (++this.resultTicks < 30) break;
                this.resetToWaitingPlay();
                break;
            }
        }
        if (this.pendingResult != null && this.allArrived() && this.noCardIsFlipping()) {
            this.showResult(this.pendingResult);
            this.pendingResult = null;
        }
    }

    private boolean noCardIsFlipping() {
        return Stream.concat(this.playerCards.stream(), this.dealerCards.stream()).noneMatch(card -> card.flipping);
    }

    private boolean tickCards() {
        boolean all = true;
        for (FrogCard card : this.playerCards) {
            if (card.tick(0.235f)) continue;
            all = false;
        }
        for (FrogCard card : this.dealerCards) {
            if (card.tick(0.235f)) continue;
            all = false;
        }
        return all;
    }

    private void spawnNextCard(boolean toPlayer) {
        if (toPlayer) {
            this.playerCards.add(this.newCard2Player());
        } else {
            this.dealerCards.add(this.newCard2Crupier());
        }
        if (this.field_22787 != null) {
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)CompanionsSounds.FLIP_CARD.get(), (float)1.0f));
        }
    }

    private boolean allArrived() {
        for (FrogCard card : this.playerCards) {
            if (card.arrived) continue;
            return false;
        }
        for (FrogCard card : this.dealerCards) {
            if (card.arrived) continue;
            return false;
        }
        return true;
    }

    private void finishDealing() {
        if (this.phase != Phase.DEALING) {
            return;
        }
        if (this.playerCards.size() == 2 && this.handValue(this.playerCards).total == 21) {
            this.showResult(Result.BLACKJACK);
            return;
        }
        if (this.dealerCards.size() == 2 && this.handValue(this.dealerCards).total == 21) {
            this.showResult(Result.LOSE);
            return;
        }
        this.phase = Phase.PLAYER_TURN;
        this.btnStand.field_22764 = true;
        this.btnHit.field_22764 = true;
        this.btnStand.field_22763 = true;
        this.btnHit.field_22763 = true;
        this.standButtonPressed = false;
        this.hitButtonPressed = false;
    }

    private void evaluateGame() {
        int player = this.handValue(this.playerCards).total;
        int frog = this.handValue(this.dealerCards).total;
        this.pendingResult = player > 21 ? Result.LOSE : (frog > 21 ? Result.WIN : (player == frog ? Result.TIE : (player > frog ? Result.WIN : Result.LOSE)));
    }

    private void showResult(Result result) {
        this.result = result;
        this.phase = Phase.SHOW_RESULT;
        this.resultTicks = 0;
        this.btnStand.field_22764 = false;
        this.btnHit.field_22764 = false;
        int action = switch (result.ordinal()) {
            case 0 -> 4;
            case 3 -> 5;
            case 2 -> 3;
            default -> 2;
        };
        class_310 mc = class_310.method_1551();
        if (mc.field_1761 != null) {
            mc.field_1761.method_2900(((CorneliusContainerMenu)this.field_2797).field_7763, action);
        }
    }

    private void resetToWaitingPlay() {
        this.phase = Phase.WAITING_PLAY;
        this.playerCards.clear();
        this.dealerCards.clear();
        this.dealQueue.clear();
        this.dealDelay = 0;
        this.btnHit.field_22764 = true;
        this.btnHit.field_22763 = true;
        this.btnStand.field_22764 = false;
        class_310 mc = class_310.method_1551();
        if (mc.field_1761 != null) {
            mc.field_1761.method_2900(((CorneliusContainerMenu)this.field_2797).field_7763, 1);
        }
    }

    private void renderResultOverlay(class_332 g) {
        int w;
        int v;
        int u;
        if (this.phase != Phase.SHOW_RESULT) {
            return;
        }
        int h = switch (this.result.ordinal()) {
            case 0 -> {
                u = 41;
                v = 83;
                w = 69;
                yield 44;
            }
            case 2 -> {
                u = 40;
                v = 135;
                w = 55;
                yield 29;
            }
            case 3 -> {
                u = 113;
                v = 136;
                w = 91;
                yield 61;
            }
            default -> {
                u = 123;
                v = 83;
                w = 78;
                yield 42;
            }
        };
        float bScale = this.resultTicks < 8 ? (float)this.resultTicks / 8.0f : (this.resultTicks > 22 ? (float)(30 - this.resultTicks) / 8.0f : 1.0f);
        bScale = class_3532.method_15363((float)bScale, (float)0.0f, (float)1.0f);
        float scale = Util.smoothStep(bScale);
        g.method_51448().method_22903();
        g.method_51448().method_46416((float)this.field_22789 / 2.0f, (float)this.field_22790 / 2.0f - 70.0f, 0.0f);
        g.method_51448().method_22905(scale * 1.25f, scale * 1.25f, 1.0f);
        g.method_51448().method_46416((float)(-w) / 2.0f, (float)(-h) / 2.0f, 0.0f);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEX_TOP);
        g.method_25302(TEX_TOP, 0, 0, u, v, w, h);
        g.method_51448().method_22909();
    }

    private void updateHoveredCard(int mx, int my, float pt) {
        if (this.hoveredCard != null) {
            float cx = class_3532.method_16439((float)pt, (float)this.hoveredCard.prevX, (float)this.hoveredCard.x) + 12.0f;
            float cy = class_3532.method_16439((float)pt, (float)this.hoveredCard.prevY, (float)this.hoveredCard.y) + 18.0f;
            if ((float)mx >= cx - 15.0f && (float)mx < cx + 15.0f && (float)my >= cy - 22.5f && (float)my < cy + 22.5f) {
                return;
            }
            this.hoveredCard = null;
        }
        for (int i = this.playerCards.size() - 1; i >= 0; --i) {
            FrogCard card = this.playerCards.get(i);
            if (!card.faceUp) continue;
            float dx = class_3532.method_16439((float)pt, (float)card.prevX, (float)card.x);
            float dy = class_3532.method_16439((float)pt, (float)card.prevY, (float)card.y);
            if (!((float)mx >= dx) || !((float)mx < dx + 24.0f) || !((float)my >= dy) || !((float)my < dy + 36.0f)) continue;
            this.hoveredCard = card;
            break;
        }
    }

    private void renderCards(class_332 g, float pt, int mx, int my) {
        for (FrogCard card : this.dealerCards) {
            this.renderCard(g, card, pt);
        }
        if (this.hoveredCard == null) {
            for (FrogCard card : this.playerCards) {
                this.renderCard(g, card, pt);
            }
        } else {
            int i;
            int idx = this.playerCards.indexOf(this.hoveredCard);
            for (i = 0; i < idx; ++i) {
                this.renderCard(g, this.playerCards.get(i), pt);
            }
            this.renderHoveredCard(g, pt, mx, my);
            for (i = idx + 1; i < this.playerCards.size(); ++i) {
                this.renderCard(g, this.playerCards.get(i), pt);
            }
        }
    }

    private void renderHoveredCard(class_332 g, float pt, int mx, int my) {
        if (this.hoveredCard == null) {
            return;
        }
        float dx = class_3532.method_16439((float)pt, (float)this.hoveredCard.prevX, (float)this.hoveredCard.x);
        float dy = class_3532.method_16439((float)pt, (float)this.hoveredCard.prevY, (float)this.hoveredCard.y);
        float centerX = dx + 12.0f;
        float centerY = dy + 18.0f;
        float tilt = 25.0f;
        float tiltY = ((float)mx - centerX) / 12.0f * tilt;
        float tiltX = -((float)my - centerY) / 18.0f * tilt;
        g.method_51448().method_22903();
        g.method_51448().method_46416(centerX, centerY, 10.0f);
        g.method_51448().method_22905(1.25f, 1.25f, 1.0f);
        g.method_51448().method_46416(-centerX, -centerY, 0.0f);
        this.renderCardAt(g, this.hoveredCard, (int)dx, (int)dy, tiltX, tiltY);
        g.method_51448().method_22909();
    }

    protected void method_2389(class_332 g, float pt, int mx, int my) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEX_TOP);
        RenderSystem.setShaderTexture((int)1, (class_2960)TEX_BOTTOM);
        g.method_25302(TEX_TOP, (this.field_22789 - 207) / 2, this.generalMarginTop() - 50, 45, 44, 208, 20);
        g.method_25302(TEX_BOTTOM, (this.field_22789 - 207) / 2, this.generalMarginTop() - 30, 45, 0, 208, 256);
    }

    private void renderCard(class_332 g, FrogCard c, float pt) {
        this.renderCardAt(g, c, (int)class_3532.method_16439((float)pt, (float)c.prevX, (float)c.x), (int)class_3532.method_16439((float)pt, (float)c.prevY, (float)c.y), 0.0f, 0.0f);
    }

    private void renderCardAt(class_332 g, FrogCard card, int dx, int dy, float tiltX, float tiltY) {
        RenderSystem.disableCull();
        g.method_51448().method_22903();
        g.method_51448().method_46416((float)dx + 12.0f, (float)dy + 18.0f, 40.0f);
        g.method_51448().method_22907(class_7833.field_40714.rotationDegrees(tiltX));
        g.method_51448().method_22907(class_7833.field_40716.rotationDegrees(tiltY));
        g.method_51448().method_22907(class_7833.field_40716.rotationDegrees(card.getFlipAngle()));
        g.method_51448().method_46416(-((float)dx + 12.0f), -((float)dy + 18.0f), 0.0f);
        if (card.faceUp) {
            int u = card.value <= 10 ? (card.value - 1) * 24 : 0;
            int v = card.value <= 10 ? 0 : (card.value - 10) * 36;
            g.method_25302(TEX_TOP, dx, dy, u, v, 24, 36);
        } else {
            g.method_25302(TEX_TOP, dx, dy, 0, 144, 24, 36);
        }
        g.method_51448().method_22909();
        RenderSystem.enableCull();
    }

    public void method_25394(@NotNull class_332 g, int mx, int my, float pt) {
        this.updateHoveredCard(mx, my, pt);
        this.method_25420(g, mx, my, pt);
        super.method_25394(g, mx, my, pt);
        RenderSystem.disableDepthTest();
        this.renderCards(g, pt, mx, my);
        this.renderHoveredCard(g, pt, mx, my);
        this.renderResultOverlay(g);
        RenderSystem.enableDepthTest();
        this.method_2380(g, mx, my);
    }

    protected void method_2388(@NotNull class_332 g, int mx, int my) {
        if (this.handValue(this.playerCards).total != 0) {
            g.method_25303(this.field_22793, String.valueOf(this.handValue(this.playerCards).total), 46, 57, 12826189);
        }
        if (this.handValue(this.dealerCards).total != 0) {
            g.method_25303(this.field_22793, String.valueOf(this.handValue(this.dealerCards).total), 34, -42, 12826189);
        }
    }

    @NotNull
    protected <T extends class_364 & class_4068> T method_37063(@NotNull T w) {
        return (T)super.method_37063(w);
    }

    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        if ((pKeyCode == class_310.method_1551().field_1690.field_1822.method_1429().method_1444() || pKeyCode == 256) && this.phase != Phase.WAITING_PLAY) {
            return true;
        }
        return super.method_25404(pKeyCode, pScanCode, pModifiers);
    }

    public void method_25419() {
        if (this.phase == Phase.WAITING_PLAY) {
            super.method_25419();
        }
    }

    private HandValue handValue(List<FrogCard> cards) {
        int total = 0;
        int aces = 0;
        for (FrogCard c : cards) {
            if (!c.faceUp) continue;
            int v = c.value;
            if (v == 1) {
                total += 11;
                ++aces;
                continue;
            }
            total += Math.min(v, 10);
        }
        while (total > 21 && aces > 0) {
            total -= 10;
            --aces;
        }
        return new HandValue(total, aces > 0);
    }

    private static class FrogCard {
        public float x;
        public float y;
        public float prevX;
        public float prevY;
        public float targetX;
        public float targetY;
        public final int value;
        public boolean faceUp;
        public boolean arrived = false;
        public boolean flipping = false;
        public int flipTick = 0;
        public static final int FLIP_TOTAL = 20;

        public FrogCard(float startX, float startY, float targetX, float targetY, int value, boolean faceUp) {
            this.x = startX;
            this.y = startY;
            this.prevX = startX;
            this.prevY = startY;
            this.targetX = targetX;
            this.targetY = targetY;
            this.value = value;
            this.faceUp = faceUp;
        }

        public void startFlip() {
            if (!this.faceUp && !this.flipping) {
                this.flipping = true;
                this.flipTick = 0;
            }
        }

        public boolean tick(float s) {
            if (this.flipping) {
                ++this.flipTick;
                if ((float)this.flipTick == 10.0f) {
                    this.faceUp = true;
                }
                if (this.flipTick >= 20) {
                    this.flipping = false;
                }
            }
            if (this.arrived) {
                this.prevX = this.x;
                this.prevY = this.y;
                return true;
            }
            this.prevX = this.x;
            this.prevY = this.y;
            this.x += (this.targetX - this.x) * s;
            this.y += (this.targetY - this.y) * s;
            if (Math.abs(this.x - this.targetX) < 0.5f && Math.abs(this.y - this.targetY) < 0.5f) {
                this.x = this.targetX;
                this.y = this.targetY;
                this.prevX = this.targetX;
                this.prevY = this.targetY;
                this.arrived = true;
            }
            return this.arrived;
        }

        public float getFlipAngle() {
            if (!this.flipping) {
                return 0.0f;
            }
            float half = 10.0f;
            if ((float)this.flipTick <= half) {
                return 90.0f * ((float)this.flipTick / half);
            }
            return 90.0f * (1.0f - ((float)this.flipTick - half) / half);
        }
    }

    private static enum Phase {
        WAITING_PLAY,
        DEALING,
        PLAYER_TURN,
        DEALER_TURN,
        SHOW_RESULT;

    }

    private static enum Result {
        WIN,
        LOSE,
        TIE,
        BLACKJACK;

    }

    private record HandValue(int total, boolean soft) {
    }

    public static class ImageButtonWrapper
    extends class_4185 {
        private final class_2960 atlas;
        private final int u;
        private final int v;
        private final int texWidth;
        private final int texHeight;

        public ImageButtonWrapper(int x, int y, int width, int height, int u, int v, int texWidth, int texHeight, class_2960 atlas, class_4185.class_4241 onPress) {
            super(x, y, width, height, class_5244.field_39003, onPress, field_40754);
            this.u = u;
            this.v = v;
            this.texWidth = texWidth;
            this.texHeight = texHeight;
            this.atlas = atlas;
        }

        public void method_48579(class_332 gui, int mouseX, int mouseY, float partialTick) {
            gui.method_25290(this.atlas, this.method_46426(), this.method_46427(), (float)this.u, (float)this.v, this.field_22758, this.field_22759, this.texWidth, this.texHeight);
        }
    }
}

