/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.blockentity;

import dev.xylonity.companions.common.blockentity.AbstractTeslaBlockEntity;
import dev.xylonity.companions.common.tesla.TeslaConnectionManager;
import dev.xylonity.companions.common.tesla.behaviour.platform.RecallPlatformPulseBehaviour;
import dev.xylonity.companions.common.util.interfaces.ITeslaNodeBehaviour;
import dev.xylonity.companions.registry.CompanionsBlockEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public class RecallPlatformBlockEntity
extends AbstractTeslaBlockEntity {
    private static final int COOLDOWN_TICKS = 20;
    private final Set<class_2338> partnerPositions = new HashSet<class_2338>();
    private int cooldown = 0;
    private final ITeslaNodeBehaviour pulseBehaviour = new RecallPlatformPulseBehaviour();

    public RecallPlatformBlockEntity(class_2338 pos, class_2680 st) {
        super(CompanionsBlockEntities.RECALL_PLATFORM, pos, st);
    }

    public static <T extends class_2586> void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, T t) {
        if (!(t instanceof RecallPlatformBlockEntity)) {
            return;
        }
        RecallPlatformBlockEntity platform = (RecallPlatformBlockEntity)t;
        platform.cooldown = level.method_18467(class_1657.class, new class_238(platform.method_11016()).method_989(0.0, 1.0, 0.0).method_1014(0.5)).isEmpty() ? 20 : --platform.cooldown;
        platform.pulseBehaviour.process(platform, level, blockPos, blockState);
        ++platform.tickCount;
        platform.sync();
    }

    public void onStepped(class_3222 player) {
        if (this.cooldown > 0 || !this.isActive()) {
            return;
        }
        if (this.method_10997() == null) {
            return;
        }
        ArrayList<class_2338> shuffled = new ArrayList<class_2338>(this.partnerPositions);
        Collections.shuffle(shuffled, new Random());
        for (class_2338 target : shuffled) {
            class_2586 class_25862 = this.method_10997().method_8321(target);
            if (!(class_25862 instanceof RecallPlatformBlockEntity)) {
                this.partnerPositions.remove(target);
                this.method_5431();
                continue;
            }
            RecallPlatformBlockEntity otherPlatform = (RecallPlatformBlockEntity)class_25862;
            TeslaConnectionManager manager = TeslaConnectionManager.getInstance();
            if (!manager.getConnectedComponent(this.asConnectionNode()).contains(otherPlatform.asConnectionNode())) {
                this.partnerPositions.remove(target);
                this.method_5431();
                continue;
            }
            if (this.field_11863 != null) {
                this.field_11863.method_8396(null, this.method_11016(), CompanionsSounds.TEDDY_TRANSFORMATION.get(), class_3419.field_15245, 1.0f, 1.0f);
            }
            player.method_5859((double)target.method_10263() + 0.5, (double)(target.method_10264() + 1), (double)target.method_10260() + 0.5);
            if (this.field_11863 != null) {
                this.field_11863.method_8396(null, target, CompanionsSounds.TEDDY_TRANSFORMATION.get(), class_3419.field_15245, 1.0f, 1.0f);
            }
            this.cooldown = 20;
            otherPlatform.cooldown = 20;
            return;
        }
    }

    public void updatePartners(Set<class_2338> newPartners) {
        this.partnerPositions.clear();
        this.partnerPositions.addAll(newPartners);
        this.method_5431();
    }

    @Override
    protected void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        class_2499 list = new class_2499();
        for (class_2338 p : this.partnerPositions) {
            class_2487 t = new class_2487();
            t.method_10569("X", p.method_10263());
            t.method_10569("Y", p.method_10264());
            t.method_10569("Z", p.method_10260());
            list.add((Object)t);
        }
        tag.method_10566("Partners", (class_2520)list);
        tag.method_10569("Cooldown", this.cooldown);
    }

    @Override
    protected void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        this.partnerPositions.clear();
        if (tag.method_10573("Partners", 9)) {
            class_2499 list = tag.method_10554("Partners", 10);
            for (class_2520 t : list) {
                class_2487 c = (class_2487)t;
                this.partnerPositions.add(new class_2338(c.method_10550("X"), c.method_10550("Y"), c.method_10550("Z")));
            }
        }
        this.cooldown = tag.method_10550("Cooldown");
    }

    @Override
    @NotNull
    public class_243 electricalChargeOriginOffset() {
        return class_243.field_1353;
    }

    @Override
    @NotNull
    public class_243 electricalChargeEndOffset() {
        return new class_243(0.0, 0.5, 0.0);
    }
}

