/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.blockentity;

import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.projectile.RespawnTotemRingProjectile;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsBlockEntities;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsParticles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1321;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtil;

public class RespawnTotemBlockEntity
extends class_2586
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public final Map<UUID, class_2487> savedEntities = new ConcurrentHashMap<UUID, class_2487>();
    private final List<RespawnData> pending = new ArrayList<RespawnData>();
    private int tickCount = 0;
    private boolean isCapturing = false;
    private int charges = 0;
    private int captureCooldown = 0;

    public RespawnTotemBlockEntity(class_2338 pos, class_2680 state) {
        super(CompanionsBlockEntities.RESPAWN_TOTEM, pos, state);
    }

    public void queueRespawn(class_2487 nbt, int delay) {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 sv = (class_3218)class_19372;
        this.pending.add(new RespawnData(nbt, sv.method_8510() + (long)delay));
        this.method_5431();
    }

    public void setCharges(int charges) {
        this.charges = charges;
        this.sync();
    }

    public int getCharges() {
        return this.charges;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public boolean captureNearby() {
        if (this.field_11863 == null) {
            return false;
        }
        if (this.field_11863.field_9236) {
            return false;
        }
        boolean captureFlag = false;
        for (class_1297 e : this.field_11863.method_18467(class_1321.class, new class_238(this.field_11867).method_1014(5.0))) {
            if (e.method_31481()) continue;
            class_2487 data = new class_2487();
            e.method_5662(data);
            this.savedEntities.put(e.method_5667(), data);
            if (e instanceof CompanionEntity) {
                CompanionEntity c = (CompanionEntity)e;
                c.setRespawnTotem(this.field_11867, this.field_11863.method_27983().method_29177());
            }
            captureFlag = true;
        }
        this.method_5431();
        return captureFlag;
    }

    public int getCaptureCooldown() {
        return this.captureCooldown;
    }

    public void setCaptureCooldown(int captureCooldown) {
        this.captureCooldown = captureCooldown;
    }

    public void setCapturing(boolean capturing) {
        if (capturing && this.getCaptureCooldown() > 0) {
            return;
        }
        this.isCapturing = capturing;
    }

    public boolean isCapturing() {
        return this.isCapturing;
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10569("Charges", this.getCharges());
        class_2499 list = new class_2499();
        this.savedEntities.forEach((uuid, data) -> {
            class_2487 entry = new class_2487();
            entry.method_25927("Uuid", uuid);
            entry.method_10566("Data", (class_2520)data);
            list.add((Object)entry);
        });
        tag.method_10566("RespawnList", (class_2520)list);
        class_2499 list2 = new class_2499();
        for (RespawnData p : this.pending) {
            class_2487 e = new class_2487();
            e.method_10544("When", p.time);
            e.method_10566("Nbt", (class_2520)p.nbt);
            list2.add((Object)e);
        }
        tag.method_10566("RespawnPending", (class_2520)list2);
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        this.savedEntities.clear();
        this.charges = tag.method_10550("Charges");
        class_2499 list = tag.method_10554("RespawnList", 10);
        for (class_2520 t : list) {
            class_2487 entry = (class_2487)t;
            this.savedEntities.put(entry.method_25926("Uuid"), entry.method_10562("Data"));
        }
        this.pending.clear();
        class_2499 list2 = tag.method_10554("RespawnPending", 10);
        for (class_2520 t : list2) {
            class_2487 e = (class_2487)t;
            this.pending.add(new RespawnData(e.method_10562("Nbt"), e.method_10537("When")));
        }
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        class_2487 tag = super.method_16887(provider);
        tag.method_10569("Charges", this.getCharges());
        return tag;
    }

    public void sync() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        class_2622 pkt = class_2622.method_38585((class_2586)this);
        serverLevel.method_14178().field_17254.method_17210(new class_1923(this.field_11867), false).forEach(arg_0 -> RespawnTotemBlockEntity.lambda$sync$1((class_2596)pkt, arg_0));
    }

    public static <X extends class_2586> void tick(class_1937 level, class_2338 pos, class_2680 state, X blockEntity) {
        class_3218 sv;
        if (!(blockEntity instanceof RespawnTotemBlockEntity)) {
            return;
        }
        RespawnTotemBlockEntity t = (RespawnTotemBlockEntity)blockEntity;
        if (level instanceof class_3218) {
            sv = (class_3218)level;
            long now = sv.method_8510();
            Iterator<RespawnData> it = t.pending.iterator();
            while (it.hasNext()) {
                RespawnData p = it.next();
                if (now < p.time) continue;
                class_1297 spawned = class_1299.method_17842((class_2487)p.nbt, (class_1937)sv, e -> {
                    class_2338 sPos = RespawnTotemBlockEntity.findSpawn(sv, pos, 5);
                    double x = sPos != null ? (double)sPos.method_10263() + 0.5 : (double)pos.method_10263() + 0.5;
                    double y = sPos != null ? sPos.method_10264() : pos.method_10264() + 1;
                    double z = sPos != null ? (double)sPos.method_10260() + 0.5 : (double)pos.method_10260() + 0.5;
                    e.method_5814(x, y, z);
                    return e;
                });
                if (spawned != null) {
                    for (int i = 0; i < 20; ++i) {
                        double dx = (sv.field_9229.method_43058() - 0.5) * 2.0;
                        double dy = (sv.field_9229.method_43058() - 0.5) * 2.0;
                        double dz = (sv.field_9229.method_43058() - 0.5) * 2.0;
                        sv.method_14199((class_2394)class_2398.field_11203, spawned.method_23317(), spawned.method_23318() + (double)spawned.method_17682() * 0.5, spawned.method_23321(), 1, dx, dy, dz, 0.1);
                    }
                    t.setCharges(t.getCharges() - 1);
                    if (spawned instanceof CompanionEntity) {
                        CompanionEntity c = (CompanionEntity)spawned;
                        c.setMainAction(0, null);
                    } else if (spawned instanceof class_1321) {
                        class_1321 tamableAnimal = (class_1321)spawned;
                        tamableAnimal.method_24346(true);
                    }
                    sv.method_8649(spawned);
                }
                it.remove();
            }
        }
        if (t.isCapturing()) {
            if (level instanceof class_3218) {
                sv = (class_3218)level;
                for (int i = 0; i < 20; ++i) {
                    double dx = (sv.field_9229.method_43058() - 0.5) * 2.0;
                    double dy = (sv.field_9229.method_43058() - 0.5) * 2.0;
                    double dz = (sv.field_9229.method_43058() - 0.5) * 2.0;
                    sv.method_14199((class_2394)class_2398.field_11203, (double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.5, 1, dx, dy, dz, 0.1);
                }
                RespawnTotemRingProjectile ring = (RespawnTotemRingProjectile)CompanionsEntities.RESPAWN_TOTEM_RING_PROJECTILE.method_5883(level);
                if (ring != null) {
                    ring.method_5814((double)pos.method_10263() + 0.5, t.getRingSpawnY(level, pos) + 0.015, (double)pos.method_10260() + 0.5);
                    level.method_8649((class_1297)ring);
                }
            }
            if (t.captureNearby()) {
                t.setCharges(CompanionsConfig.RESPAWN_TOTEM_CHARGES);
            }
            t.setCapturing(false);
            t.setCaptureCooldown(40);
            t.method_5431();
        }
        if (t.getCaptureCooldown() > 0) {
            t.setCaptureCooldown(t.getCaptureCooldown() - 1);
        }
        if (t.tickCount % 10 == 0 && t.getCharges() > 0) {
            double dx = (new Random().nextDouble() - 0.5) * 0.5;
            double dy = (new Random().nextDouble() - 0.5) * 0.5;
            double dz = (new Random().nextDouble() - 0.5) * 0.5;
            if (level instanceof class_3218) {
                class_3218 sv2 = (class_3218)level;
                sv2.method_14199((class_2394)CompanionsParticles.RESPAWN_TOTEM.get(), (double)t.method_11016().method_10263() + 0.5, (double)t.method_11016().method_10264() + 1.5 * Math.random(), (double)t.method_11016().method_10260() + 0.5, 1, dx, dy, dz, 0.02);
            }
        }
        ++t.tickCount;
    }

    private static class_2338 findSpawn(class_3218 level, class_2338 center, int radius) {
        for (int i = 0; i < 80; ++i) {
            int z;
            int y;
            int dx = new Random().nextInt(radius * 2 + 1) - radius;
            int dz = new Random().nextInt(radius * 2 + 1) - radius;
            int x = center.method_10263() + dx;
            class_2338 ret = new class_2338(x, y = level.method_8624(class_2902.class_2903.field_13197, x, z = center.method_10260() + dz), z);
            if (!level.method_8320(ret).method_26215() || !level.method_8320(ret.method_10084()).method_26215()) continue;
            return ret;
        }
        return null;
    }

    private double getRingSpawnY(class_1937 level, class_2338 basePos) {
        class_2338 below1 = basePos.method_10074();
        if (!level.method_8320(below1).method_26215()) {
            int airCount;
            class_2338 below2 = below1.method_10074();
            if (!level.method_8320(below2).method_26215()) {
                airCount = 0;
                for (class_2350 dir : class_2350.class_2353.field_11062) {
                    if (!level.method_8320(below2.method_10093(dir)).method_26215()) continue;
                    ++airCount;
                }
                if (airCount >= 3) {
                    return below2.method_10264();
                }
            }
            airCount = 0;
            for (class_2350 dir : class_2350.class_2353.field_11062) {
                if (!level.method_8320(below1.method_10093(dir)).method_26215()) continue;
                ++airCount;
            }
            if (airCount >= 3) {
                return below1.method_10264();
            }
        }
        return basePos.method_10264();
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public double getTick(Object o) {
        return RenderUtil.getCurrentTick();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private static /* synthetic */ void lambda$sync$1(class_2596 pkt, class_3222 p) {
        p.field_13987.method_14364(pkt);
    }

    private static class RespawnData {
        class_2487 nbt;
        long time;

        RespawnData(class_2487 nbt, long time) {
            this.nbt = nbt;
            this.time = time;
        }
    }
}

