/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.blockentity;

import dev.xylonity.companions.common.block.SoulFurnaceBlock;
import dev.xylonity.companions.common.container.SoulFurnaceContainerMenu;
import dev.xylonity.companions.common.recipe.SoulFurnaceRecipe;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsBlockEntities;
import dev.xylonity.companions.registry.CompanionsRecipes;
import dev.xylonity.knightlib.common.blockentity.GreatChaliceBlockEntity;
import java.util.List;
import java.util.Random;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtil;

public class SoulFurnaceBlockEntity
extends class_2586
implements GeoBlockEntity,
ExtendedScreenHandlerFactory<class_2338>,
class_1263 {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private class_2371<class_1799> items = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
    private static final int MAX_CHARGES = 9;
    public int charges = 0;
    private int currentProgress = 0;
    private int processingTime = 0;
    @Nullable
    private SoulFurnaceRecipe currentRecipe = null;
    public boolean isLit = false;

    public SoulFurnaceBlockEntity(class_2338 pos, class_2680 state) {
        super(CompanionsBlockEntities.SOUL_FURNACE, pos, state);
    }

    public boolean method_5437(int pIndex, @NotNull class_1799 pStack) {
        return pIndex == 0;
    }

    public boolean method_49104(@NotNull class_1263 pTarget, int pIndex, @NotNull class_1799 pStack) {
        return pIndex == 1;
    }

    public static <T extends class_2586> void tick(class_1937 level, class_2338 pos, class_2680 state, T be) {
        class_1799 inputStack;
        SoulFurnaceRecipe found;
        SoulFurnaceBlockEntity furnace;
        block8: {
            block7: {
                if (!(be instanceof SoulFurnaceBlockEntity)) break block7;
                furnace = (SoulFurnaceBlockEntity)be;
                if (!level.method_8608()) break block8;
            }
            return;
        }
        furnace.handleGreatChaliceInteraction(level, pos);
        if (furnace.currentRecipe == null && !furnace.method_5438(0).method_7960() && (found = furnace.findRecipe(level, inputStack = furnace.method_5438(0))) != null) {
            inputStack.method_7934(1);
            furnace.currentRecipe = found;
            furnace.processingTime = found.processTime();
            furnace.currentProgress = 0;
            furnace.method_5431();
        }
        if (furnace.currentRecipe != null) {
            furnace.handleCooking(pos, level, state);
        }
        boolean lit = furnace.currentRecipe != null;
        class_2680 currentState = level.method_8320(pos);
        if (currentState.method_28498((class_2769)SoulFurnaceBlock.LIT) && (Boolean)currentState.method_11654((class_2769)SoulFurnaceBlock.LIT) != lit) {
            level.method_8652(pos, (class_2680)currentState.method_11657((class_2769)SoulFurnaceBlock.LIT, (Comparable)Boolean.valueOf(lit)), 3);
        }
        if (CompanionsConfig.SOUL_FURNACE_CONSTANT_MAX_CHARGES) {
            furnace.charges = 9;
        }
    }

    private void handleGreatChaliceInteraction(class_1937 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos.method_10084());
        if (class_25862 instanceof GreatChaliceBlockEntity) {
            GreatChaliceBlockEntity be = (GreatChaliceBlockEntity)class_25862;
            if (this.charges < 9 && be.isFull()) {
                be.setCharges(0);
                level.method_8396(null, pos.method_10084(), class_3417.field_14978, class_3419.field_15245, 1.0f, 1.0f);
                this.charges = Math.min(this.charges + 1, 9);
                this.method_5431();
            }
        }
    }

    private void handleCooking(class_2338 pos, class_1937 level, class_2680 state) {
        SoulFurnaceRecipe next;
        ++this.currentProgress;
        if (this.currentRecipe == null) {
            return;
        }
        if (this.currentProgress < this.processingTime) {
            return;
        }
        SoulFurnaceRecipe recipe = this.currentRecipe;
        level.method_8396(null, pos.method_10084(), class_3417.field_14978, class_3419.field_15245, 1.0f, 1.0f);
        if (recipe.outputsItem()) {
            class_1799 output = new class_1799((class_1935)recipe.resultItem(), Math.max(1, recipe.resultCount()));
            class_1799 current = this.method_5438(1);
            if (current.method_7960()) {
                this.method_5447(1, output);
            } else if (class_1799.method_7984((class_1799)current, (class_1799)output) || current.method_31574(output.method_7909())) {
                current.method_7933(output.method_7947());
            } else {
                class_1264.method_5449((class_1937)level, (double)pos.method_10263(), (double)(pos.method_10264() + 1), (double)pos.method_10260(), (class_1799)output);
            }
        } else if (recipe.outputsEntity()) {
            class_2338 spawnPos = pos.method_10093((class_2350)state.method_11654((class_2769)SoulFurnaceBlock.FACING));
            class_1297 e = recipe.resultEntity().method_5883(level);
            if (e != null) {
                e.method_5808((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5, 0.0f, 0.0f);
                level.method_8649(e);
            }
        } else if (recipe.outputsBlock()) {
            class_2248 target = recipe.resultBlock();
            class_2338 targetPos = pos.method_10093((class_2350)state.method_11654((class_2769)SoulFurnaceBlock.FACING));
            if (level.method_22347(targetPos)) {
                class_2680 recipeState = target.method_9564();
                if (recipeState.method_28498((class_2769)SoulFurnaceBlock.FACING)) {
                    recipeState = (class_2680)recipeState.method_11657((class_2769)SoulFurnaceBlock.FACING, (Comparable)((class_2350)state.method_11654((class_2769)SoulFurnaceBlock.FACING)));
                } else if (recipeState.method_28498((class_2769)class_2741.field_12481)) {
                    recipeState = (class_2680)recipeState.method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)state.method_11654((class_2769)SoulFurnaceBlock.FACING)));
                }
                level.method_8501(targetPos, recipeState);
                this.spawnPoofParticles(targetPos);
            } else if (level.method_8320(targetPos).method_26204() == target) {
                class_2338 stackPos = targetPos;
                while (!level.method_22347(stackPos) && stackPos.method_10264() < level.method_31600()) {
                    stackPos = stackPos.method_10084();
                }
                if (level.method_22347(stackPos)) {
                    level.method_8501(stackPos, target.method_9564());
                } else {
                    class_1264.method_5449((class_1937)level, (double)targetPos.method_10263(), (double)targetPos.method_10264(), (double)targetPos.method_10260(), (class_1799)new class_1799((class_1935)target));
                }
            } else {
                class_1264.method_5449((class_1937)level, (double)targetPos.method_10263(), (double)targetPos.method_10264(), (double)targetPos.method_10260(), (class_1799)new class_1799((class_1935)target));
            }
        }
        this.charges -= recipe.requiredCharges();
        this.currentRecipe = null;
        this.currentProgress = 0;
        this.processingTime = 0;
        this.method_5431();
        class_1799 stack = this.method_5438(0);
        if (!stack.method_7960() && (next = this.findRecipe(level, stack)) != null) {
            stack.method_7934(1);
            this.currentRecipe = next;
            this.processingTime = next.processTime();
            this.currentProgress = 0;
            this.method_5431();
        }
    }

    @Nullable
    private SoulFurnaceRecipe findRecipe(class_1937 level, class_1799 input) {
        if (input.method_7960()) {
            return null;
        }
        List list = level.method_8433().method_30027(CompanionsRecipes.SOUL_FURNACE_TYPE);
        for (class_8786 rec : list) {
            SoulFurnaceRecipe r;
            class_1860 class_18602 = rec.comp_1933();
            if (!(class_18602 instanceof SoulFurnaceRecipe) || !(r = (SoulFurnaceRecipe)class_18602).input().method_8093(input) || this.charges < r.requiredCharges()) continue;
            return r;
        }
        return null;
    }

    private void spawnPoofParticles(class_2338 targetPos) {
        for (int i = 0; i < 25; ++i) {
            double dx = (new Random().nextDouble() - 0.5) * 2.5;
            double dy = (new Random().nextDouble() - 0.5) * 1.5;
            double dz = (new Random().nextDouble() - 0.5) * 2.5;
            class_1937 class_19372 = this.field_11863;
            if (!(class_19372 instanceof class_3218)) continue;
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_14199((class_2394)class_2398.field_11203, (double)targetPos.method_10263(), (double)targetPos.method_10264(), (double)targetPos.method_10260(), 1, dx, dy, dz, 0.04);
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_38244(registries);
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        this.charges = tag.method_10550("Charges");
        this.currentProgress = tag.method_10550("Progress");
        this.processingTime = tag.method_10550("ProcessingTime");
        this.items = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)tag, this.items, (class_7225.class_7874)provider);
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10569("Charges", this.charges);
        tag.method_10569("Progress", this.currentProgress);
        tag.method_10569("ProcessingTime", this.processingTime);
        class_1262.method_5426((class_2487)tag, this.items, (class_7225.class_7874)provider);
    }

    public class_2371<class_1799> getItems() {
        return this.items;
    }

    @NotNull
    public class_2561 method_5476() {
        return class_2561.method_43470((String)"Soul Furnace");
    }

    @Nullable
    public class_1703 createMenu(int id, @NotNull class_1661 inventory, @NotNull class_1657 player) {
        return new SoulFurnaceContainerMenu(id, inventory, this, new class_3913(){

            public int method_17390(int index) {
                if (index == 0) {
                    return SoulFurnaceBlockEntity.this.charges;
                }
                if (index == 1) {
                    return SoulFurnaceBlockEntity.this.currentProgress;
                }
                if (index == 2) {
                    return SoulFurnaceBlockEntity.this.processingTime;
                }
                return 0;
            }

            public void method_17391(int index, int value) {
                if (index == 0) {
                    SoulFurnaceBlockEntity.this.charges = value;
                } else if (index == 1) {
                    SoulFurnaceBlockEntity.this.currentProgress = value;
                } else if (index == 2) {
                    SoulFurnaceBlockEntity.this.processingTime = value;
                }
            }

            public int method_17389() {
                return 3;
            }
        });
    }

    public double getTick(Object o) {
        return RenderUtil.getCurrentTick();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int method_5439() {
        return this.items.size();
    }

    public boolean method_5442() {
        for (class_1799 stack : this.items) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public class_1799 method_5438(int index) {
        return (class_1799)this.items.get(index);
    }

    @NotNull
    public class_1799 method_5434(int index, int count) {
        return class_1262.method_5430(this.items, (int)index, (int)count);
    }

    @NotNull
    public class_1799 method_5441(int index) {
        return class_1262.method_5428(this.items, (int)index);
    }

    public void method_5447(int index, @NotNull class_1799 stack) {
        SoulFurnaceRecipe found;
        if (index == 0 && !stack.method_7960() && this.currentRecipe == null && this.field_11863 != null && !this.field_11863.method_8608() && (found = this.findRecipe(this.field_11863, stack)) != null) {
            stack.method_7934(1);
            this.currentRecipe = found;
            this.processingTime = found.processTime();
            this.currentProgress = 0;
            this.method_5431();
        }
        this.items.set(index, (Object)stack);
        this.method_5431();
    }

    public void method_5431() {
        super.method_5431();
    }

    public boolean method_5443(@NotNull class_1657 player) {
        return true;
    }

    public void method_5448() {
        this.items.clear();
    }

    public static int getMaxCharges() {
        return 9;
    }

    public boolean isLit() {
        return this.isLit;
    }

    public class_2338 getScreenOpeningData(class_3222 serverPlayer) {
        return this.method_11016();
    }
}

