/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.blockentity;

import dev.xylonity.companions.common.blockentity.AbstractTeslaBlockEntity;
import dev.xylonity.companions.common.tesla.TeslaConnectionManager;
import dev.xylonity.companions.common.tesla.behaviour.pillar.PillarPulseBehaviour;
import dev.xylonity.companions.common.util.interfaces.ITeslaNodeBehaviour;
import dev.xylonity.companions.registry.CompanionsBlockEntities;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VoltaicPillarBlockEntity
extends AbstractTeslaBlockEntity {
    private final ITeslaNodeBehaviour pulseBehaviour = new PillarPulseBehaviour();
    private boolean isTop = false;
    private boolean hasBlockOnTop = false;

    public VoltaicPillarBlockEntity(class_2338 pos, class_2680 state) {
        super(CompanionsBlockEntities.VOLTAIC_PILLAR, pos, state);
    }

    public static <T extends class_2586> void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, T t) {
        if (!(t instanceof VoltaicPillarBlockEntity)) {
            return;
        }
        VoltaicPillarBlockEntity pillar = (VoltaicPillarBlockEntity)t;
        pillar.pulseBehaviour.process(pillar, level, blockPos, blockState);
        pillar.defaultAttackBehaviour.process(pillar, level, blockPos, blockState);
        pillar.setIsTop(!(level.method_8321(pillar.method_11016().method_10084()) instanceof VoltaicPillarBlockEntity));
        pillar.setHasBlockOnTop(!level.method_8320(pillar.method_11016().method_10084()).method_26215());
        class_2586 class_25862 = level.method_8321(pillar.method_11016().method_10084());
        if (class_25862 instanceof VoltaicPillarBlockEntity) {
            VoltaicPillarBlockEntity be = (VoltaicPillarBlockEntity)class_25862;
            pillar.setOwnerUUID(be.getOwnerUUID());
        }
        pillar.sync();
    }

    public boolean isTop() {
        return this.isTop;
    }

    public void setIsTop(boolean top) {
        this.isTop = top;
    }

    public void setHasBlockOnTop(boolean hasBlockOnTop) {
        this.hasBlockOnTop = hasBlockOnTop;
    }

    public boolean hasBlockOnTop() {
        return this.hasBlockOnTop;
    }

    @Override
    protected void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        this.setIsTop(tag.method_10577("IsTop"));
        this.setHasBlockOnTop(tag.method_10577("BlockOnTop"));
    }

    @Override
    protected void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10556("IsTop", this.isTop());
        tag.method_10556("BlockOnTop", this.hasBlockOnTop());
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 provider) {
        class_2487 tag = super.method_16887(provider);
        tag.method_10556("IsTop", this.isTop());
        tag.method_10556("BlockOnTop", this.hasBlockOnTop());
        return tag;
    }

    @Override
    @NotNull
    public class_243 electricalChargeOriginOffset() {
        return new class_243(0.0, 0.5, 0.0);
    }

    @Override
    @NotNull
    public class_243 electricalChargeEndOffset() {
        return new class_243(0.0, 0.5, 0.0);
    }

    @Override
    public boolean handleNodeSelection(TeslaConnectionManager.ConnectionNode thisNode, TeslaConnectionManager.ConnectionNode nodeToConnect, @Nullable class_1838 ctx, class_1657 player) {
        if (ctx != null && ctx.method_8045().method_8321(nodeToConnect.blockPos()) instanceof VoltaicPillarBlockEntity) {
            ArrayList<VoltaicPillarBlockEntity> thisList = new ArrayList<VoltaicPillarBlockEntity>();
            ArrayList<VoltaicPillarBlockEntity> otherList = new ArrayList<VoltaicPillarBlockEntity>();
            this.pillarsBelow(thisList, thisNode.blockPos());
            this.pillarsBelow(otherList, nodeToConnect.blockPos());
            if (thisList.size() == otherList.size()) {
                for (int i = 0; i < thisList.size(); ++i) {
                    this.connectionManager.addConnection(((VoltaicPillarBlockEntity)((Object)thisList.get(i))).asConnectionNode(), ((VoltaicPillarBlockEntity)((Object)otherList.get(i))).asConnectionNode());
                }
            } else {
                if (player != null) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"voltaic_pillar.companions.client_message.wrong_amount").method_27692(class_124.field_1061), true);
                }
                return false;
            }
        }
        return super.handleNodeSelection(thisNode, nodeToConnect, ctx, player);
    }

    @Override
    public boolean handleNodeRemoval(TeslaConnectionManager.ConnectionNode thisNode, TeslaConnectionManager.ConnectionNode nodeToConnect, @Nullable class_1838 ctx, class_1657 player) {
        if (ctx != null && ctx.method_8045().method_8321(nodeToConnect.blockPos()) instanceof VoltaicPillarBlockEntity) {
            ArrayList<VoltaicPillarBlockEntity> thisList = new ArrayList<VoltaicPillarBlockEntity>();
            ArrayList<VoltaicPillarBlockEntity> otherList = new ArrayList<VoltaicPillarBlockEntity>();
            this.pillarsBelow(thisList, thisNode.blockPos());
            this.pillarsBelow(otherList, nodeToConnect.blockPos());
            if (thisList.size() == otherList.size()) {
                for (int i = 0; i < thisList.size(); ++i) {
                    this.connectionManager.removeConnection(((VoltaicPillarBlockEntity)((Object)thisList.get(i))).asConnectionNode(), ((VoltaicPillarBlockEntity)((Object)otherList.get(i))).asConnectionNode());
                }
            }
        }
        return super.handleNodeRemoval(thisNode, nodeToConnect, ctx, player);
    }

    private void pillarsBelow(List<VoltaicPillarBlockEntity> pillars, class_2338 pos) {
        this.scanPillars(pillars, pos.method_10263(), pos.method_10264() - 1, -1, pos.method_10260());
    }

    private void scanPillars(List<VoltaicPillarBlockEntity> pillars, int x, int startY, int step, int z) {
        class_2338 currentPos;
        class_2586 entity;
        if (this.field_11863 == null) {
            return;
        }
        int currentY = startY;
        while ((entity = this.field_11863.method_8321(currentPos = new class_2338(x, currentY, z))) instanceof VoltaicPillarBlockEntity) {
            VoltaicPillarBlockEntity pillarEntity = (VoltaicPillarBlockEntity)entity;
            pillars.add(pillarEntity);
            currentY += step;
        }
    }
}

