/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.teddy.goal;

import dev.xylonity.companions.common.entity.companion.TeddyEntity;
import dev.xylonity.companions.config.CompanionsConfig;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1408;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2397;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_6;
import net.minecraft.class_7;

public class MutatedTeddyFollowOwnerGoal
extends class_1352 {
    public static final int TELEPORT_WHEN_DISTANCE_IS = CompanionsConfig.COMPANIONS_FOLLOW_OWNER_TELEPORT_DISTANCE;
    private final double minDistance;
    private final double startDistance;
    private final double maxSpeedModifier;
    private final float lerpFactor;
    private final TeddyEntity teddy;
    private final class_1408 navigation;
    private class_1309 owner;

    public MutatedTeddyFollowOwnerGoal(TeddyEntity teddy, double maxSpeedModifier, double minDistance, double startDistance, float lerpFactor) {
        this.teddy = teddy;
        this.maxSpeedModifier = maxSpeedModifier;
        this.minDistance = minDistance;
        this.startDistance = startDistance;
        this.lerpFactor = lerpFactor;
        this.navigation = teddy.method_5942();
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (this.teddy.getMainAction() != 1) {
            return false;
        }
        if (this.teddy.getPhase() != 2) {
            return false;
        }
        class_1309 poss = this.teddy.method_35057();
        if (poss == null || !poss.method_5805()) {
            return false;
        }
        if (this.teddy.method_5858((class_1297)poss) < this.startDistance * this.startDistance) {
            return false;
        }
        this.owner = poss;
        return true;
    }

    public boolean method_6266() {
        if (this.teddy.getPhase() != 2) {
            return false;
        }
        if (this.owner == null) {
            return false;
        }
        if (!this.owner.method_5805()) {
            return false;
        }
        return this.teddy.method_5858((class_1297)this.owner) > this.minDistance * this.minDistance;
    }

    public void method_6268() {
        if (this.owner == null) {
            return;
        }
        if (this.teddy.method_5858((class_1297)this.owner) >= (double)(TELEPORT_WHEN_DISTANCE_IS * TELEPORT_WHEN_DISTANCE_IS)) {
            this.teleportToOwner();
        }
        this.teddy.method_5951((class_1297)this.owner, 30.0f, 30.0f);
        double dx = this.owner.method_23317() - this.teddy.method_23317();
        double dy = this.owner.method_23318() + 2.0 - this.teddy.method_23318();
        double dz = this.owner.method_23321() - this.teddy.method_23321();
        double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (dist <= this.minDistance) {
            class_243 slowed = this.teddy.method_18798().method_1021(0.9);
            this.teddy.method_18799(slowed);
            if (slowed.method_1027() < 0.01) {
                this.navigation.method_6340();
                this.teddy.method_5962().method_6239(this.teddy.method_23317(), this.teddy.method_23318(), this.teddy.method_23321(), 0.0);
            }
            this.teddy.field_5960 = false;
            return;
        }
        double theta = dist >= this.startDistance ? 1.0 : class_3532.method_15350((double)((dist - this.minDistance) / (this.startDistance - this.minDistance)), (double)0.0, (double)1.0);
        class_243 target = new class_243(this.owner.method_23317() - dx / dist * this.minDistance, this.owner.method_23318() + 2.0 - dy / dist * this.minDistance, this.owner.method_23321() - dz / dist * this.minDistance);
        class_243 vel = target.method_1020(this.teddy.method_19538()).method_1029().method_1021(this.maxSpeedModifier * theta);
        class_243 cVel = this.teddy.method_18798();
        this.teddy.method_18799(new class_243(class_3532.method_16436((double)this.lerpFactor, (double)cVel.field_1352, (double)vel.field_1352), class_3532.method_16436((double)this.lerpFactor, (double)cVel.field_1351, (double)vel.field_1351), class_3532.method_16436((double)this.lerpFactor, (double)cVel.field_1350, (double)vel.field_1350)));
        this.teddy.field_5960 = this.isPathBlocked(this.teddy.method_37908(), this.teddy.method_33571(), target);
    }

    private boolean isPathBlocked(class_1937 level, class_243 from, class_243 to) {
        return level.method_17742(new class_3959(from, to, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.teddy)).method_17783() != class_239.class_240.field_1333;
    }

    protected void teleportToOwner() {
        class_2338 pos = this.owner.method_24515();
        for (int i = 0; i < 10; ++i) {
            int x = this.randomIntInclusive(-3, 3);
            int y = this.randomIntInclusive(-1, 1);
            int z = this.randomIntInclusive(-3, 3);
            if (!this.maybeTeleportTo(pos.method_10263() + x, pos.method_10264() + y, pos.method_10260() + z)) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int pX, int pY, int pZ) {
        if (Math.abs((double)pX - this.owner.method_23317()) < 2.0 && Math.abs((double)pZ - this.owner.method_23321()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new class_2338(pX, pY, pZ))) {
            return false;
        }
        this.teddy.method_5808((float)pX + 0.5f, pY, (float)pZ + 0.5f, this.teddy.method_36454(), this.teddy.method_36455());
        this.navigation.method_6340();
        return true;
    }

    private boolean canTeleportTo(class_2338 pPos) {
        if (class_6.method_57625((class_1308)this.teddy, (class_2338)pPos.method_25503()) != class_7.field_12) {
            return false;
        }
        if (this.teddy.method_37908().method_8320(pPos.method_10074()).method_26204() instanceof class_2397) {
            return false;
        }
        return this.teddy.method_37908().method_8587((class_1297)this.teddy, this.teddy.method_5829().method_996(pPos.method_10059((class_2382)this.teddy.method_24515())));
    }

    private int randomIntInclusive(int pMin, int pMax) {
        return this.teddy.method_59922().method_43048(pMax - pMin + 1) + pMin;
    }
}

