/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.teddy.goal;

import dev.xylonity.companions.common.entity.companion.TeddyEntity;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_243;

public class MutatedTeddyFollowTargetGoal
extends class_1352 {
    private static final double RADIUS_VARIATION = 2.5;
    private static final double Y_AMPL = 0.8;
    private static final double Y_OSCILATION = 0.25;
    private static final int MIN_DIR_TIME = 40;
    private static final int MAX_DIR_TIME = 160;
    private static final int MIN_IDLE_TIME = 5;
    private static final int MAX_IDLE_TIME = 10;
    private static final int CHARGE_COOLDOWN = 80;
    private final TeddyEntity teddy;
    private class_1309 target;
    private double angle;
    private double time;
    private int dir;
    private State state;
    private int ticksInState;
    private int untilNextDirChange;
    private int untilNextCharge;
    private class_243 chargeDir = class_243.field_1353;

    public MutatedTeddyFollowTargetGoal(TeddyEntity teddy) {
        this.teddy = teddy;
        this.dir = teddy.method_59922().method_43056() ? 1 : -1;
        this.untilNextDirChange = teddy.method_59922().method_43048(120) + 40;
        this.untilNextCharge = 80;
        this.state = State.ORBIT;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_38846() {
        return true;
    }

    public boolean method_6264() {
        if (this.teddy.getPhase() == 1) {
            return false;
        }
        if (this.teddy.method_5968() == null) {
            return false;
        }
        this.target = this.teddy.method_5968();
        return this.target.method_5805();
    }

    public boolean method_6266() {
        return this.method_6264();
    }

    public void method_6268() {
        this.teddy.method_5951((class_1297)this.target, 30.0f, 30.0f);
        ++this.ticksInState;
        this.time += 0.04;
        switch (this.state.ordinal()) {
            case 0: {
                this.orbitTick();
                break;
            }
            case 1: {
                this.idleTick();
                break;
            }
            case 2: {
                this.chargeTick();
            }
        }
    }

    private void orbitTick() {
        class_243 center = new class_243(this.target.method_23317(), this.target.method_23318() + (double)this.target.method_17682() * 0.5, this.target.method_23321());
        class_243 relativePos = this.teddy.method_19538().method_1020(center);
        double currAngle = Math.atan2(relativePos.field_1350, relativePos.field_1352);
        if (currAngle < 0.0) {
            currAngle += Math.PI * 2;
        }
        if (this.teddy.getTeleported()) {
            this.angle = currAngle;
            this.teddy.setTeleported(false);
        } else if (Math.abs(currAngle - this.angle) > Math.PI) {
            this.angle = currAngle;
        }
        this.angle = (this.angle + 0.03225 * (double)this.dir) % (Math.PI * 2);
        double r = 4.0 + 1.25 * (1.0 + Math.sin(this.time * 0.35 * Math.PI * 2.0));
        double y = 0.8 * Math.sin(this.time * 0.25 * Math.PI * 2.0);
        class_243 nextPos = this.teddy.method_19538().method_35590(center.method_1031(r * Math.cos(this.angle), y + 0.7, r * Math.sin(this.angle)), 0.12);
        this.teddy.method_5814(nextPos.field_1352, nextPos.field_1351, nextPos.field_1350);
        this.teddy.method_18799(class_243.field_1353);
        if (this.ticksInState >= this.untilNextDirChange) {
            if (this.untilNextCharge <= 0) {
                this.state = State.CHARGE;
                this.chargeDir = center.method_1020(this.teddy.method_19538()).method_1029();
                this.ticksInState = 0;
            } else {
                if (this.teddy.method_59922().method_43056()) {
                    this.dir *= -1;
                } else {
                    this.state = State.IDLE;
                }
                this.ticksInState = 0;
                this.untilNextDirChange = this.teddy.method_59922().method_43048(120) + 40;
            }
        }
        --this.untilNextCharge;
    }

    private void idleTick() {
        double y = 0.4 * Math.sin(this.time * 0.25 * Math.PI * 2.0);
        this.teddy.method_5814(this.teddy.method_23317(), this.teddy.method_23318() + y * 0.1, this.teddy.method_23321());
        this.teddy.method_18799(class_243.field_1353);
        if (this.ticksInState >= this.teddy.method_59922().method_43048(5) + 5) {
            this.state = State.ORBIT;
            this.ticksInState = 0;
        }
    }

    private void chargeTick() {
        class_243 v = this.chargeDir.method_1021(0.2875);
        this.teddy.method_18799(v);
        this.teddy.method_29495(this.target.method_19538().method_1019(v));
        this.teddy.setTeleported(true);
        if (this.ticksInState > 12 || this.teddy.method_5858((class_1297)this.target) < 4.0) {
            this.teddy.method_18799(class_243.field_1353);
            this.state = State.ORBIT;
            this.ticksInState = 0;
            this.teddy.setTeleported(false);
            this.untilNextCharge = 80;
        }
    }

    public void method_6270() {
        this.teddy.method_18799(class_243.field_1353);
        super.method_6270();
    }

    private static enum State {
        ORBIT,
        IDLE,
        CHARGE;

    }
}

