/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ai.generic.CompanionFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionRandomStrollGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsHurtTargetGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsLookAtPlayerGoal;
import dev.xylonity.companions.common.entity.ai.minion.tamable.gargoyle.GargoyleHealAttackGoal;
import dev.xylonity.companions.common.entity.ai.minion.tamable.gargoyle.GargoyleSpellAttackGoal;
import dev.xylonity.companions.common.entity.ai.minion.tamable.imp.ImpBraceAttackGoal;
import dev.xylonity.companions.common.entity.ai.minion.tamable.imp.ImpFireMarkAttackGoal;
import dev.xylonity.companions.common.entity.ai.minion.tamable.minion.MinionTornadoAttackGoal;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsBlocks;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1321;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1403;
import net.minecraft.class_1408;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class MinionEntity
extends CompanionEntity {
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation SIT = RawAnimation.begin().thenPlay("sit");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation FLY = RawAnimation.begin().thenPlay("fly");
    private final RawAnimation SPELL = RawAnimation.begin().thenPlay("spell");
    private final RawAnimation ATTACK = RawAnimation.begin().thenPlay("attack");
    private final RawAnimation THROW = RawAnimation.begin().thenPlay("throw");
    private final RawAnimation RING = RawAnimation.begin().thenPlay("ring");
    private final RawAnimation HEAL = RawAnimation.begin().thenPlay("idle2");
    private static final class_2940<String> VARIANT = class_2945.method_12791(MinionEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Boolean> IS_LOCKED = class_2945.method_12791(MinionEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_FLYING = class_2945.method_12791(MinionEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> ATTACK_TYPE = class_2945.method_12791(MinionEntity.class, (class_2941)class_2943.field_13327);
    private class_5321<class_1937> lastDimension = null;

    public MinionEntity(class_1299<? extends CompanionEntity> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel);
    }

    @NotNull
    protected class_1408 method_5965(@NotNull class_1937 pLevel) {
        return new GroundNavigator((class_1308)this, pLevel);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23716, CompanionsConfig.MINION_MAX_LIFE).method_26868(class_5134.field_23721, 5.0).method_26868(class_5134.field_23723, 1.0).method_26868(class_5134.field_23719, (double)0.55f).method_26868(class_5134.field_23717, 35.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new MinionTornadoAttackGoal(this, 20, 80));
        this.field_6201.method_6277(1, (class_1352)new ImpBraceAttackGoal(this, 20, 80));
        this.field_6201.method_6277(1, (class_1352)new ImpFireMarkAttackGoal(this, 20, 80));
        this.field_6201.method_6277(1, (class_1352)new GargoyleSpellAttackGoal(this, 20, 80));
        this.field_6201.method_6277(1, (class_1352)new GargoyleHealAttackGoal(this, 20, 80));
        this.field_6201.method_6277(3, (class_1352)new CompanionFollowOwnerGoal(this, 0.6, 6.0f, 2.0f, false));
        this.field_6201.method_6277(3, (class_1352)new CompanionRandomStrollGoal(this, 0.43));
        this.field_6201.method_6277(6, (class_1352)new CompanionsLookAtPlayerGoal((class_1308)this, class_1657.class, 6.0f));
        this.field_6185.method_6277(1, (class_1352)new class_1403((class_1321)this));
        this.field_6185.method_6277(2, (class_1352)new CompanionsHurtTargetGoal(this));
    }

    private void updateVariantByDimension() {
        if (this.isPhaseLocked()) {
            return;
        }
        class_5321 currentDim = this.method_37908().method_27983();
        if (currentDim.equals(this.lastDimension)) {
            return;
        }
        this.lastDimension = currentDim;
        Variant newVariant = currentDim.equals(class_1937.field_25180) ? Variant.NETHER : (currentDim.equals(class_1937.field_25181) ? Variant.END : Variant.OVERWORLD);
        this.setVariant(newVariant.getName());
    }

    @NotNull
    public class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 hand) {
        if (this.method_37908().field_9236) {
            return class_1269.field_5812;
        }
        if (this.method_6181() && player == this.method_35057() && player.method_5998(hand).method_7909() == CompanionsItems.NETHERITE_CHAINS.get() && !this.isPhaseLocked()) {
            if (!player.method_31549().field_7477) {
                player.method_5998(hand).method_7934(1);
            }
            this.tameParticles();
            this.method_43077(CompanionsSounds.SPELL_RELEASE_MARK.get());
            this.setIsPhaseLocked(true);
            return class_1269.field_5812;
        }
        if (this.method_6181() && player == this.method_35057()) {
            if (Variant.NETHER.getName().equals(this.getVariant()) && player.method_5998(hand).method_7909() == CompanionsBlocks.NETHER_COIN.get().method_8389()) {
                if (!player.method_31549().field_7477) {
                    player.method_5998(hand).method_7934(1);
                }
                if (this.method_59922().method_43057() < 0.45f) {
                    MinionEntity.popResource(this.method_37908(), new class_2338(this.method_24515().method_10263(), this.method_24515().method_10264() + 1, this.method_24515().method_10260()), new class_1799(this.method_59922().method_43056() ? (class_1935)CompanionsItems.BOOK_FIRE_MARK.get() : (class_1935)CompanionsItems.BOOK_BRACE.get()));
                    this.rewardParticles();
                } else {
                    this.failureParticles();
                }
                return class_1269.field_5812;
            }
            if (Variant.END.getName().equals(this.getVariant()) && player.method_5998(hand).method_7909() == CompanionsBlocks.END_COIN.get().method_8389()) {
                if (!player.method_31549().field_7477) {
                    player.method_5998(hand).method_7934(1);
                }
                if (this.method_59922().method_43057() < 0.55f) {
                    MinionEntity.popResource(this.method_37908(), new class_2338(this.method_24515().method_10263(), this.method_24515().method_10264() + 1, this.method_24515().method_10260()), new class_1799(this.method_59922().method_43056() ? (class_1935)CompanionsItems.BOOK_HEAL_RING.get() : (class_1935)CompanionsItems.BOOK_STONE_SPIKES.get()));
                    this.rewardParticles();
                } else {
                    this.failureParticles();
                }
                return class_1269.field_5812;
            }
            if (Variant.OVERWORLD.getName().equals(this.getVariant()) && player.method_5998(hand).method_7909() == CompanionsBlocks.COPPER_COIN.get().method_8389()) {
                if (!player.method_31549().field_7477) {
                    player.method_5998(hand).method_7934(1);
                }
                if (this.method_59922().method_43057() < 0.25f) {
                    MinionEntity.popResource(this.method_37908(), new class_2338(this.method_24515().method_10263(), this.method_24515().method_10264() + 1, this.method_24515().method_10260()), new class_1799(this.method_59922().method_43056() ? (class_1935)CompanionsItems.BOOK_ICE_SHARD.get() : (class_1935)CompanionsItems.BOOK_ICE_TORNADO.get()));
                    this.rewardParticles();
                } else {
                    this.failureParticles();
                }
                return class_1269.field_5812;
            }
        }
        if (this.handleDefaultMainActionAndHeal(player, hand)) {
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    private static void popResource(class_1937 pLevel, class_2338 pPos, class_1799 pStack) {
        double d0 = class_1299.field_6052.method_17686() / 2.0f;
        double d1 = (double)pPos.method_10263() + 0.5;
        double d2 = (double)pPos.method_10264() + 1.5 + class_3532.method_15366((class_5819)pLevel.field_9229, (double)-0.25, (double)0.25) - d0;
        double d3 = (double)pPos.method_10260() + 0.5;
        MinionEntity.popResource(pLevel, () -> new class_1542(pLevel, d1, d2, d3, pStack, -0.25 + Math.random() * 0.25, -0.35 + Math.random() * (double)0.35f, -0.25 + Math.random() * 0.25), pStack);
    }

    private static void popResource(class_1937 pLevel, Supplier<class_1542> pItemEntitySupplier, class_1799 pStack) {
        if (!pLevel.field_9236 && !pStack.method_7960()) {
            class_1542 itementity = pItemEntitySupplier.get();
            itementity.method_6988();
            pLevel.method_8649((class_1297)itementity);
        }
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            this.updateVariantByDimension();
        }
    }

    public boolean method_5753() {
        return this.getVariant().equals(Variant.NETHER.getName());
    }

    private void rewardParticles() {
        for (int i = 0; i < 20; ++i) {
            double dx = (this.field_5974.method_43058() - 0.5) * 2.0;
            double dy = (this.field_5974.method_43058() - 0.5) * 2.0;
            double dz = (this.field_5974.method_43058() - 0.5) * 2.0;
            class_1937 class_19372 = this.method_37908();
            if (!(class_19372 instanceof class_3218)) continue;
            class_3218 level = (class_3218)class_19372;
            if (!(level.field_9229.method_43057() < 0.65f)) continue;
            level.method_14199((class_2394)class_2398.field_11203, this.method_23317(), this.method_23318() + (double)this.method_17682() * Math.random(), this.method_23321(), 1, dx, dy, dz, 0.1);
        }
    }

    private void failureParticles() {
        for (int i = 0; i < 20; ++i) {
            double dx = (this.field_5974.method_43058() - 0.5) * 2.0;
            double dy = (this.field_5974.method_43058() - 0.5) * 2.0;
            double dz = (this.field_5974.method_43058() - 0.5) * 2.0;
            class_1937 class_19372 = this.method_37908();
            if (!(class_19372 instanceof class_3218)) continue;
            class_3218 level = (class_3218)class_19372;
            if (!(level.field_9229.method_43057() < 0.65f)) continue;
            level.method_14199((class_2394)class_2398.field_11251, this.method_23317(), this.method_23318() + (double)this.method_17682() * Math.random(), this.method_23321(), 1, dx, dy, dz, 0.025);
        }
    }

    @Nullable
    protected class_3414 method_6002() {
        if (this.getVariant().equals(Variant.END.getName())) {
            return CompanionsSounds.END_MINION_DEATH.get();
        }
        if (this.getVariant().equals(Variant.NETHER.getName())) {
            return CompanionsSounds.NETHER_MINION_DEATH.get();
        }
        return CompanionsSounds.OVERWORLD_MINION_DEATH.get();
    }

    @Nullable
    protected class_3414 method_6011(@NotNull class_1282 pDamageSource) {
        if (this.getVariant().equals(Variant.END.getName())) {
            return CompanionsSounds.END_MINION_HURT.get();
        }
        if (this.getVariant().equals(Variant.NETHER.getName())) {
            return CompanionsSounds.NETHER_MINION_HURT.get();
        }
        return CompanionsSounds.OVERWORLD_MINION_HURT.get();
    }

    @Nullable
    protected class_3414 method_5994() {
        if (this.getVariant().equals(Variant.END.getName())) {
            return super.method_5994();
        }
        if (this.getVariant().equals(Variant.NETHER.getName())) {
            return CompanionsSounds.NETHER_MINION_IDLE.get();
        }
        return CompanionsSounds.OVERWORLD_MINION_IDLE.get();
    }

    protected void method_5712(class_2338 pPos, class_2680 pState) {
        if (this.getVariant().equals(Variant.END.getName())) {
            this.method_5783(CompanionsSounds.END_MINION_STEP.get(), 0.5f, 1.0f);
        } else {
            super.method_5712(pPos, pState);
        }
    }

    @Override
    public void method_5749(@NotNull class_2487 pCompound) {
        super.method_5749(pCompound);
        this.setIsPhaseLocked(pCompound.method_10577("IsVariantLocked"));
        if (pCompound.method_10573("Variant", 8)) {
            this.setVariant(pCompound.method_10558("Variant"));
        } else {
            class_5321 dim = this.method_37908().method_27983();
            if (dim.equals(class_1937.field_25180)) {
                this.setVariant(Variant.NETHER.getName());
            } else if (dim.equals(class_1937.field_25181)) {
                this.setVariant(Variant.END.getName());
            } else {
                this.setVariant(Variant.OVERWORLD.getName());
            }
        }
    }

    @Override
    public void method_5652(@NotNull class_2487 pCompound) {
        super.method_5652(pCompound);
        pCompound.method_10556("IsVariantLocked", this.isPhaseLocked());
        pCompound.method_10582("Variant", this.getVariant());
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)Variant.OVERWORLD.getName());
        builder.method_56912(IS_LOCKED, (Object)false);
        builder.method_56912(IS_FLYING, (Object)false);
        builder.method_56912(ATTACK_TYPE, (Object)0);
    }

    @Override
    protected boolean canThisCompanionWork() {
        return false;
    }

    @Override
    protected int sitAnimationsAmount() {
        return 1;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return CompanionsConfig.MINION_KEEP_CHUNK_LOADED;
    }

    public boolean isPhaseLocked() {
        return (Boolean)this.field_6011.method_12789(IS_LOCKED);
    }

    public void setIsPhaseLocked(boolean phase) {
        this.field_6011.method_12778(IS_LOCKED, (Object)phase);
    }

    public boolean isFlying() {
        return (Boolean)this.field_6011.method_12789(IS_FLYING);
    }

    public void setFlying(boolean flying) {
        this.field_6011.method_12778(IS_FLYING, (Object)flying);
    }

    public String getVariant() {
        return (String)this.field_6011.method_12789(VARIANT);
    }

    public void setVariant(String variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant);
    }

    public int getAttackType() {
        return (Integer)this.field_6011.method_12789(ATTACK_TYPE);
    }

    public void setAttackType(int attacking) {
        this.field_6011.method_12778(ATTACK_TYPE, (Object)attacking);
    }

    @NotNull
    public class_2561 method_5477() {
        if (this.method_16914()) {
            return super.method_5477();
        }
        if (Variant.NETHER.getName().equals(this.getVariant())) {
            return class_2561.method_43471((String)"entity.companions.imp");
        }
        if (Variant.END.getName().equals(this.getVariant())) {
            return class_2561.method_43471((String)"entity.companions.gargoyle");
        }
        return class_2561.method_43471((String)"entity.companions.minion");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getVariant().equals(Variant.OVERWORLD.getName())) {
            if (this.getMainAction() == 0) {
                event.getController().setAnimation(this.SIT);
            } else if (this.getAttackType() == 1) {
                event.getController().setAnimation(this.ATTACK);
            } else {
                event.getController().setAnimation(this.FLY);
            }
        } else if (this.getVariant().equals(Variant.END.getName())) {
            if (this.getMainAction() == 0) {
                event.getController().setAnimation(this.SIT);
            } else if (this.getAttackType() == 1) {
                event.getController().setAnimation(this.SPELL);
            } else if (this.getAttackType() == 2) {
                event.getController().setAnimation(this.HEAL);
            } else if (event.isMoving()) {
                event.getController().setAnimation(this.WALK);
            } else {
                event.getController().setAnimation(this.IDLE);
            }
        } else if (this.getMainAction() == 0) {
            event.getController().setAnimation(this.SIT);
        } else if (this.getAttackType() == 1) {
            event.getController().setAnimation(this.THROW);
        } else if (this.getAttackType() == 2) {
            event.getController().setAnimation(this.RING);
        } else if (event.isMoving()) {
            event.getController().setAnimation(this.WALK);
        } else {
            event.getController().setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }

    private void tameParticles() {
        for (int i = 0; i < 20; ++i) {
            double dx = (this.field_5974.method_43058() - 0.5) * 2.0;
            double dy = (this.field_5974.method_43058() - 0.5) * 2.0;
            double dz = (this.field_5974.method_43058() - 0.5) * 2.0;
            class_1937 class_19372 = this.method_37908();
            if (!(class_19372 instanceof class_3218)) continue;
            class_3218 level = (class_3218)class_19372;
            if (level.field_9229.method_43057() < 0.65f) {
                level.method_14199((class_2394)class_2398.field_11203, this.method_23317(), this.method_23318() + (double)this.method_17682() * Math.random(), this.method_23321(), 1, dx, dy, dz, 0.1);
            }
            if (!(level.field_9229.method_43057() < 0.25f)) continue;
            level.method_14199((class_2394)CompanionsParticles.SHADE_SUMMON.get(), this.method_23317(), this.method_23318() + (double)this.method_17682() * Math.random(), this.method_23321(), 1, dx, dy, dz, 0.2);
        }
    }

    public static enum Variant {
        OVERWORLD("minion"),
        NETHER("imp"),
        END("gargoyle");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

