/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.container.PuppetContainerMenu;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsHurtTargetGoal;
import dev.xylonity.companions.common.entity.ai.puppet.goal.PuppetApproachTargetGoal;
import dev.xylonity.companions.common.entity.ai.puppet.goal.PuppetLeftBladeAttackGoal;
import dev.xylonity.companions.common.entity.ai.puppet.goal.PuppetLeftCannonAttackGoal;
import dev.xylonity.companions.common.entity.ai.puppet.goal.PuppetLeftMutantAttackGoal;
import dev.xylonity.companions.common.entity.ai.puppet.goal.PuppetLeftWhipAttackGoal;
import dev.xylonity.companions.common.entity.ai.puppet.goal.PuppetRightBladeAttackGoal;
import dev.xylonity.companions.common.entity.ai.puppet.goal.PuppetRightCannonAttackGoal;
import dev.xylonity.companions.common.entity.ai.puppet.goal.PuppetRightMutantAttackGoal;
import dev.xylonity.companions.common.entity.ai.puppet.goal.PuppetRightWhipAttackGoal;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1386;
import net.minecraft.class_1403;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3908;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class PuppetEntity
extends CompanionEntity
implements class_1603,
class_1265 {
    public class_1277 inventory;
    private final RawAnimation SIT = RawAnimation.begin().thenPlay("sit");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation ATTACK_L = RawAnimation.begin().thenPlay("attack_l");
    private final RawAnimation ATTACK_R = RawAnimation.begin().thenPlay("attack_r");
    private static final class_2940<Byte> DATA_ID_FLAGS = class_2945.method_12791(PuppetEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<String> ATTACK_ANIMATION_NAME = class_2945.method_12791(PuppetEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Boolean> IS_ATTACKING_RIGHT = class_2945.method_12791(PuppetEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_ATTACKING_LEFT = class_2945.method_12791(PuppetEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> ACTIVE_ARMS = class_2945.method_12791(PuppetEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<String> ARM_NAMES = class_2945.method_12791(PuppetEntity.class, (class_2941)class_2943.field_13326);
    private final class_1799[] lastStacks = new class_1799[]{class_1799.field_8037.method_7972(), class_1799.field_8037.method_7972()};
    private static final class_2940<String> CURRENT_ATTACK_TYPE = class_2945.method_12791(PuppetEntity.class, (class_2941)class_2943.field_13326);

    public PuppetEntity(class_1299<? extends class_1321> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel);
        this.createInventory();
    }

    @NotNull
    protected class_1408 method_5965(@NotNull class_1937 pLevel) {
        return new GroundNavigator((class_1308)this, pLevel);
    }

    protected void createInventory() {
        class_1277 oldInv = this.inventory;
        this.inventory = new class_1277(this.getInventorySize());
        if (oldInv != null) {
            int min = Math.min(oldInv.method_5439(), this.inventory.method_5439());
            for (int i = 0; i < min; ++i) {
                class_1799 stack = oldInv.method_5438(i);
                this.inventory.method_5447(i, stack.method_7972());
            }
        }
        this.inventory.method_5489((class_1265)this);
        this.updateContainerEquipment();
    }

    protected int getInventorySize() {
        return 2;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(2, (class_1352)new PuppetRightCannonAttackGoal(this, 10, 50));
        this.field_6201.method_6277(2, (class_1352)new PuppetRightBladeAttackGoal(this, 10, 50));
        this.field_6201.method_6277(2, (class_1352)new PuppetRightMutantAttackGoal(this, 10, 50));
        this.field_6201.method_6277(2, (class_1352)new PuppetRightWhipAttackGoal(this, 10, 50));
        this.field_6201.method_6277(2, (class_1352)new PuppetLeftCannonAttackGoal(this, 10, 50));
        this.field_6201.method_6277(2, (class_1352)new PuppetLeftBladeAttackGoal(this, 10, 50));
        this.field_6201.method_6277(2, (class_1352)new PuppetLeftMutantAttackGoal(this, 10, 50));
        this.field_6201.method_6277(2, (class_1352)new PuppetLeftWhipAttackGoal(this, 10, 50));
        this.field_6201.method_6277(3, (class_1352)new PuppetApproachTargetGoal(this, 0.5, 0.4f, 1.25f));
        this.field_6201.method_6277(4, (class_1352)new class_1350((class_1321)this, 0.6, 6.0f, 2.0f));
        this.field_6185.method_6277(1, (class_1352)new class_1403((class_1321)this));
        this.field_6185.method_6277(2, (class_1352)new CompanionsHurtTargetGoal(this));
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            Optional h = this.method_5829().method_992(player.method_33571(), player.method_5836(1.0f).method_1019(player.method_5720().method_1021(5.0)));
            if (h.isPresent() && ((class_243)h.get()).field_1351 - this.method_5829().field_1322 < 2.0) {
                return false;
            }
        }
        boolean ret = super.method_5643(source, amount);
        if (!this.method_37908().field_9236 && amount > 4.0f && this.hasArm(CompanionsItems.MUTANT_ARM.get()) && this.method_5968() != null) {
            this.spawnMutantParticles(15);
            this.tpOppositeSide();
            this.spawnMutantParticles(15);
        }
        return ret;
    }

    private void spawnMutantParticles(int amount) {
        for (int i = 0; i < amount; ++i) {
            double dx = (this.field_5974.method_43058() - 0.5) * 2.0;
            double dy = (this.field_5974.method_43058() - 0.5) * 2.0;
            double dz = (this.field_5974.method_43058() - 0.5) * 2.0;
            class_1937 class_19372 = this.method_37908();
            if (!(class_19372 instanceof class_3218)) continue;
            class_3218 level = (class_3218)class_19372;
            level.method_14199((class_2394)class_2398.field_11203, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), 1, dx, dy, dz, 0.1);
            if (i % 5 != 0) continue;
            level.method_14199((class_2394)CompanionsParticles.TEDDY_TRANSFORMATION.get(), this.method_23317(), this.method_23318() + 1.0, this.method_23321(), 1, dx, dy, dz, 0.2);
        }
    }

    private void tpOppositeSide() {
        class_1309 target = this.method_5968();
        if (target == null) {
            return;
        }
        class_243 pos = target.method_19538();
        class_243 newPos = pos.method_1023(this.method_19538().field_1352 - pos.field_1352, 0.0, this.method_19538().field_1350 - pos.field_1350);
        if (this.isValidTeleportPos(newPos)) {
            this.method_5814(newPos.field_1352, this.method_19538().field_1351, newPos.field_1350);
        }
    }

    private boolean isValidTeleportPos(class_243 newPos) {
        class_2338 feet = new class_2338((int)newPos.field_1352, (int)newPos.field_1351, (int)newPos.field_1350);
        class_2338 head = new class_2338((int)newPos.field_1352, (int)newPos.field_1351 + 1, (int)newPos.field_1350);
        class_2338 floor = new class_2338((int)newPos.field_1352, (int)newPos.field_1351 - 1, (int)newPos.field_1350);
        boolean f1 = this.method_37908().method_8320(feet).method_26215() && this.method_37908().method_8320(head).method_26215();
        boolean f2 = this.method_37908().method_8320(floor).method_26216((class_1922)this.method_37908(), floor);
        return f1 && f2;
    }

    public boolean hasArm(class_1792 armItem) {
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            class_1799 stack = this.inventory.method_5438(i);
            if (stack.method_7960() || stack.method_7909() != armItem) continue;
            return true;
        }
        return false;
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_23716, CompanionsConfig.PUPPET_MAX_LIFE).method_26868(class_5134.field_23721, CompanionsConfig.PUPPET_DAMAGE).method_26868(class_5134.field_23723, 1.0).method_26868(class_5134.field_23719, (double)0.55f).method_26868(class_5134.field_23717, 35.0);
    }

    public void setActiveArms(int candleCount) {
        this.field_6011.method_12778(ACTIVE_ARMS, (Object)candleCount);
    }

    public int getActiveArms() {
        return (Integer)this.field_6011.method_12789(ACTIVE_ARMS);
    }

    public boolean isAttackingRight() {
        return (Boolean)this.field_6011.method_12789(IS_ATTACKING_RIGHT);
    }

    public void setAttackingRight(boolean attacking) {
        this.field_6011.method_12778(IS_ATTACKING_RIGHT, (Object)attacking);
    }

    public boolean isAttackingLeft() {
        return (Boolean)this.field_6011.method_12789(IS_ATTACKING_LEFT);
    }

    public void setAttackingLeft(boolean attacking) {
        this.field_6011.method_12778(IS_ATTACKING_LEFT, (Object)attacking);
    }

    public void setArmNames(String armNames) {
        this.field_6011.method_12778(ARM_NAMES, (Object)armNames);
    }

    public String getArmNames() {
        return (String)this.field_6011.method_12789(ARM_NAMES);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(IS_ATTACKING_RIGHT, (Object)false);
        builder.method_56912(IS_ATTACKING_LEFT, (Object)false);
        builder.method_56912(DATA_ID_FLAGS, (Object)0);
        builder.method_56912(ATTACK_ANIMATION_NAME, (Object)"");
        builder.method_56912(ACTIVE_ARMS, (Object)0);
        builder.method_56912(CURRENT_ATTACK_TYPE, (Object)"NONE");
        builder.method_56912(ARM_NAMES, (Object)"none,none");
    }

    @Nullable
    public class_1309 method_35057() {
        return super.method_35057();
    }

    @NotNull
    public class_1269 method_5992(class_1657 player, @NotNull class_1268 hand) {
        if (this.method_6181() && this.method_35057() == player && player.method_5715() && hand == class_1268.field_5808) {
            if (!this.method_37908().field_9236) {
                player.method_17355((class_3908)new ExtendedScreenHandlerFactory<Object>(){

                    public Object getScreenOpeningData(class_3222 serverPlayer) {
                        return PuppetEntity.this.method_5628();
                    }

                    public class_2561 method_5476() {
                        return PuppetEntity.this.method_5477();
                    }

                    @Nullable
                    public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
                        return new PuppetContainerMenu(i, inventory, PuppetEntity.this);
                    }
                });
                this.method_5783((class_3414)class_3417.field_14581.comp_349(), 0.5f, 1.0f);
            }
            return class_1269.field_5812;
        }
        if (this.handleDefaultMainActionAndHeal(player, hand)) {
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    @Override
    public void method_5749(@NotNull class_2487 pCompound) {
        super.method_5749(pCompound);
        this.inventory.method_7659(pCompound.method_10554("Inventory", 10), (class_7225.class_7874)this.method_37908().method_30349());
        this.updateContainerEquipment();
    }

    @Override
    public void method_5652(@NotNull class_2487 pCompound) {
        super.method_5652(pCompound);
        pCompound.method_10566("Inventory", (class_2520)this.inventory.method_7660((class_7225.class_7874)this.method_37908().method_30349()));
    }

    @Override
    protected boolean canThisCompanionWork() {
        return true;
    }

    @Override
    protected int sitAnimationsAmount() {
        return 1;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return CompanionsConfig.PUPPET_KEEP_CHUNK_LOADED;
    }

    public void method_7105(@NotNull class_1309 target, float v) {
    }

    @Nullable
    protected class_3414 method_6011(@NotNull class_1282 pDamageSource) {
        return CompanionsSounds.PUPPET_HURT.get();
    }

    protected void method_5712(@NotNull class_2338 pPos, @NotNull class_2680 pState) {
        this.method_5783(CompanionsSounds.PUPPET_WALK.get(), 0.45f, 1.0f);
    }

    public void method_5453(@NotNull class_1263 container) {
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            class_1799 old = this.lastStacks[i];
            class_1799 now = this.inventory.method_5438(i);
            if (class_1799.method_7973((class_1799)old, (class_1799)now)) continue;
            this.lastStacks[i] = now.method_7972();
            if (now.method_7960()) continue;
            class_1792 item = now.method_7909();
            if (item == CompanionsItems.CANNON_ARM.get()) {
                this.method_5783(CompanionsSounds.PUPPET_EQUIP_CANON.get(), 0.75f, 1.0f);
                continue;
            }
            if (item == CompanionsItems.MUTANT_ARM.get()) {
                this.method_5783(CompanionsSounds.PUPPET_EQUIP_MUTANT.get(), 0.75f, 1.0f);
                continue;
            }
            if (item == CompanionsItems.WHIP_ARM.get()) {
                this.method_5783(CompanionsSounds.PUPPET_EQUIP_WHIP.get(), 0.75f, 1.0f);
                continue;
            }
            if (item != CompanionsItems.BLADE_ARM.get()) continue;
            this.method_5783(CompanionsSounds.PUPPET_EQUIP_BLADE.get(), 0.75f, 1.0f);
        }
        this.updateContainerEquipment();
    }

    protected void updateContainerEquipment() {
        if (!this.method_37908().field_9236) {
            class_1792 item;
            this.setFlag(!this.inventory.method_5438(0).method_7960());
            int arms = 0;
            String leftArm = "none";
            String rightArm = "none";
            if (!this.inventory.method_5438(0).method_7960()) {
                arms |= 2;
                item = this.inventory.method_5438(0).method_7909();
                if (item == CompanionsItems.CANNON_ARM.get()) {
                    rightArm = "cannon";
                } else if (item == CompanionsItems.MUTANT_ARM.get()) {
                    rightArm = "mutant";
                } else if (item == CompanionsItems.WHIP_ARM.get()) {
                    rightArm = "whip";
                } else if (item == CompanionsItems.BLADE_ARM.get()) {
                    rightArm = "blade";
                }
            }
            if (!this.inventory.method_5438(1).method_7960()) {
                arms |= 1;
                item = this.inventory.method_5438(1).method_7909();
                if (item == CompanionsItems.CANNON_ARM.get()) {
                    leftArm = "cannon";
                } else if (item == CompanionsItems.MUTANT_ARM.get()) {
                    leftArm = "mutant";
                } else if (item == CompanionsItems.WHIP_ARM.get()) {
                    leftArm = "whip";
                } else if (item == CompanionsItems.BLADE_ARM.get()) {
                    leftArm = "blade";
                }
            }
            this.setActiveArms(arms);
            this.setArmNames(leftArm + "," + rightArm);
        }
    }

    protected void setFlag(boolean b) {
        byte $$2 = (Byte)this.field_6011.method_12789(DATA_ID_FLAGS);
        if (b) {
            this.field_6011.method_12778(DATA_ID_FLAGS, (Object)((byte)($$2 | 4)));
        } else {
            this.field_6011.method_12778(DATA_ID_FLAGS, (Object)((byte)($$2 & 0xFFFFFFFB)));
        }
    }

    protected void method_16078() {
        super.method_16078();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.method_5439(); ++i) {
                class_1799 itemStack = this.inventory.method_5438(i);
                if (itemStack.method_7960()) continue;
                this.method_5775(itemStack);
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "rightAttackcontroller", 1, this::rightAttackPredicate));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "leftAttackcontroller", 1, this::leftAttackPredicate));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 1, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState rightAttackPredicate(AnimationState<T> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED) && this.isAttackingRight()) {
            event.getController().forceAnimationReset();
            event.setAnimation(this.ATTACK_R);
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState leftAttackPredicate(AnimationState<T> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED) && this.isAttackingLeft()) {
            event.getController().forceAnimationReset();
            event.setAnimation(this.ATTACK_L);
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getMainAction() == 0) {
            event.setAnimation(this.SIT);
        } else if (event.isMoving()) {
            event.setAnimation(this.WALK);
        } else {
            event.setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }
}

