/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.hostile;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.HostileEntity;
import dev.xylonity.companions.common.entity.ai.minion.hostile.goal.HostileImpBraceAttackGoal;
import dev.xylonity.companions.common.entity.ai.minion.hostile.goal.HostileImpFireMarkAttackGoal;
import dev.xylonity.companions.common.entity.companion.MinionEntity;
import dev.xylonity.companions.common.entity.projectile.ShadeAltarUpgradeHaloProjectile;
import dev.xylonity.companions.registry.CompanionsBlocks;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsParticles;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1379;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class HostileImpEntity
extends HostileEntity {
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation THROW = RawAnimation.begin().thenPlay("throw");
    private final RawAnimation RING = RawAnimation.begin().thenPlay("ring");
    private static final class_2940<Integer> ATTACK_TYPE = class_2945.method_12791(HostileImpEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> ANGRY = class_2945.method_12791(HostileImpEntity.class, (class_2941)class_2943.field_13323);
    private static final int ANGRY_MAX_TICKS = 300;
    private int angryCounter = -1;

    public HostileImpEntity(class_1299<? extends HostileEntity> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel);
    }

    @NotNull
    protected class_1408 method_5965(@NotNull class_1937 pLevel) {
        return new GroundNavigator((class_1308)this, pLevel);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            if (this.isAngry() && this.angryCounter == -1) {
                ++this.angryCounter;
            }
            if (this.angryCounter >= 300) {
                this.angryCounter = -1;
                this.setAngry(false);
                this.method_5980(null);
                this.failureParticles();
            }
            if (this.angryCounter != -1) {
                ++this.angryCounter;
            }
        }
    }

    public static class_5132.class_5133 setAttributes() {
        return HostileEntity.method_26828().method_26868(class_5134.field_23716, 35.0).method_26868(class_5134.field_23721, 5.0).method_26868(class_5134.field_23723, 1.0).method_26868(class_5134.field_23719, (double)0.55f).method_26868(class_5134.field_23717, 35.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new HostileImpBraceAttackGoal(this, 20, 90));
        this.field_6201.method_6277(1, (class_1352)new HostileImpFireMarkAttackGoal(this, 20, 160));
        this.field_6201.method_6277(2, (class_1352)new class_1379((class_1314)this, 0.43));
        this.field_6185.method_6277(1, (class_1352)new class_1400<class_1657>((class_1308)this, class_1657.class, true){

            public boolean method_6264() {
                return super.method_6264() && HostileImpEntity.this.isAngry();
            }
        });
    }

    @NotNull
    public class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        class_1792 item = stack.method_7909();
        class_1269 interactionResult = super.method_5992(player, hand);
        if (!this.isAngry()) {
            if (item == CompanionsBlocks.COPPER_COIN.get().method_8389()) {
                interactionResult = this.handleCoinInteraction(this.method_37908().field_9229.method_43057() < 0.25f, player);
            } else if (item == CompanionsBlocks.NETHER_COIN.get().method_8389()) {
                interactionResult = this.handleCoinInteraction(this.method_37908().field_9229.method_43057() < 0.5f, player);
            } else if (item == CompanionsBlocks.END_COIN.get().method_8389()) {
                interactionResult = this.handleCoinInteraction(this.method_37908().field_9229.method_43057() < 0.8f, player);
            } else {
                player.method_7353((class_2561)class_2561.method_43471((String)"hostile_imp.companions.client_message.requires_coin"), true);
            }
        }
        return interactionResult;
    }

    private class_1269 handleCoinInteraction(boolean tame, class_1657 player) {
        if (this.method_37908().field_9236) {
            return class_1269.field_5812;
        }
        if (tame) {
            this.tameImp(player);
            this.tameParticles();
            this.method_31472();
        } else {
            this.setAngry(true);
            this.failureParticles();
            ShadeAltarUpgradeHaloProjectile halo = (ShadeAltarUpgradeHaloProjectile)CompanionsEntities.SHADE_ALTAR_UPGRADE_HALO.method_5883(this.method_37908());
            if (halo != null) {
                halo.method_29495(this.method_19538());
                this.method_37908().method_8649((class_1297)halo);
            }
        }
        return class_1269.field_5812;
    }

    public boolean method_5974(double pDistanceToClosestPlayer) {
        return false;
    }

    private void tameParticles() {
        for (int i = 0; i < 20; ++i) {
            double dx = (this.field_5974.method_43058() - 0.5) * 2.0;
            double dy = (this.field_5974.method_43058() - 0.5) * 2.0;
            double dz = (this.field_5974.method_43058() - 0.5) * 2.0;
            class_1937 class_19372 = this.method_37908();
            if (!(class_19372 instanceof class_3218)) continue;
            class_3218 level = (class_3218)class_19372;
            if (level.field_9229.method_43057() < 0.65f) {
                level.method_14199((class_2394)class_2398.field_11203, this.method_23317(), this.method_23318() + (double)this.method_17682() * Math.random(), this.method_23321(), 1, dx, dy, dz, 0.1);
            }
            if (!(level.field_9229.method_43057() < 0.25f)) continue;
            level.method_14199((class_2394)CompanionsParticles.SHADE_SUMMON.get(), this.method_23317(), this.method_23318() + (double)this.method_17682() * Math.random(), this.method_23321(), 1, dx, dy, dz, 0.2);
        }
    }

    private void failureParticles() {
        for (int i = 0; i < 20; ++i) {
            double dx = (this.field_5974.method_43058() - 0.5) * 2.0;
            double dy = (this.field_5974.method_43058() - 0.5) * 2.0;
            double dz = (this.field_5974.method_43058() - 0.5) * 2.0;
            class_1937 class_19372 = this.method_37908();
            if (!(class_19372 instanceof class_3218)) continue;
            class_3218 level = (class_3218)class_19372;
            if (!(level.field_9229.method_43057() < 0.65f)) continue;
            level.method_14199((class_2394)class_2398.field_11251, this.method_23317(), this.method_23318() + (double)this.method_17682() * Math.random(), this.method_23321(), 1, dx, dy, dz, 0.025);
        }
    }

    private void tameImp(class_1657 player) {
        MinionEntity minion = (MinionEntity)CompanionsEntities.MINION.method_5883(this.method_37908());
        if (minion != null) {
            minion.method_29495(this.method_19538());
            minion.tameInteraction(player);
            this.method_37908().method_8649((class_1297)minion);
        }
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ATTACK_TYPE, (Object)0);
        builder.method_56912(ANGRY, (Object)false);
    }

    public boolean method_5643(class_1282 pSource, float pAmount) {
        if (pSource.method_5529() != null) {
            this.setAngry(true);
        }
        return super.method_5643(pSource, pAmount);
    }

    public int getAttackType() {
        return (Integer)this.field_6011.method_12789(ATTACK_TYPE);
    }

    public void setAttackType(int attacking) {
        this.field_6011.method_12778(ATTACK_TYPE, (Object)attacking);
    }

    public boolean isAngry() {
        return (Boolean)this.field_6011.method_12789(ANGRY);
    }

    public void setAngry(boolean isAngry) {
        this.field_6011.method_12778(ANGRY, (Object)isAngry);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getAttackType() == 1) {
            event.getController().setAnimation(this.THROW);
        } else if (this.getAttackType() == 2) {
            event.getController().setAnimation(this.RING);
        } else if (event.isMoving()) {
            event.getController().setAnimation(this.WALK);
        } else {
            event.getController().setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }
}

