/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.hostile;

import dev.xylonity.companions.common.entity.companion.PuppetGloveEntity;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import dev.xylonity.knightlib.api.TickScheduler;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HostilePuppetGloveEntity
extends class_1588
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation BROOM_IDLE = RawAnimation.begin().thenPlay("broom_idle");
    private final RawAnimation BROOM_DROP = RawAnimation.begin().thenPlay("broom_drop");
    private final RawAnimation BROOM_PICKUP = RawAnimation.begin().thenPlay("broom_pickup");
    private final RawAnimation GAME_IDLE = RawAnimation.begin().thenPlay("game_idle");
    private final RawAnimation GAME_SCISSORS = RawAnimation.begin().thenPlay("game_scissors");
    private final RawAnimation GAME_ROCK = RawAnimation.begin().thenPlay("game_rock");
    private final RawAnimation GAME_PAPER = RawAnimation.begin().thenPlay("game_paper");
    private final RawAnimation GAME_ATTACK = RawAnimation.begin().thenPlay("game_attack");
    private final RawAnimation GAME_LOOSE = RawAnimation.begin().thenPlay("game_loose");
    private final RawAnimation GAME_TAME = RawAnimation.begin().thenPlay("game_tame");
    private static final class_2940<Boolean> IS_PLAYING = class_2945.method_12791(HostilePuppetGloveEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> GLOVE_MOVE = class_2945.method_12791(HostilePuppetGloveEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> BROOM_PHASE = class_2945.method_12791(HostilePuppetGloveEntity.class, (class_2941)class_2943.field_13327);
    public UUID playingPlayerUUID = null;
    private long gameAutoStop = 0L;
    private long roundsLost = 0L;

    public HostilePuppetGloveEntity(class_1299<? extends class_1588> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel);
    }

    public boolean method_5974(double pDistanceToClosestPlayer) {
        return false;
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23716, 160.0).method_26868(class_5134.field_23721, 5.0).method_26868(class_5134.field_23723, 1.0).method_26868(class_5134.field_23719, (double)0.55f).method_26868(class_5134.field_23717, 35.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(9, (class_1352)new class_1361(this, (class_1308)this, class_1657.class, 15.0f, 0.01f){

            public boolean method_6264() {
                class_1308 class_13082 = this.field_6486;
                if (class_13082 instanceof HostilePuppetGloveEntity) {
                    HostilePuppetGloveEntity glove = (HostilePuppetGloveEntity)class_13082;
                    return glove.playingPlayerUUID != null && super.method_6264();
                }
                return super.method_6264();
            }
        });
    }

    public void method_5773() {
        double lastX = this.method_23317();
        double lastZ = this.method_23321();
        super.method_5773();
        if (!((long)this.field_6012 <= this.gameAutoStop || this.isPlaying() && this.getGloveMove() != 0 || !this.isPlaying() && this.getBroomPhase() != 0 || this.playingPlayerUUID == null)) {
            this.setIsPlaying(false);
            this.setBroomPhase(2);
            TickScheduler.scheduleServer((class_1937)this.method_37908(), () -> this.setBroomPhase(0), (int)20);
            this.playingPlayerUUID = null;
        }
        if (this.field_6012 % 15 == 0 && !this.method_37908().field_9236 && this.getBroomPhase() == 0 && !this.isPlaying()) {
            this.method_5783(CompanionsSounds.HOSTILE_PUPPET_GLOVE_CLEAN.get(), 0.5f, 1.0f);
        }
        this.method_5814(lastX, this.method_23318(), lastZ);
    }

    @NotNull
    protected class_1269 method_5992(@NotNull class_1657 pPlayer, @NotNull class_1268 pHand) {
        if (this.isPlaying() && this.getGloveMove() != 0 || !this.isPlaying() && this.getBroomPhase() != 0) {
            return class_1269.field_5814;
        }
        class_243 entityEyePos = this.method_19538().method_1031(0.0, (double)this.method_5751(), 0.0);
        class_243 playerEyePos = pPlayer.method_19538().method_1031(0.0, (double)pPlayer.method_5751(), 0.0);
        if (this.method_5720().method_1026(playerEyePos.method_1020(entityEyePos).method_1029()) < Math.cos(Math.toRadians(45.0))) {
            return class_1269.field_5814;
        }
        if (this.isPlaying()) {
            int res;
            if (!pPlayer.method_5667().equals(this.playingPlayerUUID)) {
                return class_1269.field_5814;
            }
            class_1799 stack = pPlayer.method_5998(pHand);
            if (!this.isValidItem(stack)) {
                pPlayer.method_7353((class_2561)class_2561.method_43471((String)"hostile_puppet_glove.companions.client_message.wrong_item"), true);
                return class_1269.field_5814;
            }
            if (this.method_37908() instanceof class_3218) {
                this.setGloveMove(this.field_5974.method_43051(1, 4));
            }
            if ((res = this.doesThePlayerWin(this.getPlayerMoveFromItem(stack), this.getGloveMove())) == 0) {
                TickScheduler.scheduleServer((class_1937)this.method_37908(), () -> this.setGloveMove(0), (int)20);
                pPlayer.method_7353((class_2561)class_2561.method_43471((String)"hostile_puppet_glove.companions.client_message.draw"), true);
            } else if (res == 1) {
                TickScheduler.scheduleServer((class_1937)this.method_37908(), () -> this.setGloveMove(4), (int)20);
                TickScheduler.scheduleServer((class_1937)this.method_37908(), () -> this.method_43077(CompanionsSounds.HOSTILE_PUPPET_GLOVE_ATTACK.get()), (int)20);
                List list = this.method_37908().method_18467(class_1657.class, new class_238(this.method_24515()).method_1014(4.0));
                if (list.contains(pPlayer) && HostilePuppetGloveEntity.isEntityInFront((class_1309)this, (class_1297)pPlayer, 120.0)) {
                    TickScheduler.scheduleServer((class_1937)this.method_37908(), () -> this.method_6121((class_1297)pPlayer), (int)25);
                }
                TickScheduler.scheduleServer((class_1937)this.method_37908(), () -> this.setGloveMove(0), (int)30);
                pPlayer.method_7353((class_2561)class_2561.method_43471((String)"hostile_puppet_glove.companions.client_message.glove_wins"), true);
            } else if (this.roundsLost != 3L) {
                TickScheduler.scheduleServer((class_1937)this.method_37908(), () -> this.setGloveMove(5), (int)20);
                TickScheduler.scheduleServer((class_1937)this.method_37908(), () -> this.method_43077(CompanionsSounds.HOSTILE_PUPPET_GLOVE_LOOSE.get()), (int)20);
                TickScheduler.scheduleServer((class_1937)this.method_37908(), () -> this.setGloveMove(0), (int)53);
                pPlayer.method_7353((class_2561)class_2561.method_43471((String)"hostile_puppet_glove.companions.client_message.player_wins_round"), true);
                ++this.roundsLost;
            } else {
                TickScheduler.scheduleServer((class_1937)this.method_37908(), () -> this.setGloveMove(6), (int)20);
                TickScheduler.scheduleServer((class_1937)this.method_37908(), () -> {
                    PuppetGloveEntity glove = (PuppetGloveEntity)CompanionsEntities.PUPPET_GLOVE.method_5883(this.method_37908());
                    if (glove != null) {
                        for (int i = 0; i < 50; ++i) {
                            double dx = (this.field_5974.method_43058() - 0.5) * 2.0;
                            double dy = (this.field_5974.method_43058() - 0.5) * 2.0;
                            double dz = (this.field_5974.method_43058() - 0.5) * 2.0;
                            class_1937 patt0$temp = this.method_37908();
                            if (!(patt0$temp instanceof class_3218)) continue;
                            class_3218 level = (class_3218)patt0$temp;
                            level.method_14199((class_2394)class_2398.field_11203, this.method_23317(), this.method_23318() + (double)this.method_17682() * 0.5, this.method_23321(), 1, dx, dy, dz, 0.1);
                        }
                        glove.method_6170(pPlayer);
                        glove.method_29495(this.method_24515().method_46558());
                        glove.method_36457(this.method_36455());
                        glove.method_36456(this.method_36454());
                        this.method_37908().method_8649((class_1297)glove);
                    }
                    this.method_5650(class_1297.class_5529.field_26999);
                }, (int)64);
                pPlayer.method_7353((class_2561)class_2561.method_43471((String)"hostile_puppet_glove.companions.client_message.player_wins"), true);
                this.playingPlayerUUID = null;
            }
            this.gameAutoStop = this.field_6012 + 600;
        } else {
            this.setBroomPhase(1);
            TickScheduler.scheduleServer((class_1937)this.method_37908(), () -> this.setIsPlaying(true), (int)20);
            TickScheduler.scheduleServer((class_1937)this.method_37908(), () -> this.setGloveMove(0), (int)20);
            this.playingPlayerUUID = pPlayer.method_5667();
            this.gameAutoStop = this.field_6012 + 600;
            pPlayer.method_7353((class_2561)class_2561.method_43471((String)"hostile_puppet_glove.companions.client_message.game_start"), true);
        }
        return class_1269.field_5812;
    }

    public static boolean isEntityInFront(class_1309 viewer, class_1297 target, double fov) {
        class_243 toTarget;
        class_243 view = viewer.method_5720().method_1029();
        double angle = Math.acos(view.method_1026(toTarget = new class_243(target.method_23317(), viewer.method_23318(), target.method_23321()).method_1020(viewer.method_19538()).method_1029())) * 57.29577951308232;
        return angle < fov / 2.0;
    }

    private int doesThePlayerWin(int playerMove, int gloveMove) {
        if (playerMove == 0) {
            if (gloveMove == 1) {
                return 0;
            }
            if (gloveMove == 2) {
                return 1;
            }
            if (gloveMove == 3) {
                return 2;
            }
        } else if (playerMove == 1) {
            if (gloveMove == 1) {
                return 2;
            }
            if (gloveMove == 2) {
                return 0;
            }
            if (gloveMove == 3) {
                return 1;
            }
        } else if (playerMove == 2) {
            if (gloveMove == 1) {
                return 1;
            }
            if (gloveMove == 2) {
                return 2;
            }
            if (gloveMove == 3) {
                return 0;
            }
        }
        return -1;
    }

    private boolean isValidItem(class_1799 stack) {
        return stack.method_7909() == class_1802.field_8407 || stack.method_7909() == class_1802.field_20412 || stack.method_7909() == class_1802.field_8868;
    }

    private int getPlayerMoveFromItem(class_1799 stack) {
        if (stack.method_7909() == class_1802.field_20412) {
            return 0;
        }
        if (stack.method_7909() == class_1802.field_8407) {
            return 1;
        }
        if (stack.method_7909() == class_1802.field_8868) {
            return 2;
        }
        return -1;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(IS_PLAYING, (Object)false);
        builder.method_56912(GLOVE_MOVE, (Object)-1);
        builder.method_56912(BROOM_PHASE, (Object)0);
    }

    private void setIsPlaying(boolean playing) {
        this.field_6011.method_12778(IS_PLAYING, (Object)playing);
    }

    private boolean isPlaying() {
        return (Boolean)this.field_6011.method_12789(IS_PLAYING);
    }

    private void setBroomPhase(int phase) {
        this.field_6011.method_12778(BROOM_PHASE, (Object)phase);
    }

    private int getBroomPhase() {
        return (Integer)this.field_6011.method_12789(BROOM_PHASE);
    }

    private void setGloveMove(int phase) {
        this.field_6011.method_12778(GLOVE_MOVE, (Object)phase);
    }

    private int getGloveMove() {
        return (Integer)this.field_6011.method_12789(GLOVE_MOVE);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.isPlaying()) {
            if (this.getGloveMove() == 1) {
                event.setAnimation(this.GAME_ROCK);
            } else if (this.getGloveMove() == 2) {
                event.setAnimation(this.GAME_PAPER);
            } else if (this.getGloveMove() == 3) {
                event.setAnimation(this.GAME_SCISSORS);
            } else if (this.getGloveMove() == 4) {
                event.setAnimation(this.GAME_ATTACK);
            } else if (this.getGloveMove() == 5) {
                event.setAnimation(this.GAME_LOOSE);
            } else if (this.getGloveMove() == 6) {
                event.setAnimation(this.GAME_TAME);
            } else {
                event.setAnimation(this.GAME_IDLE);
            }
        } else if (this.getBroomPhase() == 1) {
            event.setAnimation(this.BROOM_DROP);
        } else if (this.getBroomPhase() == 2) {
            event.setAnimation(this.BROOM_PICKUP);
        } else {
            event.setAnimation(this.BROOM_IDLE);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

