/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.common.entity.projectile.SmallIceShardProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.registry.CompanionsEntities;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3966;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BigIceShardProjectile
extends class_1665
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final int LIFETIME = 25;
    private static final double RAY_DISTANCE = 64.0;
    private static final double SMALL_SHARD_SPEED = 0.4;
    private static final RawAnimation APPEAR = RawAnimation.begin().thenPlay("appear");
    private class_1309 target;

    public BigIceShardProjectile(class_1299<? extends class_1665> type, class_1937 level) {
        super(type, level);
        double minElevation = Math.toRadians(30.0);
        double elevation = minElevation + this.field_5974.method_43058() * (Math.toRadians(90.0) - minElevation);
        double t = this.field_5974.method_43058() * Math.PI * 2.0;
        double dx = Math.cos(elevation) * Math.cos(t);
        double dy = Math.sin(elevation);
        double dz = Math.cos(elevation) * Math.sin(t);
        this.method_18799(new class_243(dx, dy, dz).method_1029().method_1021(4.0));
        this.field_7572 = class_1665.class_1666.field_7592;
    }

    protected boolean method_26958(@NotNull class_1297 entity) {
        if (Util.areEntitiesLinked(entity, (class_1297)this)) {
            return false;
        }
        return super.method_26958(entity);
    }

    public void setTarget(@Nullable class_1309 tgt) {
        this.target = tgt;
    }

    @Nullable
    public class_1309 getTarget() {
        return this.target;
    }

    public void method_5773() {
        super.method_5773();
        class_1297 owner = this.method_24921();
        if (owner != null) {
            this.method_5875(true);
            if (this.field_6012 < 25) {
                this.method_18799(this.method_18798().method_1021(0.95));
            }
            if (this.field_6012 == 25) {
                if (this.method_37908().field_9236) {
                    this.spawnHitParticles();
                } else {
                    this.method_37908().method_8421((class_1297)this, (byte)3);
                    this.method_43077(class_3417.field_43154);
                }
                for (int i = 0; i < 5; ++i) {
                    SmallIceShardProjectile shard = (SmallIceShardProjectile)CompanionsEntities.SMALL_ICE_SHARD_PROJECTILE.method_5883(this.method_37908());
                    if (shard == null) continue;
                    shard.method_24203(this.method_23317(), this.method_23318(), this.method_23321());
                    shard.method_7432(owner);
                    class_1309 target1 = this.getTarget();
                    if (target1 == null && owner instanceof class_1309) {
                        class_1309 livingOwner = (class_1309)owner;
                        target1 = BigIceShardProjectile.findEntityInCrosshair(livingOwner);
                    }
                    if (target1 != null) {
                        shard.setTarget(target1);
                    } else {
                        shard.setFollowOwnerLook(true);
                        shard.shootTowards(BigIceShardProjectile.genRandomShardDir(owner instanceof class_1309 ? owner.method_5720() : this.method_18798().method_1029()), 0.4);
                    }
                    this.method_37908().method_8649((class_1297)shard);
                }
                this.method_5650(class_1297.class_5529.field_26999);
            }
        }
    }

    @Nullable
    private static class_1309 findEntityInCrosshair(class_1309 player) {
        class_238 bb = player.method_5829().method_18804(player.method_5720().method_1021(64.0)).method_1014(1.0);
        class_3966 hit = class_1675.method_18077((class_1937)player.method_37908(), (class_1297)player, (class_243)player.method_33571(), (class_243)player.method_33571().method_1019(player.method_5720().method_1021(64.0)), (class_238)bb, e -> e instanceof class_1309 && e != player);
        return hit != null ? (class_1309)hit.method_17782() : null;
    }

    private static class_243 genRandomShardDir(class_243 dir) {
        Random random = new Random();
        class_243 forward = dir.method_1029();
        class_243 up = Math.abs(forward.method_1026(new class_243(0.0, 1.0, 0.0))) > 0.99 ? new class_243(1.0, 0.0, 0.0) : new class_243(0.0, 1.0, 0.0);
        class_243 right = forward.method_1036(up).method_1029();
        up = right.method_1036(forward).method_1029();
        double maxRad = Math.toRadians(8.0);
        double ct = random.nextDouble() * (1.0 - Math.cos(maxRad)) + Math.cos(maxRad);
        double st = Math.sqrt(1.0 - ct * ct);
        double ph = random.nextDouble() * Math.PI * 2.0;
        return forward.method_1021(ct).method_1019(right.method_1021(st * Math.cos(ph))).method_1019(up.method_1021(st * Math.sin(ph))).method_1029();
    }

    private void spawnHitParticles() {
        for (int i = 0; i < 10; ++i) {
            double dx = (this.method_37908().method_8409().method_43058() - 0.5) * 0.1;
            double dy = (this.method_37908().method_8409().method_43058() - 0.5) * 0.1;
            double dz = (this.method_37908().method_8409().method_43058() - 0.5) * 0.1;
            this.method_37908().method_8406((class_2394)class_2398.field_28013, this.method_23317(), this.method_23318(), this.method_23321(), dx, dy, dz);
        }
    }

    public void method_5711(byte pId) {
        if (pId == 3) {
            this.spawnHitParticles();
        } else {
            super.method_5711(pId);
        }
    }

    @NotNull
    protected class_3414 method_7440() {
        return class_3417.field_26982;
    }

    protected boolean method_34713(@NotNull class_1657 pPlayer) {
        return false;
    }

    @NotNull
    protected class_1799 method_7445() {
        return class_1799.field_8037;
    }

    protected class_1799 method_57314() {
        return class_1799.field_8037;
    }

    public void method_5694(@NotNull class_1657 pPlayer) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.field_6012 <= 8) {
            event.getController().setAnimation(APPEAR);
        }
        return PlayState.CONTINUE;
    }
}

