/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.entity.CompanionSummonEntity;
import dev.xylonity.companions.common.entity.summon.BubbleFrogEntity;
import dev.xylonity.companions.common.entity.summon.EmberPoleEntity;
import dev.xylonity.companions.common.entity.summon.EnderFrogEntity;
import dev.xylonity.companions.common.entity.summon.FireworkToadEntity;
import dev.xylonity.companions.common.entity.summon.NetherBullfrogEntity;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class ScrollProjectile
extends BaseProjectile {
    private final RawAnimation SPAWN = RawAnimation.begin().thenPlay("spawn");
    private static final class_2940<Integer> ENTITY_TO_SPAWN = class_2945.method_12791(ScrollProjectile.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Optional<UUID>> OWNER_UUID = class_2945.method_12791(ScrollProjectile.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Optional<UUID>> SECOND_OWNER_UUID = class_2945.method_12791(ScrollProjectile.class, (class_2941)class_2943.field_13313);
    public static final int WHEN_TO_SUMMON = 30;

    public ScrollProjectile(class_1299<? extends BaseProjectile> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.field_6012 == 30 && !this.method_37908().field_9236) {
            this.spawnParticles();
            CompanionSummonEntity e = this.getEntityToSpawn();
            if (e != null && this.getOwnerUUID() != null) {
                e.method_6174(this.getOwnerUUID());
                e.setSecondOwnerUUID(this.getSecondOwnerUUID());
                e.method_6173(true, false);
                e.method_29495(this.method_19538());
                this.method_37908().method_8649((class_1297)e);
            }
            this.method_5783(CompanionsSounds.SCROLL_SOUND.get(), 0.75f, 1.0f);
        }
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.field_6011.method_12789(OWNER_UUID)).orElse(null);
    }

    public void setOwnerUUID(UUID pUuid) {
        this.field_6011.method_12778(OWNER_UUID, Optional.ofNullable(pUuid));
    }

    public UUID getSecondOwnerUUID() {
        return ((Optional)this.field_6011.method_12789(SECOND_OWNER_UUID)).orElse(null);
    }

    public void setSecondOwnerUUID(UUID pUuid) {
        this.field_6011.method_12778(SECOND_OWNER_UUID, Optional.ofNullable(pUuid));
    }

    private CompanionSummonEntity getEntityToSpawn() {
        return switch ((Integer)this.field_6011.method_12789(ENTITY_TO_SPAWN)) {
            case 1 -> (FireworkToadEntity)CompanionsEntities.FIREWORK_TOAD.method_5883(this.method_37908());
            case 2 -> (NetherBullfrogEntity)CompanionsEntities.NETHER_BULLFROG.method_5883(this.method_37908());
            case 3 -> (EnderFrogEntity)CompanionsEntities.ENDER_FROG.method_5883(this.method_37908());
            case 4 -> (EmberPoleEntity)CompanionsEntities.EMBER_POLE.method_5883(this.method_37908());
            case 5 -> (BubbleFrogEntity)CompanionsEntities.BUBBLE_FROG.method_5883(this.method_37908());
            default -> null;
        };
    }

    private void spawnParticles() {
        for (int i = 0; i < 10; ++i) {
            double dx = (this.method_37908().field_9229.method_43058() - 0.5) * 0.75;
            double dy = (this.method_37908().field_9229.method_43058() - 0.5) * 0.75;
            double dz = (this.method_37908().field_9229.method_43058() - 0.5) * 0.75;
            class_1937 class_19372 = this.method_37908();
            if (!(class_19372 instanceof class_3218)) continue;
            class_3218 level = (class_3218)class_19372;
            level.method_14199((class_2394)class_2398.field_11203, this.method_19538().field_1352, this.method_19538().field_1351 + (double)this.method_17682(), this.method_19538().field_1350, 1, dx, dy, dz, 0.1);
        }
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ENTITY_TO_SPAWN, (Object)0);
        builder.method_56912(OWNER_UUID, Optional.empty());
        builder.method_56912(SECOND_OWNER_UUID, Optional.empty());
    }

    public void setEntityToSpawn(int id) {
        this.field_6011.method_12778(ENTITY_TO_SPAWN, (Object)id);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        event.setAnimation(this.SPAWN);
        return PlayState.CONTINUE;
    }

    @Override
    protected int baseLifetime() {
        return 47;
    }
}

