/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3966;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SmallIceShardProjectile
extends class_1665
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final int PHASE_1_DURATION = 20;
    private static final double PHASE_1_FRICTION = 0.95;
    private static final double PHASE_2_FRICTION = 0.88;
    private static final double PHASE_2_ACCELERATION = 0.04;
    private static final int LIFETIME = 200;
    private class_1309 target;
    private boolean followOwnerLook = false;
    private final Quaternionf prevRotation = new Quaternionf();
    private final Quaternionf currentRotation = new Quaternionf();

    public SmallIceShardProjectile(class_1299<? extends class_1665> type, class_1937 level) {
        super(type, level);
        class_243 randomDir = new class_243(this.field_5974.method_43058() * 2.0 - 1.0, this.field_5974.method_43058() * 2.0 - 1.0, this.field_5974.method_43058() * 2.0 - 1.0).method_1029();
        this.method_18799(randomDir.method_1021(0.2));
        this.method_5875(true);
        this.field_7572 = class_1665.class_1666.field_7592;
    }

    public void setTarget(@Nullable class_1309 target) {
        this.target = target;
    }

    @Nullable
    public class_1309 getTarget() {
        return this.target;
    }

    protected boolean method_26958(@NotNull class_1297 entity) {
        if (Util.areEntitiesLinked(entity, (class_1297)this)) {
            return false;
        }
        return super.method_26958(entity);
    }

    public void method_5773() {
        class_1297 targetPos;
        super.method_5773();
        if (this.target != null) {
            if (this.field_6012 < 20) {
                this.method_18799(this.method_18798().method_1021(0.95));
            } else {
                targetPos = new class_243(this.target.method_23317(), this.target.method_23318() + (double)this.target.method_17682() * 0.7, this.target.method_23321());
                class_243 diff = targetPos.method_1020(this.method_19538());
                class_243 newVel = this.method_18798().method_1021(0.88).method_1019(diff.method_1029().method_1021(0.04));
                this.method_18799(newVel);
            }
        } else if (this.followOwnerLook && (targetPos = this.method_24921()) instanceof class_1309) {
            class_1309 owner = (class_1309)targetPos;
            if (this.field_6012 < 20) {
                this.method_18799(this.method_18798().method_1021(0.95));
            } else {
                targetPos = owner.method_5720().method_1029();
                class_243 newVel = this.method_18798().method_1021(0.88).method_1019(targetPos.method_1021(0.04));
                this.method_18799(newVel);
            }
        }
        this.updateRotations();
        if (this.field_6012 == 200) {
            if (this.method_37908().field_9236) {
                this.spawnHitParticles();
            } else {
                this.method_37908().method_8421((class_1297)this, (byte)3);
                this.method_43077(class_3417.field_43154);
            }
            this.method_5650(class_1297.class_5529.field_26999);
        }
        if (this.method_37908().field_9236 && (this.field_6012 % 40 == 0 || this.field_6012 == 1)) {
            float r = (float)(190 + this.method_37908().field_9229.method_43048(30)) / 255.0f;
            float g = (float)(240 + this.method_37908().field_9229.method_43048(10)) / 255.0f;
            float b = (float)(247 + this.method_37908().field_9229.method_43048(5)) / 255.0f;
            Companions.PROXY.spawnBaseProjectileTrail((class_1297)this, 0.0f, this.method_17682() * 0.5f, r, g, b);
        }
    }

    private void updateRotations() {
        class_243 vel = this.method_18798();
        if (vel.method_1027() <= 1.0E-7) {
            return;
        }
        this.prevRotation.set((Quaternionfc)this.currentRotation);
        Vector3f velVec = new Vector3f((float)vel.field_1352, (float)vel.field_1351, (float)vel.field_1350).normalize();
        Vector3f forward = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f axis = forward.cross((Vector3fc)velVec);
        if (axis.length() < 1.0E-4f) {
            axis.set(0.0f, 1.0f, 0.0f);
        } else {
            axis.normalize();
        }
        float dot = Math.max(-1.0f, Math.min(1.0f, forward.dot((Vector3fc)velVec)));
        Quaternionf targetRot = new Quaternionf().fromAxisAngleRad((Vector3fc)axis, (float)Math.acos(dot));
        if (this.field_6012 < 20) {
            this.currentRotation.set((Quaternionfc)targetRot);
        } else {
            this.currentRotation.slerp((Quaternionfc)targetRot, 0.5f);
        }
    }

    protected void method_7488(@NotNull class_239 pResult) {
        if (pResult.method_17783().equals((Object)class_239.class_240.field_1331)) {
            class_1321 t;
            class_1297 target = ((class_3966)pResult).method_17782();
            if (target.equals((Object)this.method_24921()) || target instanceof class_1321 && (t = (class_1321)target).method_35057() != null && t.method_35057().equals((Object)this.method_24921())) {
                return;
            }
            target.method_5643(this.method_48923().method_48831(), (float)CompanionsConfig.SMALL_ICE_SHARD_DAMAGE);
            target.method_32317(target.method_32312() + CompanionsConfig.SMALL_ICE_SHARD_FREEZE_TICKS);
        }
        if (this.method_37908().field_9236) {
            this.spawnHitParticles();
        } else {
            this.method_37908().method_8421((class_1297)this, (byte)3);
            this.method_43077(class_3417.field_26982);
        }
        this.method_5650(class_1297.class_5529.field_26999);
    }

    public void method_5711(byte pId) {
        if (pId == 3) {
            this.spawnHitParticles();
        } else {
            super.method_5711(pId);
        }
    }

    public void setFollowOwnerLook(boolean ownerLook) {
        this.followOwnerLook = ownerLook;
    }

    public void shootTowards(class_243 dir, double speed) {
        this.method_18799(dir.method_1029().method_1021(speed));
    }

    public Quaternionf getPrevRotation() {
        return this.prevRotation;
    }

    public Quaternionf getCurrentRotation() {
        return this.currentRotation;
    }

    private void spawnHitParticles() {
        for (int i = 0; i < 5; ++i) {
            double dx = (this.method_37908().method_8409().method_43058() - 0.5) * 0.1;
            double dy = (this.method_37908().method_8409().method_43058() - 0.5) * 0.1;
            double dz = (this.method_37908().method_8409().method_43058() - 0.5) * 0.1;
            this.method_37908().method_8406((class_2394)class_2398.field_28013, this.method_23317(), this.method_23318(), this.method_23321(), dx, dy, dz);
            if (i % 2 != 0) continue;
            this.method_37908().method_8406((class_2394)new class_2392(class_2398.field_11218, new class_1799((class_1935)class_1802.field_8426)), this.method_23317(), this.method_23318() + (double)this.method_17682() * 0.5, this.method_23321(), dx, dy, dz);
        }
    }

    protected boolean method_34713(@NotNull class_1657 p) {
        return false;
    }

    @NotNull
    protected class_1799 method_7445() {
        return class_1799.field_8037;
    }

    protected class_1799 method_57314() {
        return class_1799.field_8037;
    }

    public void method_5694(@NotNull class_1657 p) {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar r) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

