/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class TornadoProjectile
extends BaseProjectile {
    private final RawAnimation SPIN = RawAnimation.begin().thenPlay("spin");
    private static final class_2940<Float> GROUNDY = class_2945.method_12791(TornadoProjectile.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> STARTX = class_2945.method_12791(TornadoProjectile.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> STARTZ = class_2945.method_12791(TornadoProjectile.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> ALPHA = class_2945.method_12791(TornadoProjectile.class, (class_2941)class_2943.field_13320);
    private boolean initialized = false;

    public TornadoProjectile(class_1299<? extends BaseProjectile> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(GROUNDY, (Object)Float.valueOf(0.0f));
        builder.method_56912(STARTX, (Object)Float.valueOf(0.0f));
        builder.method_56912(STARTZ, (Object)Float.valueOf(0.0f));
        builder.method_56912(ALPHA, (Object)Float.valueOf(0.0f));
    }

    public float getGroundY() {
        return ((Float)this.field_6011.method_12789(GROUNDY)).floatValue();
    }

    public void setGroundY(float v) {
        this.field_6011.method_12778(GROUNDY, (Object)Float.valueOf(v));
    }

    public float getStartX() {
        return ((Float)this.field_6011.method_12789(STARTX)).floatValue();
    }

    public void setStartX(float v) {
        this.field_6011.method_12778(STARTX, (Object)Float.valueOf(v));
    }

    public float getStartZ() {
        return ((Float)this.field_6011.method_12789(STARTZ)).floatValue();
    }

    public void setStartZ(float v) {
        this.field_6011.method_12778(STARTZ, (Object)Float.valueOf(v));
    }

    public float getAlpha() {
        return ((Float)this.field_6011.method_12789(ALPHA)).floatValue();
    }

    public void setAlpha(float v) {
        this.field_6011.method_12778(ALPHA, (Object)Float.valueOf(v));
    }

    @Override
    public void method_5773() {
        super.method_5773();
        class_1297 owner = this.method_24921();
        if (!this.initialized) {
            this.setGroundY((float)this.method_23318());
            this.setStartX((float)this.method_23317());
            this.setStartZ((float)this.method_23321());
            if (owner != null) {
                class_243 ownerPos = owner.method_5836(1.0f);
                class_243 projPos = this.method_19538();
                class_243 dir = projPos.method_1020(ownerPos).method_1029();
                this.setAlpha((float)Math.atan2(dir.field_1350, dir.field_1352));
            } else {
                this.setAlpha(0.0f);
            }
            this.method_5875(true);
            this.initialized = true;
        }
        if (this.field_6012 >= this.getLifetime()) {
            this.onExpire();
            return;
        }
        double t = (double)this.field_6012 * 0.2;
        double xLocal = Math.sin(0.5 * t) + t;
        double zLocal = Math.cos(0.5 * t);
        double cosA = Math.cos(this.getAlpha());
        double sinA = Math.sin(this.getAlpha());
        this.method_5814((double)this.getStartX() + (xLocal * cosA - zLocal * sinA), this.getGroundY(), (double)this.getStartZ() + (xLocal * sinA + zLocal * cosA));
        this.method_37908().method_8390(class_1297.class, this.method_5829().method_1014(1.0), e -> !Util.areEntitiesLinked((class_1297)this, e)).forEach(e -> {
            class_243 dir = e.method_19538().method_1020(this.method_19538()).method_1029().method_1021(1.4);
            e.method_5762(dir.field_1352 + 0.1, dir.field_1351 + 0.1, dir.field_1350 + 0.1);
            if (e instanceof class_1309) {
                class_1309 living = (class_1309)e;
                living.method_5643(this.method_48923().method_48831(), (float)CompanionsConfig.ICE_TORNADO_DAMAGE);
            }
        });
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 sv = (class_3218)class_19372;
            Random random = new Random();
            if ((double)random.nextFloat() <= 0.8) {
                sv.method_14199((class_2394)class_2398.field_28013, this.method_23317() + (double)(this.method_17681() * 2.0f) * Math.random(), this.method_23318() + (double)(this.method_17682() * 2.0f) * Math.random(), this.method_23321() + (double)(this.method_17681() * 2.0f) * Math.random(), 1, 0.0, 0.0, 0.0, 0.05);
            }
        }
        if (this.method_37908().field_9236 && (this.field_6012 % 15 == 0 || this.field_6012 == 1)) {
            for (int i = 0; i < 3; ++i) {
                float r = (float)(190 + this.method_37908().field_9229.method_43048(30)) / 255.0f;
                float g = (float)(240 + this.method_37908().field_9229.method_43048(10)) / 255.0f;
                float b = (float)(247 + this.method_37908().field_9229.method_43048(5)) / 255.0f;
                Companions.PROXY.spawnBaseProjectileTrail((class_1297)this, this.method_17681() + this.method_37908().field_9229.method_43057() * 0.6f, this.method_17682() + this.method_37908().field_9229.method_43057() * 0.5f, r, g, b);
            }
        }
    }

    private void onExpire() {
        if (this.method_37908().field_9236) {
            this.spawnHitParticles();
        } else {
            this.method_37908().method_8421((class_1297)this, (byte)3);
            this.method_43077(class_3417.field_26980);
        }
        this.method_5650(class_1297.class_5529.field_26999);
    }

    public void method_5711(byte pId) {
        if (pId == 3) {
            this.spawnHitParticles();
        } else {
            super.method_5711(pId);
        }
    }

    private void spawnHitParticles() {
        for (int i = 0; i < 10; ++i) {
            double x = this.method_23317() + (double)(this.method_17681() * 2.0f) * Math.random();
            double y = this.method_23318() + (double)(this.method_17682() * 2.0f) * Math.random();
            double z = this.method_23321() + (double)(this.method_17681() * 2.0f) * Math.random();
            this.method_37908().method_8406((class_2394)class_2398.field_28013, x, y, z, 0.05, 0.05, 0.05);
        }
    }

    protected void method_7488(@NotNull class_239 pResult) {
        class_3965 blockHit;
        class_2350 hitDirection;
        if (pResult instanceof class_3965 && ((hitDirection = (blockHit = (class_3965)pResult).method_17780()) == class_2350.field_11036 || hitDirection == class_2350.field_11033)) {
            return;
        }
        if (this.method_37908().field_9236) {
            this.spawnHitParticles();
        } else {
            this.method_37908().method_8421((class_1297)this, (byte)3);
            this.method_43077(class_3417.field_26982);
        }
        this.method_5650(class_1297.class_5529.field_26999);
    }

    public void method_5694(@NotNull class_1657 pEntity) {
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", this::predicate));
    }

    @Override
    protected int baseLifetime() {
        return 120;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        event.getController().setAnimation(this.SPIN);
        return PlayState.CONTINUE;
    }
}

