/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile.trigger;

import dev.xylonity.companions.common.entity.hostile.SacredPontiffEntity;
import dev.xylonity.companions.common.entity.projectile.FireRayPieceProjectile;
import dev.xylonity.companions.registry.CompanionsEntities;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtil;

public class FireRayBeamEntity
extends class_1297
implements GeoAnimatable {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final class_2940<Float> ORIGIN_X = class_2945.method_12791(FireRayBeamEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> ORIGIN_Y = class_2945.method_12791(FireRayBeamEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> ORIGIN_Z = class_2945.method_12791(FireRayBeamEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> START_YAW = class_2945.method_12791(FireRayBeamEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Integer> ROT_TICKS = class_2945.method_12791(FireRayBeamEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> MAX_PIECES = class_2945.method_12791(FireRayBeamEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> SEPARATION = class_2945.method_12791(FireRayBeamEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> START_PITCH = class_2945.method_12791(FireRayBeamEntity.class, (class_2941)class_2943.field_13320);
    private int age;
    private UUID[] pieceUUIDs;

    public FireRayBeamEntity(class_1299<? extends FireRayBeamEntity> type, class_1937 level) {
        super(type, level);
        this.field_5960 = true;
        this.pieceUUIDs = new UUID[0];
    }

    public FireRayBeamEntity(class_3218 lvl, class_243 origin, float yaw0, float pitch0, int rotTicks, int maxPieces, float sep, SacredPontiffEntity entity) {
        this(CompanionsEntities.FIRE_RAY_BEAM_ENTITY, (class_1937)lvl);
        this.method_5814(origin.field_1352, origin.field_1351, origin.field_1350);
        this.field_6011.method_12778(ORIGIN_X, (Object)Float.valueOf((float)origin.field_1352));
        this.field_6011.method_12778(ORIGIN_Y, (Object)Float.valueOf((float)origin.field_1351));
        this.field_6011.method_12778(ORIGIN_Z, (Object)Float.valueOf((float)origin.field_1350));
        this.field_6011.method_12778(START_YAW, (Object)Float.valueOf(yaw0));
        this.field_6011.method_12778(START_PITCH, (Object)Float.valueOf(pitch0));
        this.field_6011.method_12778(ROT_TICKS, (Object)rotTicks);
        this.field_6011.method_12778(MAX_PIECES, (Object)maxPieces);
        this.field_6011.method_12778(SEPARATION, (Object)Float.valueOf(sep));
        this.pieceUUIDs = new UUID[maxPieces];
        this.spawnPieces(lvl, entity);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(ORIGIN_X, (Object)Float.valueOf(0.0f));
        builder.method_56912(ORIGIN_Y, (Object)Float.valueOf(0.0f));
        builder.method_56912(ORIGIN_Z, (Object)Float.valueOf(0.0f));
        builder.method_56912(START_YAW, (Object)Float.valueOf(0.0f));
        builder.method_56912(ROT_TICKS, (Object)0);
        builder.method_56912(MAX_PIECES, (Object)0);
        builder.method_56912(SEPARATION, (Object)Float.valueOf(0.0f));
        builder.method_56912(START_PITCH, (Object)Float.valueOf(0.0f));
    }

    protected void method_5749(@NotNull class_2487 tag) {
    }

    protected void method_5652(@NotNull class_2487 tag) {
    }

    private void spawnPieces(class_3218 level, SacredPontiffEntity entity) {
        int maxPieces = (Integer)this.field_6011.method_12789(MAX_PIECES);
        for (int i = 0; i < maxPieces; ++i) {
            FireRayPieceProjectile piece = (FireRayPieceProjectile)CompanionsEntities.FIRE_RAY_PIECE_PROJECTILE.method_5883((class_1937)level);
            if (piece == null) continue;
            piece.initAsChild(this, i);
            piece.method_7432((class_1297)entity);
            level.method_8649((class_1297)piece);
            this.pieceUUIDs[i] = piece.method_5667();
        }
    }

    public boolean method_31746() {
        return false;
    }

    public boolean method_5662(class_2487 compound) {
        return false;
    }

    public boolean method_5786(class_2487 compound) {
        return false;
    }

    public void method_5773() {
        class_1937 class_19372;
        super.method_5773();
        if (this.method_37908().field_9236) {
            return;
        }
        if (this.field_6012 % 5 == 0 && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_14199((class_2394)class_2398.field_17909, this.method_23317(), this.method_23318(), this.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        float eased = 0.5f * (1.0f - class_3532.method_15362((float)((float)this.age / (float)((Integer)this.field_6011.method_12789(ROT_TICKS)).intValue() * (float)Math.PI)));
        double yaw = Math.toRadians((((Float)this.field_6011.method_12789(START_YAW)).floatValue() + eased * 720.0f) % 360.0f);
        double pitch = Math.toRadians(((Float)this.field_6011.method_12789(START_PITCH)).floatValue());
        class_243 direction = new class_243(Math.cos(pitch) * Math.cos(yaw), Math.sin(pitch), Math.cos(pitch) * Math.sin(yaw));
        class_243 origin = new class_243((double)((Float)this.field_6011.method_12789(ORIGIN_X)).floatValue(), (double)((Float)this.field_6011.method_12789(ORIGIN_Y)).floatValue(), (double)((Float)this.field_6011.method_12789(ORIGIN_Z)).floatValue());
        boolean blocked = false;
        for (int i = 0; i < this.pieceUUIDs.length; ++i) {
            boolean solid;
            class_1297 e = ((class_3218)this.method_37908()).method_14190(this.pieceUUIDs[i]);
            if (!(e instanceof FireRayPieceProjectile)) continue;
            FireRayPieceProjectile piece = (FireRayPieceProjectile)e;
            class_243 pos = origin.method_1019(direction.method_1021((double)((float)i * ((Float)this.field_6011.method_12789(SEPARATION)).floatValue())));
            piece.syncPosition(pos);
            boolean bl = solid = !this.method_37908().method_8320(class_2338.method_49638((class_2374)pos)).method_26220((class_1922)this.method_37908(), class_2338.method_49638((class_2374)pos)).method_1110();
            if (!blocked && solid) {
                blocked = true;
                piece.method_5648(false);
            } else if (blocked) {
                piece.method_5648(true);
            } else {
                piece.method_5648(false);
            }
            if (i != 0) continue;
            piece.method_5648(true);
        }
        if (++this.age >= 135) {
            this.method_31472();
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object o) {
        return RenderUtil.getCurrentTick();
    }
}

