/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.item.book.books;

import dev.xylonity.companions.common.entity.projectile.HolinessNaginataProjectile;
import dev.xylonity.companions.common.item.book.AbstractMagicBook;
import dev.xylonity.companions.common.material.ArmorMaterials;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.NotNull;

public class NaginataBook
extends AbstractMagicBook {
    public NaginataBook(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    protected String tooltipName() {
        return "naginata_book";
    }

    @Override
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"tooltip.item.companions.naginata_book_2"));
        super.method_7851(stack, context, tooltipComponents, tooltipFlag);
    }

    @Override
    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, @NotNull class_1657 player, @NotNull class_1268 hand) {
        if (!level.field_9236) {
            class_238 bb;
            class_243 endPos;
            class_243 eyePos = player.method_33571();
            class_3966 entityHit = class_1675.method_18077((class_1937)level, (class_1297)player, (class_243)eyePos, (class_243)(endPos = eyePos.method_1019(player.method_5720().method_1021(80.0))), (class_238)(bb = new class_238(eyePos, endPos).method_1014(2.0)), e -> !Util.areEntitiesLinked((class_1297)player, e));
            if (entityHit == null) {
                class_3965 blockHit = level.method_17742(new class_3959(eyePos, endPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
                if (blockHit.method_17783() == class_239.class_240.field_1332) {
                    this.spawnNaginatas(player, blockHit.method_17784(), level);
                }
            } else {
                this.spawnNaginatas(player, entityHit.method_17782().method_19538(), level);
            }
            player.method_7357().method_7906((class_1792)this, (int)((double)CompanionsConfig.NAGINATA_COOLDOWN * (1.0 - (double)Util.hasFullSetOn(player, ArmorMaterials.MAGE) * CompanionsConfig.MAGE_SET_COOLDOWN_REDUCTION)));
        }
        return super.method_7836(level, player, hand);
    }

    @Override
    protected void playSound(class_1657 player) {
        player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), CompanionsSounds.SPELL_RELEASE_SPEARS.get(), player.method_5634(), 1.0f, 1.0f);
    }

    private void spawnNaginatas(class_1657 player, class_243 targetPos, class_1937 level) {
        if (player.method_5715()) {
            for (int i = 0; i < 2; ++i) {
                double dx = (new Random().nextDouble() - 0.5) * 20.0;
                double dz = (new Random().nextDouble() - 0.5) * 20.0;
                double x = targetPos.field_1352 + dx;
                double z = targetPos.field_1350 + dz;
                class_243 spawnPos = new class_243(x, 20.0 + targetPos.field_1351 + new Random().nextDouble() * 10.0, z);
                this.spawnNaginata(player, spawnPos, targetPos, level, 3.35);
            }
        } else {
            for (int i = 0; i < 6; ++i) {
                double dx = (new Random().nextDouble() - 0.5) * 30.0;
                double dz = (new Random().nextDouble() - 0.5) * 30.0;
                double x = targetPos.field_1352 + dx;
                double z = targetPos.field_1350 + dz;
                class_243 spawnPos = new class_243(x, 20.0 + targetPos.field_1351 + new Random().nextDouble() * 10.0, z);
                this.spawnNaginata(player, spawnPos, targetPos, level, 1.5 + new Random().nextDouble() * 0.5);
            }
        }
    }

    private void spawnNaginata(class_1657 player, class_243 spawnPos, class_243 targetPos, class_1937 level, double speed) {
        HolinessNaginataProjectile naginata = (HolinessNaginataProjectile)CompanionsEntities.HOLINESS_NAGINATA.method_5883(level);
        if (naginata != null) {
            naginata.method_7432((class_1297)player);
            naginata.method_5814(spawnPos.field_1352, spawnPos.field_1351, spawnPos.field_1350);
            naginata.method_18799(targetPos.method_1020(spawnPos).method_1029().method_1021(speed));
            naginata.refreshOrientation();
            naginata.method_5648(true);
            level.method_8649((class_1297)naginata);
        }
    }
}

