/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xylonity.companions.registry.CompanionsRecipes;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9695;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoulFurnaceRecipe
implements class_1860<class_9695> {
    private final class_1856 input;
    private final int requiredCharges;
    private final int processTime;
    @Nullable
    private final class_1792 resultItem;
    private final int resultCount;
    @Nullable
    private final class_1299<?> resultEntity;
    @Nullable
    private final class_2248 resultBlock;

    public SoulFurnaceRecipe(class_1856 input, int requiredCharges, int processTime, @Nullable class_1792 resultItem, int resultCount, @Nullable class_1299<?> resultEntity, @Nullable class_2248 resultBlock) {
        this.input = input;
        this.requiredCharges = requiredCharges;
        this.processTime = processTime;
        this.resultItem = resultItem;
        this.resultCount = resultCount;
        this.resultEntity = resultEntity;
        this.resultBlock = resultBlock;
    }

    public class_1856 input() {
        return this.input;
    }

    public int requiredCharges() {
        return this.requiredCharges;
    }

    public int processTime() {
        return this.processTime;
    }

    @Nullable
    public class_1792 resultItem() {
        return this.resultItem;
    }

    public int resultCount() {
        return this.resultCount;
    }

    @Nullable
    public class_1299<?> resultEntity() {
        return this.resultEntity;
    }

    @Nullable
    public class_2248 resultBlock() {
        return this.resultBlock;
    }

    public boolean outputsItem() {
        return this.resultItem != null;
    }

    public boolean outputsEntity() {
        return this.resultEntity != null;
    }

    public boolean outputsBlock() {
        return this.resultBlock != null;
    }

    public boolean method_8115(@NotNull class_9695 container, @NotNull class_1937 level) {
        return this.input.method_8093(container.method_59984(0));
    }

    @NotNull
    public class_1799 method_8116(@NotNull class_9695 container, @NotNull class_7225.class_7874 access) {
        class_1792 item = this.resultItem;
        return item != null ? new class_1799((class_1935)item, Math.max(1, this.resultCount)) : class_1799.field_8037;
    }

    public boolean method_8113(int w, int h) {
        return true;
    }

    @NotNull
    public class_1799 method_8110(@NotNull class_7225.class_7874 access) {
        class_1792 item = this.resultItem;
        return item != null ? new class_1799((class_1935)item, Math.max(1, this.resultCount)) : class_1799.field_8037;
    }

    @NotNull
    public class_2371<class_1856> method_8117() {
        return class_2371.method_10212((Object)class_1856.field_9017, (Object[])new class_1856[]{this.input});
    }

    @NotNull
    public class_1865<?> method_8119() {
        return CompanionsRecipes.SOUL_FURNACE_SERIALIZER;
    }

    @NotNull
    public class_3956<?> method_17716() {
        return CompanionsRecipes.SOUL_FURNACE_TYPE;
    }

    public static class Serializer
    implements class_1865<SoulFurnaceRecipe> {
        private static final MapCodec<SoulFurnaceRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1856.field_46095.fieldOf("input").forGetter(SoulFurnaceRecipe::input), (App)Codec.INT.fieldOf("required_charges").orElse((Object)0).forGetter(SoulFurnaceRecipe::requiredCharges), (App)Codec.INT.fieldOf("process_time").orElse((Object)200).forGetter(SoulFurnaceRecipe::processTime), (App)class_7923.field_41178.method_39673().optionalFieldOf("result_item").forGetter(r -> Optional.ofNullable(r.resultItem())), (App)Codec.INT.fieldOf("result_count").orElse((Object)1).forGetter(SoulFurnaceRecipe::resultCount), (App)class_7923.field_41177.method_39673().optionalFieldOf("result_entity").forGetter(r -> Optional.ofNullable(r.resultEntity())), (App)class_7923.field_41175.method_39673().optionalFieldOf("result_block").forGetter(r -> Optional.ofNullable(r.resultBlock()))).apply((Applicative)instance, (in, req, time, itemOpt, cnt, entOpt, blockOpt) -> new SoulFurnaceRecipe((class_1856)in, (int)req, (int)time, itemOpt.orElse(null), Math.max(1, cnt), entOpt.orElse(null), blockOpt.orElse(null)))).validate(r -> Serializer.exactlyOneResult(r) ? DataResult.success((Object)r) : DataResult.error(() -> "soul_furnace must define exactly one of result_item, result_entity, or result_block"));
        private static final class_9139<class_9129, SoulFurnaceRecipe> STREAM_CODEC = class_9139.method_56437((buf, r) -> {
            class_1856.field_48355.encode(buf, (Object)r.input());
            class_9135.field_48550.encode(buf, (Object)r.requiredCharges());
            class_9135.field_48550.encode(buf, (Object)r.processTime());
            if (r.resultItem() != null) {
                buf.method_52997(1);
                class_9135.method_56365((class_5321)class_7924.field_41197).encode(buf, (Object)Objects.requireNonNull(r.resultItem()));
                class_9135.field_48550.encode(buf, (Object)Math.max(1, r.resultCount()));
            } else if (r.resultEntity() != null) {
                buf.method_52997(2);
                class_9135.method_56365((class_5321)class_7924.field_41266).encode(buf, r.resultEntity());
            } else if (r.resultBlock() != null) {
                buf.method_52997(3);
                class_9135.method_56365((class_5321)class_7924.field_41254).encode(buf, (Object)r.resultBlock());
            } else {
                buf.method_52997(0);
            }
        }, buf -> {
            class_1856 in = (class_1856)class_1856.field_48355.decode(buf);
            int req = (Integer)class_9135.field_48550.decode(buf);
            int time = (Integer)class_9135.field_48550.decode(buf);
            byte kind = buf.readByte();
            class_1792 item = null;
            int count = 1;
            class_1299 entity = null;
            class_2248 block = null;
            if (kind == 1) {
                item = (class_1792)class_9135.method_56365((class_5321)class_7924.field_41197).decode(buf);
                count = (Integer)class_9135.field_48550.decode(buf);
                if (item == class_1802.field_8162) {
                    item = null;
                }
            } else if (kind == 2) {
                entity = (class_1299)class_9135.method_56365((class_5321)class_7924.field_41266).decode(buf);
            } else if (kind == 3) {
                block = (class_2248)class_9135.method_56365((class_5321)class_7924.field_41254).decode(buf);
            }
            return new SoulFurnaceRecipe(in, req, time, item, Math.max(1, count), entity, block);
        });

        private static boolean exactlyOneResult(SoulFurnaceRecipe r) {
            int n = (r.resultItem() != null ? 1 : 0) + (r.resultEntity() != null ? 1 : 0) + (r.resultBlock() != null ? 1 : 0);
            return n == 1;
        }

        @NotNull
        public MapCodec<SoulFurnaceRecipe> method_53736() {
            return CODEC;
        }

        @NotNull
        public class_9139<class_9129, SoulFurnaceRecipe> method_56104() {
            return STREAM_CODEC;
        }
    }
}

