/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.tesla;

import dev.xylonity.companions.common.blockentity.AbstractTeslaBlockEntity;
import dev.xylonity.companions.common.blockentity.RecallPlatformBlockEntity;
import dev.xylonity.companions.common.blockentity.VoltaicPillarBlockEntity;
import dev.xylonity.companions.common.blockentity.VoltaicRelayBlockEntity;
import dev.xylonity.companions.config.CompanionsConfig;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class TeslaConnectionManager {
    private static TeslaConnectionManager instance;
    private final Map<ConnectionNode, Set<ConnectionNode>> outgoing = new ConcurrentHashMap<ConnectionNode, Set<ConnectionNode>>();
    private final Map<ConnectionNode, Set<ConnectionNode>> incoming = new ConcurrentHashMap<ConnectionNode, Set<ConnectionNode>>();
    private final Map<ConnectionNode, AbstractTeslaBlockEntity> blockEntities = new ConcurrentHashMap<ConnectionNode, AbstractTeslaBlockEntity>();

    public static TeslaConnectionManager getInstance() {
        if (instance == null) {
            instance = new TeslaConnectionManager();
        }
        return instance;
    }

    public void registerBlockEntity(AbstractTeslaBlockEntity blockEntity) {
        ConnectionNode node = blockEntity.asConnectionNode();
        this.blockEntities.put(node, blockEntity);
        this.recalculateDistances();
        this.refreshRecallCachesAround(node);
    }

    public void unregisterBlockEntity(AbstractTeslaBlockEntity blockEntity) {
        ConnectionNode node = blockEntity.asConnectionNode();
        this.blockEntities.remove(node);
        this.removeConnectionNode(node);
        this.recalculateDistances();
        this.refreshRecallCachesAround(node);
    }

    public void addConnection(ConnectionNode source, ConnectionNode target) {
        this.addConnection(source, target, false);
        this.refreshRecallCachesAround(source, target);
    }

    public void addConnection(ConnectionNode source, ConnectionNode target, boolean bypassValidation) {
        AbstractTeslaBlockEntity be;
        if (!bypassValidation && source.isBlock() && (be = this.blockEntities.get(source)) != null && !be.canConnectToOtherModules()) {
            return;
        }
        this.outgoing.computeIfAbsent(source, c -> ConcurrentHashMap.newKeySet()).add(target);
        this.incoming.computeIfAbsent(target, c -> ConcurrentHashMap.newKeySet()).add(source);
        if (!bypassValidation) {
            this.recalculateDistances();
        }
    }

    @NotNull
    public AbstractTeslaBlockEntity getBlockEntity(ConnectionNode node) {
        return this.blockEntities.get(node);
    }

    public Set<ConnectionNode> getOutgoing(ConnectionNode node) {
        return this.outgoing.getOrDefault(node, Collections.emptySet());
    }

    public Set<ConnectionNode> getIncoming(ConnectionNode node) {
        return this.incoming.getOrDefault(node, Collections.emptySet());
    }

    private void refreshRecallCachesAround(ConnectionNode ... nodes) {
        ConcurrentHashMap.KeySetView visitedComponents = ConcurrentHashMap.newKeySet();
        for (ConnectionNode node : nodes) {
            if (visitedComponents.contains(node)) continue;
            Set<ConnectionNode> component = this.getConnectedComponent(node);
            visitedComponents.addAll(component);
            ArrayList<RecallPlatformBlockEntity> recalls = new ArrayList<RecallPlatformBlockEntity>();
            for (ConnectionNode n : component) {
                AbstractTeslaBlockEntity be = this.blockEntities.get(n);
                if (!(be instanceof RecallPlatformBlockEntity)) continue;
                RecallPlatformBlockEntity rp = (RecallPlatformBlockEntity)be;
                recalls.add(rp);
            }
            if (recalls.size() < 2) {
                for (RecallPlatformBlockEntity rp : recalls) {
                    rp.updatePartners(Collections.emptySet());
                }
                continue;
            }
            List<class_2338> allPos = recalls.stream().map(class_2586::method_11016).toList();
            for (RecallPlatformBlockEntity rp : recalls) {
                HashSet<class_2338> partners = new HashSet<class_2338>(allPos);
                partners.remove(rp.method_11016());
                rp.updatePartners(partners);
            }
        }
    }

    public Set<ConnectionNode> getConnectedComponent(ConnectionNode start) {
        ConcurrentHashMap.KeySetView comp = ConcurrentHashMap.newKeySet();
        ArrayDeque<ConnectionNode> queue = new ArrayDeque<ConnectionNode>();
        comp.add(start);
        queue.add(start);
        while (!queue.isEmpty()) {
            ConnectionNode cur = (ConnectionNode)queue.poll();
            comp.add(cur);
            ConcurrentHashMap.KeySetView neighbors = ConcurrentHashMap.newKeySet();
            neighbors.addAll(this.outgoing.getOrDefault(cur, Collections.emptySet()));
            neighbors.addAll(this.incoming.getOrDefault(cur, Collections.emptySet()));
            for (ConnectionNode node : neighbors) {
                if (!comp.add(node)) continue;
                queue.add(node);
            }
        }
        return comp;
    }

    public void removeConnection(ConnectionNode source, ConnectionNode target) {
        Set<ConnectionNode> inSet;
        Set<ConnectionNode> outSet = this.outgoing.get(source);
        if (outSet != null) {
            outSet.remove(target);
        }
        if ((inSet = this.incoming.get(target)) != null) {
            inSet.remove(source);
        }
        this.recalculateDistances();
        this.refreshRecallCachesAround(source, target);
    }

    public void removeConnectionNode(ConnectionNode node) {
        this.outgoing.remove(node);
        this.incoming.remove(node);
        for (Set<ConnectionNode> set : this.outgoing.values()) {
            set.remove(node);
        }
        for (Set<ConnectionNode> set : this.incoming.values()) {
            set.remove(node);
        }
    }

    public void recalculateDistances() {
        for (AbstractTeslaBlockEntity be : this.blockEntities.values()) {
            be.setDistance(Integer.MAX_VALUE);
        }
        Set<ConnectionNode> allNodes = this.getAllNodes();
        ConcurrentHashMap.KeySetView visited = ConcurrentHashMap.newKeySet();
        for (ConnectionNode start : allNodes) {
            AbstractTeslaBlockEntity be;
            if (!visited.add(start)) continue;
            LinkedList<ConnectionNode> queue = new LinkedList<ConnectionNode>();
            ConcurrentHashMap.KeySetView component = ConcurrentHashMap.newKeySet();
            queue.add(start);
            component.add(start);
            while (!queue.isEmpty()) {
                ConnectionNode cur = (ConnectionNode)queue.poll();
                for (ConnectionNode nb : this.outgoing.getOrDefault(cur, Collections.emptySet())) {
                    if (!component.add(nb)) continue;
                    queue.add(nb);
                }
                for (ConnectionNode nb : this.incoming.getOrDefault(cur, Collections.emptySet())) {
                    if (!component.add(nb)) continue;
                    queue.add(nb);
                }
            }
            visited.addAll(component);
            List<ConnectionNode> seeds = component.stream().filter(ConnectionNode::isEntity).toList();
            if (seeds.isEmpty()) continue;
            ConcurrentHashMap<ConnectionNode, Integer> distances = new ConcurrentHashMap<ConnectionNode, Integer>();
            LinkedList<ConnectionNode> bfsQueue = new LinkedList<ConnectionNode>(seeds);
            seeds.forEach(n -> distances.put((ConnectionNode)n, 0));
            while (!bfsQueue.isEmpty()) {
                ConnectionNode cur = (ConnectionNode)bfsQueue.poll();
                int currentDistance = (Integer)distances.get(cur);
                AbstractTeslaBlockEntity currentBe = this.blockEntities.get(cur);
                for (ConnectionNode nb : this.outgoing.getOrDefault(cur, Collections.emptySet())) {
                    boolean flag;
                    if (!nb.isBlock()) continue;
                    AbstractTeslaBlockEntity childBe = this.blockEntities.get(nb);
                    boolean bl = flag = currentBe instanceof VoltaicPillarBlockEntity && childBe instanceof VoltaicPillarBlockEntity && currentBe.method_11016().method_10263() == childBe.method_11016().method_10263() && currentBe.method_11016().method_10260() == childBe.method_11016().method_10260();
                    int newDistance = currentBe instanceof VoltaicRelayBlockEntity ? 1 : (flag ? currentDistance : currentDistance + 1);
                    if (newDistance > CompanionsConfig.DINAMO_MAX_CHAIN_CONNECTIONS || distances.containsKey(nb) && newDistance >= (Integer)distances.get(nb)) continue;
                    distances.put(nb, newDistance);
                    bfsQueue.add(nb);
                }
            }
            for (Map.Entry e : distances.entrySet()) {
                be = this.blockEntities.get(e.getKey());
                if (be == null) continue;
                be.setDistance((Integer)e.getValue());
            }
            for (ConnectionNode node : component) {
                if (node.isEntity() || distances.containsKey(node)) continue;
                this.removeConnectionNode(node);
                be = this.blockEntities.get(node);
                if (be == null) continue;
                be.setDistance(0);
            }
        }
    }

    private Set<ConnectionNode> getAllNodes() {
        ConcurrentHashMap.KeySetView nodes = ConcurrentHashMap.newKeySet();
        nodes.addAll(this.outgoing.keySet());
        nodes.addAll(this.incoming.keySet());
        for (Set<ConnectionNode> set : this.outgoing.values()) {
            nodes.addAll(set);
        }
        for (Set<ConnectionNode> set : this.incoming.values()) {
            nodes.addAll(set);
        }
        return nodes;
    }

    public record ConnectionNode(UUID entityId, class_2338 blockPos, class_2960 dimension) {
        public static ConnectionNode forEntity(UUID entityId, class_2960 dimension) {
            return new ConnectionNode(entityId, null, dimension);
        }

        public static ConnectionNode forBlock(class_2338 pos, class_2960 dimension) {
            return new ConnectionNode(null, pos, dimension);
        }

        public class_2487 serialize() {
            class_2487 tag = new class_2487();
            if (this.isEntity()) {
                tag.method_10582("Type", "entity");
                tag.method_25927("UUID", this.entityId);
            } else {
                tag.method_10582("Type", "block");
                tag.method_10569("X", this.blockPos.method_10263());
                tag.method_10569("Y", this.blockPos.method_10264());
                tag.method_10569("Z", this.blockPos.method_10260());
            }
            tag.method_10582("Dimension", this.dimension.toString());
            return tag;
        }

        public static ConnectionNode deserialize(class_2487 tag) {
            class_2960 dimension = class_2960.method_60654((String)tag.method_10558("Dimension"));
            if (tag.method_10558("Type").equals("entity")) {
                return ConnectionNode.forEntity(tag.method_25926("UUID"), dimension);
            }
            class_2338 pos = new class_2338(tag.method_10550("X"), tag.method_10550("Y"), tag.method_10550("Z"));
            return ConnectionNode.forBlock(pos, dimension);
        }

        public boolean isEntity() {
            return this.entityId != null;
        }

        public boolean isBlock() {
            return this.blockPos != null;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectionNode that = (ConnectionNode)o;
            return Objects.equals(this.entityId, that.entityId) && Objects.equals(this.blockPos, that.blockPos) && Objects.equals(this.dimension, that.dimension);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.entityId, this.blockPos, this.dimension);
        }
    }
}

