/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.tesla.behaviour.dinamo;

import dev.xylonity.companions.common.entity.companion.DinamoEntity;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.common.util.interfaces.ITeslaGeneratorBehaviour;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsEffects;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_2394;

public class DinamoAttackBehaviour
implements ITeslaGeneratorBehaviour {
    @Override
    public void tick(DinamoEntity dinamo) {
        if (dinamo.getAttackCycleCounter() == 0) {
            this.searchForTargets(dinamo);
        }
        if (dinamo.getAttackCycleCounter() < 8) {
            dinamo.setAnimationStartTick(dinamo.getAttackCycleCounter());
            dinamo.setActiveForAttack(true);
        } else if (dinamo.getAttackCycleCounter() == 8) {
            dinamo.setActiveForAttack(false);
            dinamo.setAnimationStartTick(0);
        }
        if (dinamo.isActiveForAttack() && !dinamo.entitiesToAttack.isEmpty()) {
            if (dinamo.method_37908().method_8608()) {
                double radius = 0.42;
                double initialY = dinamo.method_19538().field_1351 + (double)dinamo.method_17682() - 0.6;
                for (int i = 0; i < 360; i += 120) {
                    double angleRadians = Math.toRadians(i);
                    double particleX = dinamo.method_19538().field_1352 + radius * Math.cos(angleRadians);
                    double particleZ = dinamo.method_19538().field_1350 + radius * Math.sin(angleRadians);
                    dinamo.method_37908().method_8406((class_2394)CompanionsParticles.DINAMO_SPARK.get(), particleX, initialY, particleZ, 0.0, 0.35, 0.0);
                }
            }
            if (dinamo.getAttackCycleCounter() == 3) {
                for (class_1309 target : dinamo.entitiesToAttack) {
                    if (!(target.method_5858((class_1297)target) <= 64.0)) continue;
                    target.method_5643(dinamo.method_48923().method_48809(), (float)CompanionsConfig.ELECTRICITY_DAMAGE);
                    if (!(target.method_59922().method_43057() < 0.4f)) continue;
                    target.method_6092(new class_1293(CompanionsEffects.ELECTROSHOCK, 50, 0, false, true, true));
                }
            }
            if (dinamo.getAttackCycleCounter() == 0) {
                dinamo.method_5783(CompanionsSounds.DINAMO_ATTACK.get(), 0.45f, 1.0f);
            }
        }
        if (dinamo.getAttackCycleCounter() >= 60) {
            dinamo.setAttackCycleCounter(0);
            dinamo.entitiesToAttack.clear();
            dinamo.setTargetIds("");
            return;
        }
        dinamo.setAttackCycleCounter(dinamo.getAttackCycleCounter() + 1);
    }

    private void searchForTargets(DinamoEntity dinamo) {
        List list = dinamo.method_37908().method_8390(class_1309.class, dinamo.method_5829().method_1014(10.0), e -> {
            if (Util.areEntitiesLinked((class_1297)e, (class_1297)dinamo)) {
                return false;
            }
            return e instanceof class_1588;
        }).stream().filter(arg_0 -> ((DinamoEntity)dinamo).method_6057(arg_0)).collect(Collectors.toCollection(ArrayList::new));
        for (class_1309 m : list) {
            if (dinamo.entitiesToAttack.contains(m)) continue;
            dinamo.entitiesToAttack.add(m);
            dinamo.setTargetIds(dinamo.getTargetIds() + m.method_5628() + ";");
        }
        if (dinamo.method_5968() != null) {
            dinamo.entitiesToAttack.add(dinamo.method_5968());
            dinamo.setTargetIds(dinamo.getTargetIds() + dinamo.method_5968().method_5628() + ";");
        }
    }
}

