/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.util;

import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.CompanionSummonEntity;
import dev.xylonity.companions.mixin.CompanionsLevelAccessor;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_6025;
import net.minecraft.class_6880;

public class Util {
    private Util() {
    }

    public static class_2338 findClosestGroundBelow(CompanionEntity entity, float y) {
        class_243 start = new class_243(entity.method_23317(), entity.method_5829().field_1322 + 0.01, entity.method_23321());
        class_3965 trace = entity.method_37908().method_17742(new class_3959(start, start.method_1023(0.0, (double)y, 0.0), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)entity));
        if (trace.method_17783() == class_239.class_240.field_1332) {
            return trace.method_17777();
        }
        return null;
    }

    public static float normalizeDeg(float deg) {
        return (deg %= 360.0f) < 0.0f ? deg + 360.0f : deg;
    }

    public static float degToRad(float deg) {
        return (float)Math.toRadians(deg);
    }

    public static float smoothStep(float t) {
        return t * t * (3.0f - 2.0f * t);
    }

    public static class_243 bezier(class_243 a, class_243 b, class_243 c, double t) {
        double u = 1.0 - t;
        double tt = t * t;
        double uu = u * u;
        return new class_243(uu * a.field_1352 + 2.0 * u * t * b.field_1352 + tt * c.field_1352, uu * a.field_1351 + 2.0 * u * t * b.field_1351 + tt * c.field_1351, uu * a.field_1350 + 2.0 * u * t * b.field_1350 + tt * c.field_1350);
    }

    public static double estimateLengthBezier(class_243 a, class_243 b, class_243 c) {
        double len = 0.0;
        class_243 prev = a;
        for (int i = 1; i <= 24; ++i) {
            double t = (double)i / 24.0;
            class_243 cur = Util.bezier(a, b, c, t);
            len += cur.method_1022(prev);
            prev = cur;
        }
        return len;
    }

    public static class_243 rotateHorizontalDirection(class_243 direction, double degrees) {
        double rad = Math.toRadians(degrees);
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        return new class_243(direction.field_1352 * cos - direction.field_1350 * sin, direction.field_1351, direction.field_1352 * sin + direction.field_1350 * cos);
    }

    public static class_2338 findValidSpawnPos(class_2338 pos, class_1937 level) {
        if (Util.isValidSpawnPos(pos, level)) {
            return pos;
        }
        for (int d = 1; d <= 6; ++d) {
            class_2338 below = pos.method_10087(d);
            if (!Util.isValidSpawnPos(below, level)) continue;
            return below;
        }
        for (int u = 1; u <= 3; ++u) {
            class_2338 above = pos.method_10086(u);
            if (!Util.isValidSpawnPos(above, level)) continue;
            return above;
        }
        return pos;
    }

    private static boolean isValidSpawnPos(class_2338 pos, class_1937 level) {
        return level.method_24794(pos) && level.method_8320(pos).method_26215() && level.method_8320(pos.method_10074()).method_26206((class_1922)level, pos.method_10074(), class_2350.field_11036);
    }

    public static boolean areEntitiesLinked(class_1297 e1, class_1297 e2) {
        if (e1 == null || e2 == null) {
            return false;
        }
        if (e1 == e2) {
            return true;
        }
        Set<UUID> ownersA = Util.collectOwners(e1, new HashSet<UUID>(), new HashSet<UUID>());
        Set<UUID> ownersB = Util.collectOwners(e2, new HashSet<UUID>(), new HashSet<UUID>());
        ownersA.retainAll(ownersB);
        return !ownersA.isEmpty();
    }

    private static Set<UUID> collectOwners(class_1297 current, Set<UUID> result, Set<UUID> visited) {
        class_6025 owE;
        UUID ownerUuid;
        if (current == null) {
            return result;
        }
        if (!visited.add(current.method_5667())) {
            return result;
        }
        result.add(current.method_5667());
        if (current instanceof class_1321) {
            CompanionSummonEntity summon;
            UUID secondUuid;
            class_1321 tamable = (class_1321)current;
            ownerUuid = tamable.method_6139();
            if (ownerUuid != null) {
                result.add(ownerUuid);
            }
            if (current instanceof CompanionSummonEntity && (secondUuid = (summon = (CompanionSummonEntity)current).getSecondOwnerUUID()) != null) {
                result.add(secondUuid);
            }
            Util.collectOwners((class_1297)tamable.method_35057(), result, visited);
        }
        if (current instanceof class_1676) {
            class_1676 projectile = (class_1676)current;
            Util.collectOwners(projectile.method_24921(), result, visited);
        }
        if (current instanceof class_6025 && (ownerUuid = (owE = (class_6025)current).method_6139()) != null) {
            class_1937 class_19372;
            result.add(ownerUuid);
            class_1657 owner = current.method_37908().method_18470(ownerUuid);
            if (owner == null && (class_19372 = current.method_37908()) instanceof CompanionsLevelAccessor) {
                CompanionsLevelAccessor acc = (CompanionsLevelAccessor)class_19372;
                owner = (class_1297)acc.companions$getEntities().method_31808(ownerUuid);
            }
            Util.collectOwners((class_1297)owner, result, visited);
        }
        return result;
    }

    public static class_243 randomVectorInCone(class_243 base, double maxAngleDegrees, Random random) {
        class_243 baseNorm = base.method_1029();
        class_243 u = baseNorm.method_1036(new class_243(0.0, 1.0, 0.0));
        if (u.method_1027() < 1.0E-6) {
            u = baseNorm.method_1036(new class_243(1.0, 0.0, 0.0));
        }
        u = u.method_1029();
        class_243 v = baseNorm.method_1036(u).method_1029();
        double minCos = Math.cos(Math.toRadians(maxAngleDegrees));
        double cos = minCos + random.nextDouble() * (1.0 - minCos);
        double sin = Math.sqrt(1.0 - cos * cos);
        double phi = random.nextDouble() * 2.0 * Math.PI;
        return baseNorm.method_1021(cos).method_1019(u.method_1021(sin * Math.cos(phi))).method_1019(v.method_1021(sin * Math.sin(phi))).method_1021(base.method_1033());
    }

    public static int hasFullSetOn(class_1657 player, class_6880<class_1741> material) {
        int amount = 0;
        for (class_1799 armorStack : player.method_31548().field_7548) {
            class_1738 armorItem;
            class_1792 class_17922;
            if (armorStack.method_7960() || !((class_17922 = armorStack.method_7909()) instanceof class_1738) || (armorItem = (class_1738)class_17922).method_7686() != material) continue;
            ++amount;
        }
        return amount;
    }

    public static class_2499 floatsToList(float[] arr) {
        class_2499 list = new class_2499();
        for (float v : arr) {
            list.add((Object)class_2494.method_23244((float)v));
        }
        return list;
    }

    public static class_2499 intsToList(int[] arr) {
        class_2499 list = new class_2499();
        for (int v : arr) {
            list.add((Object)class_2497.method_23247((int)v));
        }
        return list;
    }

    public static void listToFloats(class_2499 list, float[] o) {
        for (int i = 0; i < o.length && i < list.size(); ++i) {
            o[i] = ((class_2494)list.method_10534(i)).method_10700();
        }
    }

    public static void listToInts(class_2499 list, int[] o) {
        for (int i = 0; i < o.length && i < list.size(); ++i) {
            o[i] = ((class_2497)list.method_10534(i)).method_10701();
        }
    }
}

