/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.compat.jei.category;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.xylonity.companions.common.blockentity.ShadeSwordAltarBlockEntity;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.companion.ShadeSwordEntity;
import dev.xylonity.companions.common.recipe.ShadeSwordAltarRecipe;
import dev.xylonity.companions.registry.CompanionsBlocks;
import dev.xylonity.companions.registry.CompanionsEntities;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Vector3f;
import software.bernie.geckolib.renderer.GeoBlockRenderer;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public final class ShadeSwordAltarRecipeCategory
implements IRecipeCategory<ShadeSwordAltarRecipe> {
    public static final class_2960 UID = class_2960.method_60655((String)"companions", (String)"shade_sword_altar_interaction");
    public static final RecipeType<ShadeSwordAltarRecipe> TYPE = new RecipeType(UID, ShadeSwordAltarRecipe.class);
    public static final class_2960 SHADOW = class_2960.method_60655((String)"companions", (String)"textures/gui/sprites.png");
    private final IDrawable icon;
    private ShadeSwordAltarBlockEntity cachedBlockEntity;
    private ShadeSwordEntity cachedEntity;
    private long lastUpdateTime = 0L;
    private double animationTicks = 0.0;
    private long lastSystemTimeMs = 0L;

    public ShadeSwordAltarRecipeCategory(IGuiHelper gui) {
        this.icon = gui.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)CompanionsBlocks.SHADE_SWORD_ALTAR.get()));
    }

    @NotNull
    public RecipeType<ShadeSwordAltarRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public class_2561 getTitle() {
        return class_2561.method_43471((String)"jei.companions.shade_sword_altar_interaction.title");
    }

    public int getHeight() {
        return 80;
    }

    public int getWidth() {
        return 160;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ShadeSwordAltarRecipe rec, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 5).addItemStack(rec.input);
    }

    private ShadeSwordAltarBlockEntity getOrCreateBlockEntity() {
        if (this.cachedBlockEntity == null) {
            this.cachedBlockEntity = new ShadeSwordAltarBlockEntity(class_2338.field_10980, CompanionsBlocks.SHADE_SWORD_ALTAR.get().method_9564());
            this.cachedBlockEntity.addCharge();
        }
        return this.cachedBlockEntity;
    }

    private ShadeSwordEntity getOrCreateEntity() {
        if (this.cachedEntity == null) {
            this.cachedEntity = new ShadeSwordEntity((class_1299<? extends CompanionEntity>)CompanionsEntities.SHADE_SWORD, (class_1937)class_310.method_1551().field_1687);
            this.cachedEntity.setIsSpawning(false);
            this.cachedEntity.method_5977(true);
        }
        return this.cachedEntity;
    }

    private void updateAnimation() {
        long currentTime = System.currentTimeMillis();
        if (this.lastUpdateTime == 0L) {
            this.lastUpdateTime = currentTime;
        }
        if (currentTime - this.lastUpdateTime >= 50L) {
            this.lastUpdateTime = currentTime;
        }
        if (this.cachedEntity != null) {
            this.cachedEntity.field_6012 = (int)(System.currentTimeMillis() / 50L);
        }
    }

    private void updateAnimationTicks() {
        long now = System.currentTimeMillis();
        if (this.lastSystemTimeMs == 0L) {
            this.lastSystemTimeMs = now;
            return;
        }
        long ms = now - this.lastSystemTimeMs;
        this.lastSystemTimeMs = now;
        this.animationTicks += (double)ms / 50.0;
    }

    public void draw(@NotNull ShadeSwordAltarRecipe recipe, @NotNull IRecipeSlotsView slots, @NotNull class_332 guiGraphics, double mouseX, double mouseY) {
        RenderSystem.setShaderTexture((int)0, (class_2960)SHADOW);
        guiGraphics.method_25302(SHADOW, 20, 58, 5, 28, 35, 9);
        guiGraphics.method_25302(SHADOW, 32, 10, 46, 3, 33, 22);
        guiGraphics.method_25302(SHADOW, 80, 45, 142, 6, 24, 12);
        guiGraphics.method_25302(SHADOW, 9, 4, 120, 0, 19, 19);
        guiGraphics.method_25302(SHADOW, 9, 4, 120, 0, 19, 19);
        guiGraphics.method_25302(SHADOW, 115, 55, 216, 5, 38, 16);
        this.updateAnimation();
        this.updateAnimationTicks();
        ShadeSwordAltarBlockEntity be = this.getOrCreateBlockEntity();
        ShadeSwordEntity sword = this.getOrCreateEntity();
        GeoBlockRenderer renderer = (GeoBlockRenderer)class_310.method_1551().method_31975().method_3550((class_2586)be);
        GeoEntityRenderer swordRenderer = (GeoEntityRenderer)class_310.method_1551().method_1561().method_3953((class_1297)sword);
        if (renderer == null) {
            return;
        }
        class_4587 pose = guiGraphics.method_51448();
        class_4597.class_4598 buffer = guiGraphics.method_51450();
        pose.method_22903();
        pose.method_46416(42.0f, 65.0f, 20.0f);
        pose.method_22905(20.0f, 20.0f, 20.0f);
        pose.method_22907(class_7833.field_40714.rotationDegrees(-25.0f));
        pose.method_22907(class_7833.field_40716.rotationDegrees(135.0f));
        pose.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        Matrix3f normalMat = pose.method_23760().method_23762();
        Vector3f up = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f front = new Vector3f(0.0f, 1.0f, 0.0f);
        normalMat.transform(up).normalize();
        normalMat.transform(front).normalize();
        RenderSystem.setupGui3DDiffuseLighting((Vector3f)up, (Vector3f)front);
        try {
            float partialTicks = (float)((double)(System.currentTimeMillis() - this.lastUpdateTime) / 50.0);
            renderer.method_3569((class_2586)be, partialTicks, pose, (class_4597)buffer, class_765.method_23687((int)15, (int)15), class_4608.field_21444);
        }
        catch (Exception e) {
            renderer.method_3569((class_2586)be, class_310.method_1551().method_60646().method_60636(), pose, (class_4597)buffer, class_765.method_23687((int)15, (int)15), class_4608.field_21444);
        }
        pose.method_22909();
        pose.method_22903();
        pose.method_46416(135.0f, 62.0f, 20.0f);
        pose.method_22905(16.0f, 16.0f, 16.0f);
        pose.method_22907(class_7833.field_40714.rotationDegrees(-25.0f));
        pose.method_22907(class_7833.field_40716.rotationDegrees(45.0f));
        pose.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        Matrix3f normalMat2 = pose.method_23760().method_23762();
        Vector3f up2 = new Vector3f(-1.0f, 100.0f, -1.0f);
        Vector3f front2 = new Vector3f(-1.0f, 300.0f, -1.0f);
        normalMat2.transform(up2).normalize();
        normalMat2.transform(front2).normalize();
        RenderSystem.setupGui3DDiffuseLighting((Vector3f)up2, (Vector3f)front2);
        try {
            swordRenderer.method_3936((class_1297)sword, 0.0f, class_310.method_1551().method_60646().method_60636(), pose, (class_4597)buffer, class_765.method_23687((int)15, (int)15));
        }
        catch (Exception e) {
            swordRenderer.method_3936((class_1297)sword, 0.0f, class_310.method_1551().method_60646().method_60636(), pose, (class_4597)buffer, class_765.method_23687((int)15, (int)15));
        }
        pose.method_22909();
        buffer.method_22993();
    }
}

