/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class SpawnConfig {
    public final List<class_2960> biomes;
    public final List<class_6862<class_1959>> biomeTags;
    public final int weight;
    public final int minCount;
    public final int maxCount;

    private SpawnConfig(int weight, int minCount, int maxCount, List<class_2960> biomes, List<class_6862<class_1959>> biomeTags) {
        this.weight = weight;
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.biomes = biomes;
        this.biomeTags = biomeTags;
    }

    public static SpawnConfig parse(String cfgLine) {
        String[] parts = cfgLine.split("\\s*,\\s*");
        int weight = Integer.parseInt(parts[0]);
        int min = Integer.parseInt(parts[1]);
        int max = Integer.parseInt(parts[2]);
        ArrayList<class_2960> biomeList = new ArrayList<class_2960>();
        ArrayList<class_6862<class_1959>> tagList = new ArrayList<class_6862<class_1959>>();
        for (int i = 3; i < parts.length; ++i) {
            String part = parts[i];
            if (part.startsWith("#")) {
                class_2960 tagId = class_2960.method_60654((String)part.substring(1));
                tagList.add((class_6862<class_1959>)class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)tagId));
                continue;
            }
            biomeList.add(class_2960.method_60654((String)part));
        }
        return new SpawnConfig(weight, min, max, biomeList, tagList);
    }

    public boolean matches(class_6880<class_1959> biomeHolder) {
        class_2960 biomeName = SpawnConfig.getBiomeName(biomeHolder);
        if (biomeName == null) {
            return false;
        }
        if (this.biomes.contains(biomeName)) {
            return true;
        }
        for (class_6862<class_1959> tag : this.biomeTags) {
            if (!biomeHolder.method_40220(tag)) continue;
            return true;
        }
        return false;
    }

    private static class_2960 getBiomeName(class_6880<class_1959> biomeHolder) {
        return (class_2960)biomeHolder.method_40229().map(class_5321::method_29177, noKey -> null);
    }
}

