/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.platform;

import dev.xylonity.companions.common.block.CoinBlock;
import dev.xylonity.companions.common.block.CroissantEggBlock;
import dev.xylonity.companions.common.block.EmptyPuppetBlock;
import dev.xylonity.companions.common.block.EternalFireBlock;
import dev.xylonity.companions.common.block.FrogBonanzaBlock;
import dev.xylonity.companions.common.block.PlasmaLampBlock;
import dev.xylonity.companions.common.block.RecallPlatformBlock;
import dev.xylonity.companions.common.block.RespawnTotemBlock;
import dev.xylonity.companions.common.block.ShadeMawAltarBlock;
import dev.xylonity.companions.common.block.ShadeSwordAltarBlock;
import dev.xylonity.companions.common.block.SoulFurnaceBlock;
import dev.xylonity.companions.common.block.TeslaCoilBlock;
import dev.xylonity.companions.common.block.VoltaicPillarBlock;
import dev.xylonity.companions.common.block.VoltaicRelayBlock;
import dev.xylonity.companions.common.item.CrystallizedBloodItem;
import dev.xylonity.companions.common.item.HourglassItem;
import dev.xylonity.companions.common.item.NeedleItem;
import dev.xylonity.companions.common.item.ShadowBellItem;
import dev.xylonity.companions.common.item.WrenchItem;
import dev.xylonity.companions.common.item.armor.BloodArmorItem;
import dev.xylonity.companions.common.item.armor.GeckoBloodArmorItem;
import dev.xylonity.companions.common.item.armor.GeckoHolyRobeArmorItem;
import dev.xylonity.companions.common.item.armor.GeckoMageArmorItem;
import dev.xylonity.companions.common.item.blockitem.CoinItem;
import dev.xylonity.companions.common.item.blockitem.GenericBlockItem;
import dev.xylonity.companions.common.item.book.books.BlackHoleBook;
import dev.xylonity.companions.common.item.book.books.BraceBook;
import dev.xylonity.companions.common.item.book.books.FireMarkBook;
import dev.xylonity.companions.common.item.book.books.HealRingBook;
import dev.xylonity.companions.common.item.book.books.IceShardBook;
import dev.xylonity.companions.common.item.book.books.IceTornadoBook;
import dev.xylonity.companions.common.item.book.books.MagicRayBook;
import dev.xylonity.companions.common.item.book.books.NaginataBook;
import dev.xylonity.companions.common.item.book.books.StoneSpikesBook;
import dev.xylonity.companions.common.item.generic.GenericGeckoItem;
import dev.xylonity.companions.common.item.weapon.BloodAxeItem;
import dev.xylonity.companions.common.item.weapon.BloodScytheItem;
import dev.xylonity.companions.common.item.weapon.BloodSwordItem;
import dev.xylonity.companions.common.material.ArmorMaterials;
import dev.xylonity.companions.common.material.ItemMaterials;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.platform.CompanionsPlatform;
import dev.xylonity.companions.registry.CompanionsBlocks;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsItems;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1743;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1810;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2396;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3763;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class CompanionsFabricPlatform
implements CompanionsPlatform {
    @Override
    public <T extends class_1792> Supplier<T> registerItem(String id, Supplier<T> item) {
        return CompanionsFabricPlatform.registerSupplier(class_7923.field_41178, id, item);
    }

    @Override
    public <T extends class_1792> Supplier<T> registerSpecificItem(String id, class_1792.class_1793 properties, CompanionsItems.ItemType itemType) {
        switch (itemType) {
            case HOURGLASS: {
                return this.registerItem(id, () -> new HourglassItem(properties));
            }
            case WRENCH: {
                return this.registerItem(id, () -> new WrenchItem(properties));
            }
            case CRYSTALLIZED_BLOOD: {
                return this.registerItem(id, () -> new CrystallizedBloodItem(properties));
            }
            case NEEDLE: {
                return this.registerItem(id, () -> new NeedleItem(properties));
            }
            case GENERIC: {
                return this.registerItem(id, () -> new GenericGeckoItem(properties, id));
            }
        }
        return this.registerItem(id, () -> new ShadowBellItem(properties));
    }

    @Override
    public <T extends class_1792> Supplier<T> registerMusicDisc(String id, int signal, Supplier<class_3414> soundEvent, class_1792.class_1793 properties, int length) {
        return this.registerItem(id, () -> new class_1792(properties.method_60745(class_5321.method_29179((class_5321)class_7924.field_52176, (class_2960)class_2960.method_60655((String)"companions", (String)"saint_klimt")))));
    }

    @Override
    public <T extends class_1792> Supplier<T> registerSpecificItem(String id, class_1792.class_1793 properties, CompanionsItems.ItemType itemType, ItemMaterials material, float extraDamage, float extraSpeed) {
        switch (itemType) {
            case BLOOD_SWORD: {
                return this.registerItem(id, () -> new BloodSwordItem(properties.method_24359().method_57348(class_1829.method_57394((class_1832)material, (int)((int)this.extra(8, extraDamage)), (float)this.extra(11, extraSpeed))), id, material));
            }
            case BLOOD_AXE: {
                return this.registerItem(id, () -> new BloodAxeItem(properties.method_24359().method_57348(class_1743.method_57346((class_1832)material, (float)this.extra(6, extraDamage), (float)this.extra(9, extraSpeed))), id, material));
            }
            case BLOOD_PICKAXE: {
                return this.registerItem(id, () -> new BloodScytheItem(properties.method_24359().method_57348(class_1810.method_57346((class_1832)material, (float)this.extra(7, extraDamage), (float)this.extra(10, extraSpeed))), id, material));
            }
        }
        return this.registerSpecificItem(id, properties, itemType);
    }

    private float extra(int idx, float fallback) {
        String[] parts = CompanionsConfig.CRYSTALLIZED_BLOOD_WEAPON_STATS.trim().split("\\s*,\\s*");
        float ret = fallback;
        if (parts.length >= idx) {
            ret = Float.parseFloat(parts[idx - 1]);
        }
        return ret;
    }

    @Override
    public <T extends class_2248> Supplier<T> registerBlock(String id, class_4970.class_2251 properties, CompanionsBlocks.BlockType blockType, CompanionsBlocks.BlockItem blockItem) {
        Supplier<Object> tr = switch (blockType) {
            case CompanionsBlocks.BlockType.COIN_BLOCK -> CompanionsFabricPlatform.registerSupplier(class_7923.field_41175, id, () -> new CoinBlock(properties));
            case CompanionsBlocks.BlockType.SOUL_FURNACE -> CompanionsFabricPlatform.registerSupplier(class_7923.field_41175, id, () -> new SoulFurnaceBlock(properties.method_9631(v -> (Boolean)v.method_11654((class_2769)SoulFurnaceBlock.LIT) != false ? 13 : 0)));
            case CompanionsBlocks.BlockType.CROISSANT_EGG -> CompanionsFabricPlatform.registerSupplier(class_7923.field_41175, id, () -> new CroissantEggBlock(properties));
            case CompanionsBlocks.BlockType.PLASMA_LAMP -> CompanionsFabricPlatform.registerSupplier(class_7923.field_41175, id, () -> new PlasmaLampBlock(properties.method_9631(v -> (Boolean)v.method_11654((class_2769)PlasmaLampBlock.LIT) != false ? 15 : 0)));
            case CompanionsBlocks.BlockType.VOLTAIC_PILLAR -> CompanionsFabricPlatform.registerSupplier(class_7923.field_41175, id, () -> new VoltaicPillarBlock(properties));
            case CompanionsBlocks.BlockType.EMPTY_PUPPET -> CompanionsFabricPlatform.registerSupplier(class_7923.field_41175, id, () -> new EmptyPuppetBlock(properties));
            case CompanionsBlocks.BlockType.RESPAWN_TOTEM -> CompanionsFabricPlatform.registerSupplier(class_7923.field_41175, id, () -> new RespawnTotemBlock(properties.method_9631(v -> (Boolean)v.method_11654((class_2769)RespawnTotemBlock.LIT) != false ? 13 : 0)));
            case CompanionsBlocks.BlockType.SHADE_SWORD_ALTAR -> CompanionsFabricPlatform.registerSupplier(class_7923.field_41175, id, () -> new ShadeSwordAltarBlock(properties));
            case CompanionsBlocks.BlockType.SHADE_MAW_ALTAR -> CompanionsFabricPlatform.registerSupplier(class_7923.field_41175, id, () -> new ShadeMawAltarBlock(properties));
            case CompanionsBlocks.BlockType.RECALL_PLATFORM -> CompanionsFabricPlatform.registerSupplier(class_7923.field_41175, id, () -> new RecallPlatformBlock(properties));
            case CompanionsBlocks.BlockType.VOLTAIC_RELAY -> CompanionsFabricPlatform.registerSupplier(class_7923.field_41175, id, () -> new VoltaicRelayBlock(properties));
            case CompanionsBlocks.BlockType.FROG_BONANZA -> CompanionsFabricPlatform.registerSupplier(class_7923.field_41175, id, () -> new FrogBonanzaBlock(properties));
            case CompanionsBlocks.BlockType.ETERNAL_FIRE -> CompanionsFabricPlatform.registerSupplier(class_7923.field_41175, id, () -> new EternalFireBlock(properties));
            default -> CompanionsFabricPlatform.registerSupplier(class_7923.field_41175, id, () -> new TeslaCoilBlock(properties));
        };
        Supplier<class_1792> item = switch (blockItem) {
            case CompanionsBlocks.BlockItem.COIN -> () -> new CoinItem((class_2248)tr.get(), new class_1792.class_1793(), id);
            default -> () -> new GenericBlockItem((class_2248)tr.get(), new class_1792.class_1793(), id);
        };
        this.registerItem(id, item);
        return tr;
    }

    @Override
    public <T extends class_1792> Supplier<T> registerArmorItem(String id, class_6880<class_1741> armorMaterial, class_1738.class_8051 armorType, boolean isGeckoArmor) {
        if (isGeckoArmor) {
            if (armorMaterial == ArmorMaterials.CRYSTALLIZED_BLOOD) {
                return this.registerItem(id, () -> new GeckoBloodArmorItem(armorMaterial, armorType, new class_1792.class_1793().method_7895(this.getDurabilityMultiplier(CompanionsConfig.CRYSTALLIZED_BLOOD_SET_STATS)), id));
            }
            if (armorMaterial == ArmorMaterials.MAGE) {
                return this.registerItem(id, () -> new GeckoMageArmorItem(armorMaterial, armorType, new class_1792.class_1793().method_7895(this.getDurabilityMultiplier(CompanionsConfig.MAGE_SET_STATS)), id));
            }
            return this.registerItem(id, () -> new GeckoHolyRobeArmorItem(armorMaterial, armorType, new class_1792.class_1793().method_7895(this.getDurabilityMultiplier(CompanionsConfig.HOLY_ROBE_SET_STATS)), id));
        }
        if (armorMaterial == ArmorMaterials.CRYSTALLIZED_BLOOD) {
            return this.registerItem(id, () -> new BloodArmorItem(armorMaterial, armorType, new class_1792.class_1793().method_7895(this.getDurabilityMultiplier(CompanionsConfig.CRYSTALLIZED_BLOOD_SET_STATS))));
        }
        return this.registerItem(id, () -> new class_1738(armorMaterial, armorType, new class_1792.class_1793().method_7895(35)));
    }

    private int getDurabilityMultiplier(String configEntry) {
        String[] parts = configEntry.trim().split("\\s*,\\s*");
        return Integer.parseInt(parts[6]);
    }

    @Override
    public <T extends class_1792> Supplier<T> registerMagicBook(String id, class_1792.class_1793 properties, CompanionsItems.MagicType magicType) {
        switch (magicType) {
            case ICE_TORNADO: {
                return this.registerItem(id, () -> new IceTornadoBook(properties));
            }
            case FIRE_MARK: {
                return this.registerItem(id, () -> new FireMarkBook(properties));
            }
            case STONE_SPIKES: {
                return this.registerItem(id, () -> new StoneSpikesBook(properties));
            }
            case HEAL_RING: {
                return this.registerItem(id, () -> new HealRingBook(properties));
            }
            case BRACE: {
                return this.registerItem(id, () -> new BraceBook(properties));
            }
            case MAGIC_RAY: {
                return this.registerItem(id, () -> new MagicRayBook(properties));
            }
            case BLACK_HOLE: {
                return this.registerItem(id, () -> new BlackHoleBook(properties));
            }
            case NAGINATA: {
                return this.registerItem(id, () -> new NaginataBook(properties));
            }
        }
        return this.registerItem(id, () -> new IceShardBook(properties));
    }

    @Override
    public <T extends class_1291> class_6880<T> registerEffect(String id, Supplier<T> effect) {
        return CompanionsFabricPlatform.registerHolder(class_7923.field_41174, id, effect);
    }

    @Override
    public <T extends class_1741> class_6880<T> registerArmorMaterial(String id, Supplier<T> armorMaterial) {
        return CompanionsFabricPlatform.registerHolder(class_7923.field_48976, id, armorMaterial);
    }

    @Override
    public <T extends class_2396<?>> Supplier<T> registerParticle(String id, boolean overrideLimiter) {
        return CompanionsFabricPlatform.registerSupplier(class_7923.field_41180, id, () -> FabricParticleTypes.simple());
    }

    @Override
    public <T extends class_3414> Supplier<T> registerSound(String id, Supplier<T> sound) {
        return CompanionsFabricPlatform.registerSupplier(class_7923.field_41172, id, sound);
    }

    @Override
    public <T extends class_1761> Supplier<T> registerCreativeModeTab(String id, Supplier<T> tab) {
        return CompanionsFabricPlatform.registerSupplier(class_7923.field_44687, id, tab);
    }

    @Override
    public class_1761.class_7913 creativeTabBuilder() {
        return FabricItemGroup.builder();
    }

    @Override
    public <T extends class_3763> class_1299<T> getIllagerGolemEntity() {
        return CompanionsEntities.ILLAGER_GOLEM;
    }

    @Override
    public <T extends class_1297> class_1299<T> getFireMarkProjectile() {
        return CompanionsEntities.FIRE_MARK_PROJECTILE;
    }

    private static <T, R extends class_2378<? super T>> class_6880<T> registerHolder(R registry, String id, Supplier<T> object) {
        return class_2378.method_47985(registry, (class_2960)class_2960.method_60655((String)"companions", (String)id), object.get());
    }

    private static <T, R extends class_2378<? super T>> Supplier<T> registerSupplier(R registry, String id, Supplier<T> factory) {
        Object value = factory.get();
        class_2378.method_10230(registry, (class_2960)class_2960.method_60655((String)"companions", (String)id), value);
        return () -> value;
    }
}

