/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hotbarswapper.common.core;

import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import me.ichun.mods.hotbarswapper.common.HotbarSwapper;
import me.ichun.mods.ichunutil.client.key.KeyListener;
import me.ichun.mods.ichunutil.common.entity.EntityHelper;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.util.EventCalendar;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public abstract class EventHandlerClient {
    private KeyListener listenerHoldKey;
    private KeyListener listenerSlotKey;
    private boolean holdingSwapKey;
    private boolean holdingSwapSlotKey;
    private int currentIndex;
    private int popTimeout;
    private final ArrayList<ItemStack> hotbarWhenSwapping = new ArrayList();
    private boolean possibleLock;
    private final ItemStack stackBarrier = new ItemStack((ItemLike)Blocks.BARRIER);

    public EventHandlerClient() {
        iChunUtil.eC().registerClientTickEndListener(this::onClientTickEnd);
        iChunUtil.eC().registerOnClientConnectListener(mc -> this.onClientConnect());
    }

    public void onClientConnect() {
        if (this.listenerHoldKey == null) {
            this.findListenedHoldKey();
        }
        if (this.listenerSlotKey == null) {
            this.findListenedSlotKey();
        }
    }

    private void onClientTickEnd(Minecraft mc) {
        if (mc.player != null && !mc.player.isSpectator()) {
            if (this.listenerHoldKey != null && HotbarSwapper.config.swapKey.keyListener.keyBinding.isUnbound()) {
                this.listenerHoldKey.tick(mc);
            }
            if (this.listenerSlotKey != null && HotbarSwapper.config.swapSlot.keyListener.keyBinding.isUnbound()) {
                this.listenerSlotKey.tick(mc);
            }
            if (this.popTimeout > 0) {
                --this.popTimeout;
                if (this.popTimeout == 0) {
                    this.hotbarWhenSwapping.clear();
                }
                if (!this.hotbarWhenSwapping.isEmpty()) {
                    boolean foundDiff = false;
                    for (int i = 0; i < this.hotbarWhenSwapping.size(); ++i) {
                        ItemStack item = mc.player.getInventory().getItem(i);
                        if (ItemStack.matches((ItemStack)item, (ItemStack)this.hotbarWhenSwapping.get(i))) continue;
                        item.setPopTime(5);
                        foundDiff = true;
                    }
                    if (foundDiff) {
                        this.hotbarWhenSwapping.clear();
                        mc.player.playSound(SoundEvents.ITEM_PICKUP, 0.2f, (mc.player.getRandom().nextFloat() - mc.player.getRandom().nextFloat()) * 1.4f + 2.0f);
                    }
                }
            }
        }
    }

    public void onKeybindPressed(int index, boolean isRow) {
        if (HotbarSwapper.eventHandlerClient.addToIndex(index, isRow) && this.currentIndex != 0 || HotbarSwapper.eventHandlerClient.addToIndex(index, isRow)) {
            HotbarSwapper.eventHandlerClient.doSwap(isRow);
        }
    }

    protected boolean onMouseScroll(double scrollX, double scrollY) {
        if (this.isHoldingKey()) {
            this.possibleLock = false;
            if (this.holdingSwapSlotKey && HotbarSwapper.config.ignoredSlots.contains(Minecraft.getInstance().player.getInventory().selected)) {
                Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"chat.hotbarswapper.ignoreSlots.ignored", (Object[])new Object[]{Minecraft.getInstance().player.getInventory().selected + 1}), false);
                return true;
            }
            int addAmount = (int)(HotbarSwapper.config.invertScrollDirection ? scrollY : -scrollY);
            if (addAmount == 0) {
                addAmount = (int)Math.signum(HotbarSwapper.config.invertScrollDirection ? scrollY : -scrollY);
            }
            if (addAmount != 0) {
                this.addToIndex(addAmount, !this.holdingSwapSlotKey);
            }
            return true;
        }
        return false;
    }

    public boolean addToIndex(int addAmount, boolean isRow) {
        int oldIndex = this.currentIndex;
        this.currentIndex = EntityHelper.wrap((int)(this.currentIndex + addAmount), (int)0, (int)3);
        int addAmountSignum = (int)Math.signum(addAmount);
        if (this.currentIndex == oldIndex) {
            this.currentIndex = EntityHelper.wrap((int)(this.currentIndex + addAmountSignum), (int)0, (int)3);
        }
        while (!(this.isHoldingKey() && this.currentIndex == 0 || this.currentIndex == oldIndex || !HotbarSwapper.config.ignoreEmptySlots || this.isNotEmpty(this.currentIndex, Minecraft.getInstance().player.getInventory().selected, isRow))) {
            this.currentIndex = EntityHelper.wrap((int)(this.currentIndex + addAmountSignum), (int)0, (int)3);
        }
        return oldIndex != this.currentIndex;
    }

    private boolean isHoldingKey() {
        return this.holdingSwapKey || !HotbarSwapper.config.requireSwapKeyForSlot && this.holdingSwapSlotKey;
    }

    public boolean isNotEmpty(int rowIndex, int slotIndex, boolean isRow) {
        NonNullList items = Minecraft.getInstance().player.getInventory().items;
        if (isRow) {
            boolean isNotEmpty = false;
            for (int i = 9 * rowIndex; i < items.size() && i < 9 * (rowIndex + 1); ++i) {
                ItemStack itemStack;
                int index = i - 9 * rowIndex;
                if (HotbarSwapper.config.ignoredSlots.contains(index) || (itemStack = (ItemStack)items.get(i)).isEmpty()) continue;
                isNotEmpty = true;
                break;
            }
            return isNotEmpty;
        }
        if (HotbarSwapper.config.ignoredSlots.contains(slotIndex)) {
            return false;
        }
        int index = rowIndex * 9 + slotIndex;
        if (index < items.size()) {
            return !((ItemStack)items.get(index)).isEmpty();
        }
        return false;
    }

    public void doSwap(boolean isRow) {
        int i;
        if (this.currentIndex == 0) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        Inventory inventory = player.getInventory();
        this.popTimeout = 10;
        this.hotbarWhenSwapping.clear();
        for (i = 0; i < 9; ++i) {
            this.hotbarWhenSwapping.add(inventory.getItem(i).copy());
        }
        if (isRow) {
            for (i = 0; i < 9; ++i) {
                if (HotbarSwapper.config.ignoredSlots.contains(i)) continue;
                this.doSwap(player, inventory, i);
            }
        } else if (!HotbarSwapper.config.ignoredSlots.contains(inventory.selected)) {
            this.doSwap(player, inventory, inventory.selected);
        } else {
            Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"chat.hotbarswapper.ignoreSlots.ignored", (Object[])new Object[]{Minecraft.getInstance().player.getInventory().selected + 1}), false);
        }
    }

    private void doSwap(LocalPlayer player, Inventory inventory, int index) {
        player.connection.send((Packet)new ServerboundContainerClickPacket(player.inventoryMenu.containerId, player.inventoryMenu.getStateId(), index + 9 * this.currentIndex, index, ClickType.SWAP, ItemStack.EMPTY, (Int2ObjectMap)new Int2ObjectOpenHashMap()));
    }

    public void toggleLockSlot() {
        if (!HotbarSwapper.config.ignoredSlots.removeIf(i -> i == Minecraft.getInstance().player.getInventory().selected)) {
            HotbarSwapper.config.ignoredSlots.add(Minecraft.getInstance().player.getInventory().selected);
            Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"chat.hotbarswapper.ignoreSlots.add", (Object[])new Object[]{Minecraft.getInstance().player.getInventory().selected + 1}), false);
        } else {
            Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"chat.hotbarswapper.ignoreSlots.remove", (Object[])new Object[]{Minecraft.getInstance().player.getInventory().selected + 1}), false);
        }
        HotbarSwapper.config.save();
    }

    public void holdSwapKey(boolean isKeyDown) {
        boolean prevState = this.holdingSwapKey;
        this.holdingSwapKey = isKeyDown;
        if (this.holdingSwapKey) {
            if (this.holdingSwapSlotKey) {
                this.possibleLock = true;
            }
            if (!HotbarSwapper.config.requireSwapKeyForSlot && this.holdingSwapSlotKey) {
                this.holdingSwapSlotKey = false;
            } else {
                this.currentIndex = 0;
            }
        } else if (prevState) {
            if (this.currentIndex != 0) {
                this.doSwap(!this.holdingSwapSlotKey);
                this.holdingSwapSlotKey = false;
            } else if (this.possibleLock) {
                this.toggleLockSlot();
            }
        }
    }

    public void holdSwapSlotKey(boolean isKeyDown) {
        boolean prevState = this.holdingSwapSlotKey;
        this.holdingSwapSlotKey = isKeyDown;
        if (this.holdingSwapSlotKey) {
            if (!HotbarSwapper.config.requireSwapKeyForSlot) {
                if (!this.holdingSwapKey) {
                    this.currentIndex = 0;
                }
                this.holdingSwapKey = false;
            }
        } else if (prevState && this.currentIndex != 0 && (!HotbarSwapper.config.requireSwapKeyForSlot || this.holdingSwapKey)) {
            this.doSwap(false);
            this.holdingSwapKey = false;
        }
    }

    public void findListenedHoldKey() {
        Options options = Minecraft.getInstance().options;
        if (options == null) {
            return;
        }
        this.listenerHoldKey = null;
        if (!HotbarSwapper.config.swapKeyListen.isEmpty()) {
            KeyMapping key = this.findKey(HotbarSwapper.config.swapKeyListen);
            if (key != null) {
                this.listenerHoldKey = new KeyListener(key, listener -> this.holdSwapKey(true), listener -> this.holdSwapKey(false));
            } else {
                HotbarSwapper.LOGGER.warn("Could not find key for swap key called \"{}\"!", (Object)HotbarSwapper.config.swapKeyListen);
            }
        }
    }

    public void findListenedSlotKey() {
        Options options = Minecraft.getInstance().options;
        if (options == null) {
            return;
        }
        this.listenerSlotKey = null;
        if (!HotbarSwapper.config.swapSlotListen.isEmpty()) {
            KeyMapping key = this.findKey(HotbarSwapper.config.swapSlotListen);
            if (key != null) {
                this.listenerSlotKey = new KeyListener(key, listener -> this.holdSwapSlotKey(true), listener -> this.holdSwapSlotKey(false));
            } else {
                HotbarSwapper.LOGGER.warn("Could not find key for swap slot key called \"{}\"!", (Object)HotbarSwapper.config.swapSlotListen);
            }
        }
    }

    public KeyMapping findKey(@NotNull String name) {
        for (KeyMapping keyMapping : Minecraft.getInstance().options.keyMappings) {
            if (!name.equals(keyMapping.getName())) continue;
            return keyMapping;
        }
        return null;
    }

    public void renderItemHotbar(GuiGraphics graphics, DeltaTracker deltaTracker) {
        Minecraft mc = Minecraft.getInstance();
        Entity entity = mc.getCameraEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.isHoldingKey() && HotbarSwapper.config.itemScale > 0.0) {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                for (int i = 9 * this.currentIndex; i < player.getInventory().items.size() && i < 9 * (this.currentIndex + 1); ++i) {
                    if (HotbarSwapper.config.ignoredSlots.contains(i - 9 * this.currentIndex)) {
                        items.add(this.stackBarrier);
                        continue;
                    }
                    if (this.currentIndex != 0) {
                        items.add(!this.holdingSwapSlotKey || i - 9 * this.currentIndex == player.getInventory().selected ? (ItemStack)player.getInventory().items.get(i) : ItemStack.EMPTY);
                        continue;
                    }
                    items.add(ItemStack.EMPTY);
                }
                if (!items.stream().allMatch(ItemStack::isEmpty)) {
                    int halfWidth = graphics.guiWidth() / 2;
                    int seed = 1;
                    for (int i = 0; i < items.size(); ++i) {
                        double x = halfWidth - 90 + i * 20 + 2;
                        double y = graphics.guiHeight() - 16 - 3;
                        float scale = (float)HotbarSwapper.config.itemScale;
                        float offset = scale * 10.0f;
                        graphics.pose().pushPose();
                        graphics.pose().translate((x += (double)((float)HotbarSwapper.config.itemOffsetX * (1.0f - scale))) + (double)offset, (y += (double)((float)HotbarSwapper.config.itemOffsetY * (1.0f - scale))) + (double)offset, 100.0);
                        graphics.pose().scale(scale, scale, 1.0f);
                        if (EventCalendar.isEventDay()) {
                            graphics.pose().rotateAround(Axis.ZP.rotationDegrees(((float)player.tickCount + deltaTracker.getGameTimeDeltaPartialTick(false)) * 4.0f), 0.0f, 1.0f, 0.0f);
                        }
                        graphics.renderItem((LivingEntity)player, (ItemStack)items.get(i), (int)(-offset / scale), (int)(-offset / scale), seed++);
                        graphics.renderItemDecorations(mc.font, (ItemStack)items.get(i), (int)(-offset / scale), (int)(-offset / scale));
                        graphics.pose().popPose();
                    }
                }
            }
        }
    }
}

