package net.myitian.func_cmd_dedup.mixin;

import net.minecraft.commands.Commands;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.Registry;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.flag.FeatureFlagSet;
import net.myitian.func_cmd_dedup.FunctionCommandDeduplicator;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

@Mixin(ReloadableServerResources.class)
public class DataPackContentsMixin {
    @Inject(method = "reload", at = @At("HEAD"))
    private static void beforeReload(
            ResourceManager resourceManager,
            LayeredRegistryAccess<RegistryLayer> dynamicRegistries,
            List<Registry.PendingTags<?>> pendingTagLoads,
            FeatureFlagSet enabledFeatures,
            Commands.CommandSelection environment,
            int functionPermissionLevel,
            Executor prepareExecutor,
            Executor applyExecutor,
            CallbackInfoReturnable<CompletableFuture<ReloadableServerResources>> ci) {
        FunctionCommandDeduplicator.LOGGER.info("{} started", FunctionCommandDeduplicator.MOD_ID);
    }

    @Inject(method = "reload", at = @At("RETURN"))
    private static void afterReload(
            ResourceManager resourceManager,
            LayeredRegistryAccess<RegistryLayer> dynamicRegistries,
            List<Registry.PendingTags<?>> pendingTagLoads,
            FeatureFlagSet enabledFeatures,
            Commands.CommandSelection environment,
            int functionPermissionLevel,
            Executor prepareExecutor,
            Executor applyExecutor,
            CallbackInfoReturnable<CompletableFuture<ReloadableServerResources>> ci) {
        ci.getReturnValue().whenComplete(
                (object, throwable) -> FunctionCommandDeduplicator.clearActionCache());
    }
}
