/*
 * Decompiled with CFR 0.152.
 */
package net.orion.create_cold_sweat.blockeffects;

import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTemp;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.orion.create_cold_sweat.Config;
import net.orion.create_cold_sweat.utils.HeatUtils;
import org.jetbrains.annotations.Nullable;

public class BlazeBurner
extends BlockTemp {
    public BlazeBurner(Block ... blocks) {
        super(blocks);
    }

    public double getTemperature(Level level, @Nullable LivingEntity livingEntity, BlockState blockState, BlockPos blockPos, double distance) {
        boolean blazeBurnerTemperatureDisabled;
        boolean bl = blazeBurnerTemperatureDisabled = (Boolean)Config.CONFIG.blazeBurnerTemperature.get() == false;
        if (blazeBurnerTemperatureDisabled || !this.hasBlock(blockState.getBlock())) {
            return 0.0;
        }
        return Arrays.stream(BlazeBurnerBlock.HeatLevel.values()).map(hl -> {
            double d;
            if (this.isHeatLevel(blockState, (BlazeBurnerBlock.HeatLevel)hl)) {
                Double d2 = distance;
                d = HeatUtils.blazeBlend.apply(d2, switch (hl) {
                    default -> throw new MatchException(null, null);
                    case BlazeBurnerBlock.HeatLevel.NONE -> 0.0;
                    case BlazeBurnerBlock.HeatLevel.SMOULDERING -> (Double)Config.CONFIG.bBSmouldering.get();
                    case BlazeBurnerBlock.HeatLevel.FADING -> (Double)Config.CONFIG.bBFading.get();
                    case BlazeBurnerBlock.HeatLevel.KINDLED -> (Double)Config.CONFIG.bBKindled.get();
                    case BlazeBurnerBlock.HeatLevel.SEETHING -> (Double)Config.CONFIG.bBSeething.get();
                });
            } else {
                d = 0.0;
            }
            return d;
        }).filter(t -> t != 0.0).findFirst().orElse(0.0);
    }

    private boolean isHeatLevel(BlockState blockState, BlazeBurnerBlock.HeatLevel heatLevel) {
        return blockState.getValue((Property)BlazeBurnerBlock.HEAT_LEVEL) == heatLevel;
    }
}

