/*
 * Decompiled with CFR 0.152.
 */
package net.orion.create_cold_sweat;

import net.minecraftforge.common.ForgeConfigSpec;

public class Config {
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final Config CONFIG;
    public final ForgeConfigSpec.BooleanValue blazeBurnerTemperature;
    public final ForgeConfigSpec.DoubleValue bBSmouldering;
    public final ForgeConfigSpec.DoubleValue bBFading;
    public final ForgeConfigSpec.DoubleValue bBKindled;
    public final ForgeConfigSpec.DoubleValue bBSeething;
    public final ForgeConfigSpec.IntValue maxBlazeBurnerDistance;
    public final ForgeConfigSpec.BooleanValue boilerTemperature;
    public final ForgeConfigSpec.DoubleValue boilerTemperatureIncrement;
    public final ForgeConfigSpec.IntValue maxBoilerDistance;
    public final ForgeConfigSpec.BooleanValue liquidTemperature;
    public final ForgeConfigSpec.DoubleValue defaultFluidDampener;
    public final ForgeConfigSpec.IntValue maxFluidContainerDistance;
    public final ForgeConfigSpec.BooleanValue fanCooling;
    public final ForgeConfigSpec.DoubleValue maximumFanAngle;
    public final ForgeConfigSpec.BooleanValue fanTemperatureInteraction;
    public final ForgeConfigSpec.IntValue maxFanDistance;
    public final ForgeConfigSpec.BooleanValue calculateDefaultLiquidTemperature;
    public final ForgeConfigSpec.IntValue maxSteamEngineDistance;

    public Config(ForgeConfigSpec.Builder builder) {
        builder.comment("Create: Cold Sweat settings").push("General");
        this.blazeBurnerTemperature = builder.comment("Should blaze burners apply heat?").define("Blaze burner", true);
        this.bBSmouldering = builder.comment("Blaze burner smouldering temperature (MC UNITS)").defineInRange("Smouldering", 0.04291845493562232, 0.0, 1.0);
        this.bBFading = builder.comment("Blaze burner fading temperature (MC UNITS)").defineInRange("Fading", 0.12875536480686695, 0.0, 1.0);
        this.bBKindled = builder.comment("Blaze burner kindled temperature (MC UNITS)").defineInRange("Kindled", 0.2145922746781116, 0.0, 1.0);
        this.bBSeething = builder.comment("Blaze burner seething temperature (MC UNITS)").defineInRange("Seething", 0.4291845493562232, 0.0, 1.0);
        this.maxBlazeBurnerDistance = builder.comment("The maximum distance a blaze burner affects players").defineInRange("Max Blaze Burner", 8, 1, 16);
        this.boilerTemperature = builder.comment("Should Boilers apply heat?").define("Boiler", true);
        this.boilerTemperatureIncrement = builder.comment("The amount of MC UNITS to increase per heat level (max heat level is 18) (per block)").defineInRange("Boiler Increment", 0.004768717215069146, 0.0, 1.0);
        this.maxBoilerDistance = builder.comment("The maximum distance a boiler affects players").defineInRange("Max Boiler", 8, 1, 16);
        this.liquidTemperature = builder.comment("Should Liquids apply heat while in containers?").define("Liquids", true);
        this.defaultFluidDampener = builder.comment("The temperature dampening on all default calculated liquids (calculated temperature / dampening)").defineInRange("Liquid temperature dampening", 5.391630902, -16.0, 16.0);
        this.maxFluidContainerDistance = builder.comment("The maximum distance a fluid container affects players").defineInRange("Max Fluid Container", 8, 1, 16);
        this.fanCooling = builder.comment("Should fans affect player temperature?").define("Fans", true);
        this.maximumFanAngle = builder.comment("The maximum angle fans are allowed to affect the player (Degrees)").defineInRange("Fan Angle", 110.0, 90.0, 180.0);
        this.fanTemperatureInteraction = builder.comment("Should fans use the block directly in front of them to set a temperature").define("Fan Temperature Interaction", false);
        this.maxFanDistance = builder.comment("The maximum distance a fan affects players").defineInRange("Max Fan", 8, 1, 16);
        this.calculateDefaultLiquidTemperature = builder.comment("Whether the default fluid temperature should be calculated based off internal temperature values").define("Default Liquid Temperature", false);
        this.maxSteamEngineDistance = builder.comment("The maximum distance a steam engine affects players").defineInRange("Max Steam Engine", 8, 1, 16);
        builder.pop();
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        CONFIG = new Config(builder);
        SERVER_SPEC = builder.build();
    }
}

