/*
 * Decompiled with CFR 0.152.
 */
package net.orion.create_cold_sweat.blockeffects;

import com.google.common.util.concurrent.AtomicDouble;
import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTemp;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.orion.create_cold_sweat.Config;
import net.orion.create_cold_sweat.utils.HeatUtils;
import org.jetbrains.annotations.Nullable;

public class Boiler
extends BlockTemp {
    public Boiler(Block ... block) {
        super(block);
    }

    public double getTemperature(Level level, @Nullable LivingEntity livingEntity, BlockState blockState, BlockPos blockPos, double distance) {
        BlockEntity blockEntity;
        boolean doesNotHaveBlock;
        Boolean liquidTemperatureEnabled = (Boolean)Config.CONFIG.liquidTemperature.get();
        Boolean boilerTemperatureEnabled = (Boolean)Config.CONFIG.boilerTemperature.get();
        boolean configDisabled = boilerTemperatureEnabled == false && liquidTemperatureEnabled == false;
        boolean bl = doesNotHaveBlock = !this.hasBlock(blockState.m_60734_());
        if (configDisabled || doesNotHaveBlock || !((blockEntity = level.m_7702_(blockPos)) instanceof FluidTankBlockEntity)) {
            return 0.0;
        }
        FluidTankBlockEntity fluidTankBlockEntity = (FluidTankBlockEntity)blockEntity;
        AtomicDouble blockTemperature = new AtomicDouble();
        if (boilerTemperatureEnabled.booleanValue()) {
            blockTemperature.set(HeatUtils.calculateBoilerTemperature(fluidTankBlockEntity, temperature -> HeatUtils.boilerBlend.apply(distance, (Double)temperature)));
            if (blockTemperature.get() != 0.0) {
                return blockTemperature.get();
            }
        }
        if (blockTemperature.get() == 0.0 && liquidTemperatureEnabled.booleanValue()) {
            fluidTankBlockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(iFluidHandler -> {
                FluidStack fluidStack = HeatUtils.getFluid(iFluidHandler);
                if (fluidStack != null) {
                    blockTemperature.set(HeatUtils.getTemperatureFromDistanceAndFluidStack(level, distance, fluidStack));
                }
            });
        }
        return blockTemperature.get();
    }
}

