/*
 * Decompiled with CFR 0.152.
 */
package net.orion.create_cold_sweat.blockeffects;

import com.momosoftworks.coldsweat.api.registry.BlockTempRegistry;
import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTemp;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import com.simibubi.create.content.kinetics.fan.EncasedFanBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import net.orion.create_cold_sweat.Config;
import net.orion.create_cold_sweat.utils.HeatUtils;
import org.jetbrains.annotations.Nullable;

public class EncasedFan
extends BlockTemp {
    public EncasedFan(Block ... blocks) {
        super(blocks);
    }

    public double getTemperature(Level level, @Nullable LivingEntity livingEntity, BlockState blockState, BlockPos blockPos, double distance) {
        double maxRadians;
        EncasedFanBlockEntity encasedFan;
        block7: {
            block6: {
                BlockEntity blockEntity;
                boolean doesNotHaveBlock;
                boolean configDisabled = (Boolean)Config.CONFIG.fanCooling.get() == false;
                boolean bl = doesNotHaveBlock = !this.hasBlock(blockState.m_60734_());
                if (configDisabled || doesNotHaveBlock || !((blockEntity = level.m_7702_(blockPos)) instanceof EncasedFanBlockEntity)) break block6;
                encasedFan = (EncasedFanBlockEntity)blockEntity;
                if (livingEntity != null) break block7;
            }
            return 0.0;
        }
        if (encasedFan.getSpeed() == 0.0f) {
            return 0.0;
        }
        Vec3 entityPosition = livingEntity.m_20182_();
        Direction facing = (Direction)encasedFan.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        double angle = EncasedFan.getAngleFromFront(blockPos, facing, entityPosition);
        if (angle <= (maxRadians = Math.toRadians((Double)Config.CONFIG.maximumFanAngle.get()))) {
            double effectEfficiency = EncasedFan.getEffectEfficiency(encasedFan, angle, maxRadians);
            double targetTemperature = 0.0;
            double biomeTemperature = WorldHelper.getBiomeTemperature((LevelAccessor)level, (Holder)level.m_204166_(blockPos));
            if (((Boolean)Config.CONFIG.fanTemperatureInteraction.get()).booleanValue()) {
                BlockPos offset = blockPos.m_121955_(facing.m_122436_());
                BlockState state = level.m_8055_(offset);
                double tempForBlock = ((BlockTemp)BlockTempRegistry.getBlockTempsFor((BlockState)state).stream().toList().get(0)).getTemperature(level, null, state, offset, 0.0);
                FluidState fluidState = level.m_6425_(offset);
                double fluidStateTemperature = fluidState.m_76178_() ? 0.0 : HeatUtils.getFluidDataTemp(level, new FluidStack(fluidState.m_76152_(), 1000));
                targetTemperature = tempForBlock == 0.0 ? fluidStateTemperature : tempForBlock + biomeTemperature;
            }
            targetTemperature = targetTemperature == 0.0 ? biomeTemperature : targetTemperature;
            double playerTemperature = Temperature.get((LivingEntity)livingEntity, (Temperature.Trait)Temperature.Trait.WORLD);
            return HeatUtils.blend(distance, EncasedFan.getGeneratedTemperature(targetTemperature, playerTemperature, effectEfficiency), Math.max((int)((double)encasedFan.getMaxDistance() + 0.5), (Integer)Config.CONFIG.maxFanDistance.get()));
        }
        return 0.0;
    }

    private static double getGeneratedTemperature(double targetTemperature, double playerTemperature, double effectEfficiency) {
        double difference = targetTemperature - playerTemperature;
        double generated = effectEfficiency * difference;
        double generatedTemperature = targetTemperature > playerTemperature ? Math.max(0.0, generated) : Math.min(0.0, generated);
        return generatedTemperature *= 0.2;
    }

    private static double getEffectEfficiency(EncasedFanBlockEntity encasedFan, double angle, double maxRadians) {
        double angleDifference = Math.abs(angle - maxRadians);
        double unitAngleDifference = angleDifference / maxRadians;
        float unitSpeed = encasedFan.getSpeed() / 256.0f;
        return (unitAngleDifference + (double)unitSpeed) / 2.0;
    }

    public static double getAngleFromFront(BlockPos fanPos, Direction facing, Vec3 targetPos) {
        Vec3 fanOrigin = Vec3.m_82512_((Vec3i)fanPos).m_82549_(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(0.5));
        Vec3 toTarget = targetPos.m_82546_(fanOrigin).m_82541_();
        Vec3 facingVec = Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82541_();
        double dot = facingVec.m_82526_(toTarget);
        return Math.acos(dot);
    }
}

