/*
 * Decompiled with CFR 0.152.
 */
package net.orion.create_cold_sweat.utils;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.orion.create_cold_sweat.Config;
import net.orion.create_cold_sweat.datagen.DataGeneratorRegister;
import net.orion.create_cold_sweat.datagen.FluidTemperatureType;

public class HeatUtils {
    public static BiFunction<Double, Double, Double> fluidBlend;
    public static BiFunction<Double, Double, Double> blazeBlend;
    public static BiFunction<Double, Double, Double> boilerBlend;
    public static BiFunction<Double, Double, Double> steamEngineBlend;

    public static double getTemperatureFromDistanceAndFluidStack(Level level, double distance, FluidStack fluidStack) {
        double dataTemp = HeatUtils.getFluidDataTemp(level, fluidStack);
        return fluidBlend.apply(distance, dataTemp == 0.0 ? HeatUtils.calculateFluidTemperature(fluidStack) : dataTemp);
    }

    public static double getFluidDataTemp(Level level, FluidStack fluidStack) {
        if (!(level instanceof ServerLevel)) {
            return 0.0;
        }
        ServerLevel server = (ServerLevel)level;
        RegistryAccess registryAccess = server.m_9598_();
        Optional registryOptional = registryAccess.m_6632_(DataGeneratorRegister.FLUID_TEMPERATURE_KEY);
        if (registryOptional.isEmpty()) {
            return 0.0;
        }
        Registry registry = (Registry)registryOptional.get();
        return HeatUtils.getFluidTemperature((Registry<FluidTemperatureType>)registry, fluidStack);
    }

    private static double getFluidTemperature(Registry<FluidTemperatureType> registry, FluidStack fluidStack) {
        String fluidId = Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)fluidStack.getFluid())).toString();
        for (FluidTemperatureType fluidTemperatureType : registry) {
            if (!fluidTemperatureType.values().containsKey(fluidId)) continue;
            return Temperature.convert((double)fluidTemperatureType.values().get(fluidId), (Temperature.Units)fluidTemperatureType.units(), (Temperature.Units)Temperature.Units.MC, (boolean)false);
        }
        return 0.0;
    }

    public static double calculateFluidTemperature(FluidStack fluidStack) {
        if (!((Boolean)Config.CONFIG.calculateDefaultLiquidTemperature.get()).booleanValue()) {
            return 0.0;
        }
        int temperature = fluidStack.getFluid().getFluidType().getTemperature();
        if (temperature == 300) {
            return 0.0;
        }
        double MCUnitTemperature = HeatUtils.getMcUnitFluidTemperatureFromKelvin(fluidStack, temperature);
        return MCUnitTemperature / (Double)Config.CONFIG.defaultFluidDampener.get();
    }

    private static double getMcUnitFluidTemperatureFromKelvin(FluidStack fluidStack, int temperature) {
        int amount = fluidStack.getAmount();
        int effectiveContainedFluidTemperature = amount == 1 ? 1000 : amount;
        int kelvinTemperature = temperature - 300;
        return (double)kelvinTemperature * 0.04291845493562232 * (double)effectiveContainedFluidTemperature / 1000.0;
    }

    public static BiFunction<Double, Double, Double> createBlender(int maxDistance) {
        return (distance, temperature) -> HeatUtils.blend(distance, temperature, maxDistance);
    }

    public static double blend(double distance, double temperature, int maxDistance) {
        return CSMath.blend((double)temperature, (double)0.0, (double)distance, (double)0.5, (double)maxDistance);
    }

    public static double calculateBoilerTemperature(FluidTankBlockEntity tankBlockEntity, Function<Double, Double> calculateHeat) {
        if (tankBlockEntity == null) {
            return 0.0;
        }
        FluidTankBlockEntity controller = tankBlockEntity.getControllerBE();
        if (controller == null) {
            return 0.0;
        }
        return calculateHeat.apply((Double)Config.CONFIG.boilerTemperatureIncrement.get() * (double)controller.boiler.activeHeat);
    }

    @Nullable
    public static FluidStack getFluid(IFluidHandler iFluidHandler) {
        for (int i = 0; i < iFluidHandler.getTanks(); ++i) {
            FluidStack tank = iFluidHandler.getFluidInTank(i);
            if (tank.isEmpty()) continue;
            return tank;
        }
        return null;
    }
}

