/*
 * Decompiled with CFR 0.152.
 */
package net.orion.create_cold_sweat.blockeffects;

import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTemp;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.orion.create_cold_sweat.Config;
import net.orion.create_cold_sweat.utils.HeatUtils;
import org.jetbrains.annotations.Nullable;

public class Boiler
extends BlockTemp {
    public Boiler(Block ... block) {
        super(block);
    }

    public double getTemperature(Level level, @Nullable LivingEntity livingEntity, BlockState blockState, BlockPos blockPos, double distance) {
        IFluidHandler fluidHandler;
        FluidStack fluidStack;
        Object object;
        BlockEntity blockEntity;
        boolean doesNotHaveBlock;
        Boolean liquidTemperatureEnabled = (Boolean)Config.CONFIG.liquidTemperature.get();
        Boolean boilerTemperatureEnabled = (Boolean)Config.CONFIG.boilerTemperature.get();
        boolean configDisabled = boilerTemperatureEnabled == false && liquidTemperatureEnabled == false;
        boolean bl = doesNotHaveBlock = !this.hasBlock(blockState.getBlock());
        if (configDisabled || doesNotHaveBlock || !((blockEntity = level.getBlockEntity(blockPos)) instanceof FluidTankBlockEntity)) {
            return 0.0;
        }
        FluidTankBlockEntity fluidTankBlockEntity = (FluidTankBlockEntity)blockEntity;
        double blockTemperature = 0.0;
        if (((Boolean)Config.CONFIG.boilerTemperature.get()).booleanValue() && (blockTemperature = HeatUtils.calculateBoilerTemperature(fluidTankBlockEntity, temperature -> HeatUtils.boilerBlend.apply(distance, (Double)temperature))) != 0.0) {
            return blockTemperature;
        }
        if (((Boolean)Config.CONFIG.liquidTemperature.get()).booleanValue() && (object = Capabilities.FluidHandler.BLOCK.getCapability(level, blockPos, blockState, (BlockEntity)fluidTankBlockEntity, null)) instanceof IFluidHandler && (fluidStack = HeatUtils.getFluid(fluidHandler = (IFluidHandler)object)) != null) {
            blockTemperature = HeatUtils.getTemperatureFromDistanceAndFluidStack(level, distance, fluidStack);
        }
        return blockTemperature;
    }
}

