/*
 * Decompiled with CFR 0.152.
 */
package net.orion.create_cold_sweat.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.orion.create_cold_sweat.datagen.BlockTagGenerator;
import net.orion.create_cold_sweat.datagen.FluidTemperatureType;

@EventBusSubscriber(modid="create_cold_sweat", bus=EventBusSubscriber.Bus.MOD)
public class DataGeneratorRegister {
    public static final ResourceKey<Registry<FluidTemperatureType>> FLUID_TEMPERATURE_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"create_cold_sweat", (String)"fluid_temperatures"));

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new BlockTagGenerator(packOutput, lookupProvider, existingFileHelper));
    }

    @SubscribeEvent
    public static void onDataPackRegistry(DataPackRegistryEvent.NewRegistry newRegistry) {
        newRegistry.dataPackRegistry(FLUID_TEMPERATURE_KEY, FluidTemperatureType.CODEC);
    }
}

