/*
 * Decompiled with CFR 0.152.
 */
package net.orion.create_cold_sweat.blockeffects;

import com.momosoftworks.coldsweat.api.registry.BlockTempRegistry;
import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTemp;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import com.simibubi.create.content.kinetics.fan.EncasedFanBlockEntity;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import net.orion.create_cold_sweat.Config;
import net.orion.create_cold_sweat.utils.HeatUtils;
import org.jetbrains.annotations.Nullable;

public class EncasedFan
extends BlockTemp {
    public static final Map<LivingEntity, Set<EncasedFanBlockEntity>> fanMap = new HashMap<LivingEntity, Set<EncasedFanBlockEntity>>();
    int ticking = 0;

    public EncasedFan(Block ... blocks) {
        super(blocks);
    }

    public double getTemperature(Level level, @Nullable LivingEntity livingEntity, BlockState blockState, BlockPos blockPos, double distance) {
        double maxRadians;
        EncasedFanBlockEntity encasedFan;
        block8: {
            block7: {
                BlockEntity blockEntity;
                boolean doesNotHaveBlock;
                boolean configDisabled = (Boolean)Config.CONFIG.fanCooling.get() == false;
                boolean bl = doesNotHaveBlock = !this.hasBlock(blockState.getBlock());
                if (configDisabled || doesNotHaveBlock || !((blockEntity = level.getBlockEntity(blockPos)) instanceof EncasedFanBlockEntity)) break block7;
                encasedFan = (EncasedFanBlockEntity)blockEntity;
                if (livingEntity != null) break block8;
            }
            return 0.0;
        }
        float speed = encasedFan.getSpeed();
        if (speed == 0.0f || this.ticking++ != 60) {
            return 0.0;
        }
        this.ticking = 0;
        Vec3 entityPosition = livingEntity.position();
        Direction facing = (Direction)encasedFan.getBlockState().getValue((Property)BlockStateProperties.FACING);
        double angle = EncasedFan.getAngleFromFront(blockPos, facing, entityPosition);
        if (angle > (maxRadians = Math.toRadians((Double)Config.CONFIG.maximumFanAngle.get())) || distance > (double)((Integer)Config.CONFIG.maxFanDistance.get()).intValue()) {
            return 0.0;
        }
        fanMap.computeIfAbsent(livingEntity, e -> new HashSet());
        Set<EncasedFanBlockEntity> fans = fanMap.get(livingEntity);
        fans.add(encasedFan);
        int blockRange = ConfigSettings.BLOCK_RANGE.get() == null ? 16 : (Integer)ConfigSettings.BLOCK_RANGE.get();
        int maxFanDistance = (Integer)Config.CONFIG.maxFanDistance.get();
        int maxDistance = Math.min(maxFanDistance, blockRange);
        int maxDistanceSqr = maxDistance * maxDistance;
        fans.removeIf(fan -> fan.getBlockPos().distSqr((Vec3i)livingEntity.blockPosition()) > (double)maxDistanceSqr);
        double biomeTemperature = WorldHelper.getBiomeTemperature((LevelAccessor)level, (Holder)level.getBiome(blockPos));
        double playerTemperature = Temperature.get((LivingEntity)livingEntity, (Temperature.Trait)Temperature.Trait.WORLD);
        boolean fanTemperatureInteraction = (Boolean)Config.CONFIG.fanTemperatureInteraction.get();
        double totalTargetTemp = 0.0;
        int contributingFans = 0;
        for (EncasedFanBlockEntity fan2 : fans) {
            Direction fanFacing = (Direction)fan2.getBlockState().getValue((Property)BlockStateProperties.FACING);
            double fanTargetTemp = biomeTemperature;
            if (fanTemperatureInteraction) {
                BlockPos offset = fan2.getBlockPos().offset(fanFacing.getNormal());
                BlockState state = level.getBlockState(offset);
                double tempForBlock = BlockTempRegistry.getBlockTempsFor((BlockState)state).stream().findFirst().map(temp -> temp.getTemperature(level, null, state, offset, 0.0)).orElse(0.0);
                FluidState fluidState = level.getFluidState(offset);
                double fluidTemp = fluidState.isEmpty() ? 0.0 : HeatUtils.getFluidDataTemp(level, new FluidStack(fluidState.getType(), 1000));
                fanTargetTemp += tempForBlock == 0.0 ? fluidTemp : tempForBlock;
            }
            totalTargetTemp += fanTargetTemp;
            ++contributingFans;
        }
        double averageTargetTemp = contributingFans == 0 ? biomeTemperature : totalTargetTemp / (double)contributingFans;
        double totalEfficiency = fans.stream().mapToDouble(fan -> EncasedFan.getEffectEfficiency(fan.getSpeed(), EncasedFan.getAngleFromFront(fan.getBlockPos(), (Direction)fan.getBlockState().getValue((Property)BlockStateProperties.FACING), entityPosition), maxRadians)).sum();
        double combinedEfficiency = 1.0 - Math.exp(-totalEfficiency);
        return HeatUtils.blend(distance, EncasedFan.getGeneratedTemperature(averageTargetTemp, playerTemperature, combinedEfficiency), (Integer)Config.CONFIG.maxFanDistance.get());
    }

    private static double getGeneratedTemperature(double targetTemperature, double playerTemperature, double effectEfficiency) {
        double difference = targetTemperature - playerTemperature;
        double generated = effectEfficiency * difference;
        return targetTemperature > playerTemperature ? Math.max(0.0, generated) : Math.min(0.0, generated);
    }

    private static double getEffectEfficiency(float speed, double angle, double maxRadians) {
        double angleDifference = Math.abs(angle - maxRadians);
        double unitAngleDifference = angleDifference / maxRadians;
        float unitSpeed = Math.abs(speed) / 256.0f;
        return (unitAngleDifference + (double)unitSpeed) / 2.0;
    }

    public static double getAngleFromFront(BlockPos fanPos, Direction facing, Vec3 targetPos) {
        Vec3 fanOrigin = Vec3.atCenterOf((Vec3i)fanPos).add(Vec3.atLowerCornerOf((Vec3i)facing.getNormal()).scale(0.5));
        Vec3 toTarget = targetPos.subtract(fanOrigin).normalize();
        Vec3 facingVec = Vec3.atLowerCornerOf((Vec3i)facing.getNormal()).normalize();
        double dot = facingVec.dot(toTarget);
        return Math.acos(dot);
    }
}

