/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block;

import com.mojang.serialization.MapCodec;
import net.frozenblock.wilderwild.entity.Tumbleweed;
import net.frozenblock.wilderwild.registry.WWBlocks;
import net.frozenblock.wilderwild.registry.WWEntityTypes;
import net.frozenblock.wilderwild.registry.WWSounds;
import net.frozenblock.wilderwild.tag.WWBlockTags;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2311;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TumbleweedPlantBlock
extends class_2311
implements class_2256 {
    public static final MapCodec<TumbleweedPlantBlock> CODEC = TumbleweedPlantBlock.method_54094(TumbleweedPlantBlock::new);
    public static final int MAX_AGE = 3;
    public static final int AGE_FOR_SOLID_COLLISION = 2;
    public static final int RANDOM_TICK_CHANCE = 2;
    public static final int SNAP_CHANCE = 3;
    public static final int REPRODUCTION_CHANCE_PEACEFUL = 20;
    public static final int REPRODUCTION_CHANCE_DIVIDER_BY_DIFFICULTY = 15;
    public static final class_2758 AGE = class_2741.field_12497;
    private static final class_265[] SHAPES = new class_265[]{class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)12.0, (double)9.0, (double)12.0), class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0)};

    public TumbleweedPlantBlock(@NotNull class_4970.class_2251 properties) {
        super(properties);
    }

    public static boolean isFullyGrown(@NotNull class_2680 state) {
        return (Integer)state.method_11654((class_2769)AGE) == 3;
    }

    @NotNull
    public MapCodec<? extends TumbleweedPlantBlock> method_53969() {
        return CODEC;
    }

    public void method_9514(@NotNull class_2680 state, @NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_5819 random) {
        if (random.method_43048(2) == 0) {
            if (TumbleweedPlantBlock.isFullyGrown(state)) {
                if (random.method_43048(3) == 0) {
                    level.method_8652(pos, (class_2680)state.method_28493((class_2769)AGE), 2);
                    Tumbleweed weed = new Tumbleweed(WWEntityTypes.TUMBLEWEED, (class_1937)level);
                    level.method_8649((class_1297)weed);
                    weed.method_33574(class_243.method_24955((class_2382)pos));
                    int diff = level.method_8407().method_5461();
                    if (level.method_8409().method_43048(diff == 0 ? 20 : 15 / diff) == 0) {
                        weed.setItem(new class_1799((class_1935)WWBlocks.TUMBLEWEED_PLANT), true);
                    }
                    level.method_8396(null, pos, WWSounds.ENTITY_TUMBLEWEED_DAMAGE, class_3419.field_15245, 1.0f, 1.0f);
                    level.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
                    level.method_33596(null, (class_6880)class_5712.field_28733, pos);
                }
            } else {
                level.method_8652(pos, (class_2680)state.method_28493((class_2769)AGE), 2);
            }
        }
    }

    @NotNull
    public class_265 method_9549(@NotNull class_2680 blockState, @NotNull class_1922 blockGetter, @NotNull class_2338 blockPos, @NotNull class_3726 collisionContext) {
        return (Integer)blockState.method_11654((class_2769)AGE) < 2 ? class_259.method_1073() : super.method_9549(blockState, blockGetter, blockPos, collisionContext);
    }

    @NotNull
    public class_265 method_9530(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_3726 context) {
        return SHAPES[(Integer)state.method_11654((class_2769)AGE)];
    }

    protected boolean method_9695(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos) {
        return state.method_26164(WWBlockTags.SHRUB_MAY_PLACE_ON) || super.method_9695(state, level, pos);
    }

    public boolean method_9651(@NotNull class_4538 level, @NotNull class_2338 pos, @NotNull class_2680 state) {
        return !TumbleweedPlantBlock.isFullyGrown(state);
    }

    public boolean method_9650(@NotNull class_1937 level, @NotNull class_5819 random, @NotNull class_2338 pos, @NotNull class_2680 state) {
        return true;
    }

    public void method_9652(@NotNull class_3218 level, @NotNull class_5819 random, @NotNull class_2338 pos, @NotNull class_2680 state) {
        level.method_8501(pos, (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(Math.min(3, (Integer)state.method_11654((class_2769)AGE) + random.method_39332(1, 2)))));
    }

    public class_1269 method_55765(@NotNull class_1799 stack, @NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_1268 hand, @NotNull class_3965 hit) {
        if (stack.method_31574(class_1802.field_8868) && TumbleweedPlantBlock.onShear(level, pos, state, (class_1297)player)) {
            stack.method_71012(1, (class_1309)player, hand);
            return class_1269.field_5812;
        }
        return super.method_55765(stack, state, level, pos, player, hand, hit);
    }

    public static boolean onShear(class_1937 level, class_2338 pos, @NotNull class_2680 state, @Nullable class_1297 entity) {
        if (TumbleweedPlantBlock.isFullyGrown(state)) {
            if (!level.method_8608()) {
                Tumbleweed.spawnFromShears(level, pos);
                level.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
                level.method_8501(pos, (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0)));
                level.method_33596(entity, (class_6880)class_5712.field_28730, pos);
            }
            return true;
        }
        return false;
    }

    protected void method_9515(@NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{AGE});
    }
}

