/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.datafix.minecraft.datafixers;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.frozenblock.wilderwild.WWConstants;
import net.minecraft.class_1208;
import net.minecraft.class_1220;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public final class CopperHornInstrumentToTheCopperierAgeFix
extends DataFix {
    private static final String INSTRUMENT_DATA_FIELD = class_2960.method_60656((String)"instrument").toString();
    private static final String ITEM_ID = WWConstants.id("copper_horn").toString();

    public CopperHornInstrumentToTheCopperierAgeFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(class_1208.field_5712);
        return this.fixTypeEverywhereTyped("Migrate Copper Horn Instruments to The Copperier Age", type, this.createFixer(type, this::fixItemStack));
    }

    @NotNull
    private UnaryOperator<Typed<?>> createFixer(@NotNull Type<?> type, UnaryOperator<Dynamic<?>> unaryOperator) {
        OpticFinder idFinder = DSL.fieldFinder((String)"id", (Type)DSL.named((String)class_1208.field_5713.typeName(), (Type)class_1220.method_28295()));
        OpticFinder components = type.findField("components");
        return typed -> {
            Optional itemId = typed.getOptional(idFinder);
            return itemId.isPresent() && ((String)((Pair)itemId.get()).getSecond()).equals(ITEM_ID) ? typed.updateTyped(components, typedx -> typedx.update(DSL.remainderFinder(), (Function)unaryOperator)) : typed;
        };
    }

    private Dynamic<?> fixItemStack(@NotNull Dynamic<?> componentData) {
        OptionalDynamic optionalInstrument = componentData.get(INSTRUMENT_DATA_FIELD);
        if (optionalInstrument.result().isEmpty()) {
            return componentData;
        }
        Dynamic instrument = (Dynamic)optionalInstrument.result().get();
        String instrumentID = instrument.asString("");
        if (!instrumentID.startsWith("wilderwild")) {
            return componentData;
        }
        instrumentID = instrumentID.replaceFirst("wilderwild", "thecopperierage");
        componentData = componentData.set(INSTRUMENT_DATA_FIELD, componentData.createString(instrumentID));
        return componentData;
    }
}

