/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.mod_compat;

import com.google.common.collect.UnmodifiableIterator;
import com.mojang.datafixers.util.Pair;
import com.terraformersmc.biolith.api.biome.BiomePlacement;
import com.terraformersmc.biolith.api.biome.sub.BiomeParameterTargets;
import com.terraformersmc.biolith.api.biome.sub.Criterion;
import com.terraformersmc.biolith.api.biome.sub.CriterionBuilder;
import com.terraformersmc.biolith.api.biome.sub.RatioTargets;
import java.util.ArrayList;
import net.frozenblock.lib.integration.api.ModIntegration;
import net.frozenblock.lib.worldgen.biome.api.parameters.FrozenBiomeParameters;
import net.frozenblock.lib.worldgen.biome.api.parameters.OverworldBiomeBuilderParameters;
import net.frozenblock.wilderwild.config.WWWorldgenConfig;
import net.frozenblock.wilderwild.registry.WWBiomes;
import net.frozenblock.wilderwild.worldgen.biome.FrozenCaves;
import net.frozenblock.wilderwild.worldgen.biome.MagmaticCaves;
import net.frozenblock.wilderwild.worldgen.biome.MapleForest;
import net.frozenblock.wilderwild.worldgen.biome.MesogleaCaves;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6862;
import net.minecraft.class_6908;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class BiolithIntegration
extends ModIntegration {
    public BiolithIntegration() {
        super("biolith");
    }

    public void init() {
        Criterion criterionC;
        Criterion criterionB;
        Criterion criterionA;
        Criterion temperature;
        WWWorldgenConfig worldgenConfig = WWWorldgenConfig.get();
        WWWorldgenConfig.BiomeGeneration biomeGeneration = worldgenConfig.biomeGeneration;
        WWWorldgenConfig.BiomePlacement biomePlacement = worldgenConfig.biomePlacement;
        if (biomePlacement.modifyJunglePlacement) {
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9424, (class_5321)class_1972.field_9417, (Criterion)CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.TEMPERATURE, (float)0.55f, (float)1.0f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.HUMIDITY, (float)0.3f, (float)1.0f)}));
        }
        if (biomePlacement.modifyCherryGrovePlacement) {
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9409, (class_5321)class_1972.field_42720, (Criterion)CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.TEMPERATURE, (float)-0.15f, (float)0.2f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.HUMIDITY, (float)-0.35f, (float)0.3f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.EROSION, (float)-0.2225f, (float)0.05f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.PEAKS_VALLEYS, (float)-1.0f, (float)0.2f)}));
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9412, (class_5321)class_1972.field_42720, (Criterion)CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.TEMPERATURE, (float)0.55f, (float)1.0f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.HUMIDITY, (float)0.3f, (float)1.0f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.EROSION, (float)-0.2225f, (float)0.05f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.PEAKS_VALLEYS, (float)-1.0f, (float)0.2f)}));
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_35112, (class_5321)class_1972.field_42720, (Criterion)CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.TEMPERATURE, (float)0.55f, (float)1.0f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.HUMIDITY, (float)0.3f, (float)1.0f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.EROSION, (float)-0.2225f, (float)0.05f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.PEAKS_VALLEYS, (float)-1.0f, (float)0.2f)}));
        }
        if (biomePlacement.modifyStonyShorePlacement) {
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9434, (class_5321)class_1972.field_9419, (Criterion)CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.TEMPERATURE, (float)-0.45f, (float)-0.15f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.HUMIDITY, (float)-0.1f, (float)1.0f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.CONTINENTALNESS, (float)-0.19f, (float)-0.11f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.EROSION, (float)0.05f, (float)0.45f)}));
        }
        if (biomeGeneration.generateAridForest) {
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9424, WWBiomes.ARID_FOREST, (Criterion)BiolithIntegration.atEdgeOf((class_5321<class_1959>)class_1972.field_9409, 0.1f));
        }
        if (biomeGeneration.generateAridSavanna) {
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9449, WWBiomes.ARID_SAVANNA, (Criterion)BiolithIntegration.atEdgeOf((class_5321<class_1959>)class_1972.field_9424, 0.1f));
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9424, WWBiomes.ARID_SAVANNA, (Criterion)BiolithIntegration.atEdgeOf((class_5321<class_1959>)class_1972.field_9409, 0.2f));
        }
        if (biomeGeneration.generateBirchJungle) {
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9417, WWBiomes.BIRCH_JUNGLE, (Criterion)BiolithIntegration.atEdgeOfAny(0.2f, class_1972.field_9412, class_1972.field_35112));
            Criterion jungleOrBambooJungleEdge = BiolithIntegration.atEdgeOfAny(0.2f, class_1972.field_9417, class_1972.field_9440);
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9412, WWBiomes.BIRCH_JUNGLE, (Criterion)jungleOrBambooJungleEdge);
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_35112, WWBiomes.BIRCH_JUNGLE, (Criterion)jungleOrBambooJungleEdge);
        }
        if (biomeGeneration.generateBirchTaiga) {
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9420, WWBiomes.BIRCH_TAIGA, (Criterion)BiolithIntegration.atEdgeOfAny(0.2f, class_1972.field_9412, class_1972.field_35112));
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9412, WWBiomes.BIRCH_TAIGA, (Criterion)BiolithIntegration.atEdgeOf((class_5321<class_1959>)class_1972.field_9420, 0.2f));
        }
        if (biomeGeneration.generateDarkBirchForest) {
            Criterion darkForestEdge = BiolithIntegration.atEdgeOf((class_5321<class_1959>)class_1972.field_9475, 0.2f);
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9412, WWBiomes.DARK_BIRCH_FOREST, (Criterion)darkForestEdge);
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_35112, WWBiomes.DARK_BIRCH_FOREST, (Criterion)darkForestEdge);
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9475, WWBiomes.DARK_BIRCH_FOREST, (Criterion)BiolithIntegration.atEdgeOfAny(0.2f, class_1972.field_9412, class_1972.field_35112));
        }
        if (biomeGeneration.generateDarkTaiga) {
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_35119, WWBiomes.DARK_TAIGA, (Criterion)BiolithIntegration.atEdgeOf((class_5321<class_1959>)class_1972.field_9475, 0.2f));
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9475, WWBiomes.DARK_TAIGA, (Criterion)BiolithIntegration.atEdgeOf((class_5321<class_1959>)class_1972.field_35119, 0.2f));
        }
        if (biomeGeneration.generateOldGrowthBirchTaiga) {
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_35112, WWBiomes.OLD_GROWTH_BIRCH_TAIGA, (Criterion)BiolithIntegration.atEdgeOf((class_5321<class_1959>)class_1972.field_9420, 0.2f));
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9420, WWBiomes.OLD_GROWTH_BIRCH_TAIGA, (Criterion)BiolithIntegration.atEdgeOf((class_5321<class_1959>)class_1972.field_35112, 0.2f));
        }
        if (biomeGeneration.generateParchedForest) {
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9409, WWBiomes.PARCHED_FOREST, (Criterion)BiolithIntegration.atEdgeOf((class_5321<class_1959>)class_1972.field_9449, 0.1f));
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9449, WWBiomes.PARCHED_FOREST, (Criterion)BiolithIntegration.atEdgeOf((class_5321<class_1959>)class_1972.field_9409, 0.2f));
        }
        if (biomeGeneration.generateRainforest) {
            Criterion forestEdge = BiolithIntegration.atEdgeOf((class_5321<class_1959>)class_1972.field_9409, 0.1f);
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9409, WWBiomes.RAINFOREST, (Criterion)BiolithIntegration.neighboringAny(class_1972.field_9417, class_1972.field_9440));
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9417, WWBiomes.RAINFOREST, (Criterion)forestEdge);
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9440, WWBiomes.RAINFOREST, (Criterion)forestEdge);
        }
        if (biomeGeneration.generateSemiBirchForest) {
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9409, WWBiomes.SEMI_BIRCH_FOREST, (Criterion)BiolithIntegration.atEdgeOfAny(0.2f, class_1972.field_9412, class_1972.field_35112));
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9412, WWBiomes.SEMI_BIRCH_FOREST, (Criterion)BiolithIntegration.atEdgeOf((class_5321<class_1959>)class_1972.field_9409, 0.2f));
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_35112, WWBiomes.SEMI_BIRCH_FOREST, (Criterion)BiolithIntegration.atEdgeOf((class_5321<class_1959>)class_1972.field_9409, 0.2f));
        }
        if (biomeGeneration.generateSparseBirchJungle) {
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_35118, WWBiomes.SPARSE_BIRCH_JUNGLE, (Criterion)BiolithIntegration.atEdgeOfAny(0.2f, class_1972.field_9412, class_1972.field_35112));
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9412, WWBiomes.SPARSE_BIRCH_JUNGLE, (Criterion)BiolithIntegration.atEdgeOf((class_5321<class_1959>)class_1972.field_35118, 0.3f));
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_35112, WWBiomes.SPARSE_BIRCH_JUNGLE, (Criterion)BiolithIntegration.atEdgeOf((class_5321<class_1959>)class_1972.field_35118, 0.3f));
        }
        if (biomeGeneration.generateSparseForest) {
            temperature = CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.TEMPERATURE, (float)(biomeGeneration.generateDyingForest ? -0.3f : -0.45f), (float)0.0f);
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9409, WWBiomes.SPARSE_FOREST, (Criterion)CriterionBuilder.allOf((Criterion[])new Criterion[]{BiolithIntegration.atEdgeOfAny(0.2f, class_1972.field_9451), temperature}));
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9451, WWBiomes.SPARSE_FOREST, (Criterion)CriterionBuilder.allOf((Criterion[])new Criterion[]{BiolithIntegration.atEdgeOfAny(0.2f, class_1972.field_9409), temperature}));
        }
        if (biomeGeneration.generateWarmBeach) {
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9434, WWBiomes.WARM_BEACH, (Criterion)CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.TEMPERATURE, (float)0.2f, (float)0.55f));
        }
        if (biomeGeneration.generateWarmRiver) {
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9438, WWBiomes.WARM_RIVER, (Criterion)CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.TEMPERATURE, (float)0.2f, (float)0.55f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.HUMIDITY, (float)-0.1f, (float)0.0f)}));
            temperature = CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.TEMPERATURE, (float)0.55f, (float)1.0f);
            if (biomePlacement.modifyJunglePlacement) {
                BiomePlacement.addSubOverworld((class_5321)class_1972.field_9438, WWBiomes.WARM_RIVER, (Criterion)CriterionBuilder.allOf((Criterion[])new Criterion[]{temperature, CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.HUMIDITY, (float)0.0f, (float)1.0f)}));
            } else {
                BiomePlacement.addSubOverworld((class_5321)class_1972.field_9438, WWBiomes.WARM_RIVER, (Criterion)temperature);
            }
        }
        if (biomeGeneration.generateDyingForest) {
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9409, WWBiomes.DYING_FOREST, (Criterion)CriterionBuilder.allOf((Criterion[])new Criterion[]{BiolithIntegration.neighboringAny(class_1972.field_35117, class_1972.field_9454, class_1972.field_9463, class_1972.field_34471), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.TEMPERATURE, (float)-0.45f, (float)0.15f)}));
        }
        if (biomeGeneration.generateDyingMixedForest) {
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9420, WWBiomes.DYING_MIXED_FOREST, (Criterion)CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.TEMPERATURE, (float)(biomeGeneration.generateTundra ? -0.495f : -0.465f), (float)-0.3f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.HUMIDITY, (float)-0.105f, (float)0.05f)}));
        }
        if (biomeGeneration.generateFlowerField) {
            criterionA = CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.TEMPERATURE, (float)-0.2f, (float)-0.075f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.HUMIDITY, (float)-1.0f, (float)-0.35f)});
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9451, WWBiomes.FLOWER_FIELD, (Criterion)criterionA);
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_34470, WWBiomes.FLOWER_FIELD, (Criterion)criterionA);
            criterionB = CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.TEMPERATURE, (float)-0.15f, (float)0.2f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.HUMIDITY, (float)-0.4f, (float)-0.3f)});
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9451, WWBiomes.FLOWER_FIELD, (Criterion)criterionB);
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_34470, WWBiomes.FLOWER_FIELD, (Criterion)criterionB);
            criterionC = CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.TEMPERATURE, (float)-0.2f, (float)-0.075f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.HUMIDITY, (float)-0.3675f, (float)-0.3125f)});
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9451, WWBiomes.FLOWER_FIELD, (Criterion)criterionC);
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_34470, WWBiomes.FLOWER_FIELD, (Criterion)criterionC);
        }
        if (biomeGeneration.generateMixedForest) {
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9420, WWBiomes.MIXED_FOREST, (Criterion)CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.TEMPERATURE, (float)-0.45f, (float)-0.14f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.HUMIDITY, (float)0.05f, (float)0.15f)}));
        }
        if (biomeGeneration.generateOasis) {
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9424, WWBiomes.OASIS, (Criterion)CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.neighbor((class_6862)class_6908.field_36511), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.PEAKS_VALLEYS, (float)-1.0f, (float)0.2f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.HUMIDITY, (float)0.1f, (float)0.3f)}));
            Criterion neighboringVanillaJungles = BiolithIntegration.neighboringAny(class_1972.field_9417, class_1972.field_9440, class_1972.field_35118);
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9424, WWBiomes.OASIS, (Criterion)CriterionBuilder.allOf((Criterion[])new Criterion[]{neighboringVanillaJungles, CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.HUMIDITY, (float)0.1f, (float)0.3f)}));
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9424, WWBiomes.OASIS, (Criterion)CriterionBuilder.allOf((Criterion[])new Criterion[]{neighboringVanillaJungles, CriterionBuilder.ratioMax((RatioTargets)RatioTargets.EDGE, (float)0.3f)}));
        }
        if (biomeGeneration.generateOldGrowthDarkForest) {
            BiomePlacement.replaceOverworld((class_5321)class_1972.field_9475, WWBiomes.OLD_GROWTH_DARK_FOREST, (double)0.5);
            BiomePlacement.addSubOverworld(WWBiomes.OLD_GROWTH_DARK_FOREST, (class_5321)class_1972.field_9475, (Criterion)CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.TEMPERATURE, (float)-1.0f, (float)-0.2f));
            BiomePlacement.addSubOverworld(WWBiomes.OLD_GROWTH_DARK_FOREST, (class_5321)class_1972.field_9475, (Criterion)CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.TEMPERATURE, (float)0.2f, (float)1.0f));
            BiomePlacement.addSubOverworld(WWBiomes.OLD_GROWTH_DARK_FOREST, (class_5321)class_1972.field_9475, (Criterion)CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.HUMIDITY, (float)-1.0f, (float)0.35f));
        }
        if (biomeGeneration.generateSnowyDyingForest) {
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_35117, WWBiomes.SNOWY_DYING_FOREST, (Criterion)CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.TEMPERATURE, (float)(biomeGeneration.generateTundra ? -0.505f : -0.485f), (float)(biomeGeneration.generateTundra ? -0.495f : 0.465f)), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.HUMIDITY, (float)-0.105f, (float)0.05f)}));
        }
        if (biomeGeneration.generateSnowyDyingMixedForest) {
            temperature = CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.TEMPERATURE, (float)(biomeGeneration.generateTundra ? -0.505f : -0.485f), (float)(biomeGeneration.generateTundra ? -0.495f : -0.465f));
            for (class_6544.class_4762 point : OverworldBiomeBuilderParameters.points((class_5321)class_1972.field_9454)) {
                Criterion criterion = CriterionBuilder.allOf((Criterion[])new Criterion[]{temperature, CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.HUMIDITY, (float)(FrozenBiomeParameters.isWeird((class_6544.class_4762)point) ? -0.105f : 0.05f), (float)0.155f)});
                BiomePlacement.addSubOverworld((class_5321)class_1972.field_9454, WWBiomes.SNOWY_DYING_MIXED_FOREST, (Criterion)criterion);
                BiomePlacement.addSubOverworld((class_5321)class_1972.field_35117, WWBiomes.SNOWY_DYING_MIXED_FOREST, (Criterion)criterion);
            }
        }
        if (biomeGeneration.generateOldGrowthSnowyTaiga) {
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9420, WWBiomes.SNOWY_OLD_GROWTH_PINE_TAIGA, (Criterion)CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.TEMPERATURE, (float)-1.0f, (float)-0.45f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.HUMIDITY, (float)0.3f, (float)1.0f)}));
        }
        if (biomeGeneration.generateTemperateRainforest) {
            Criterion criterion = CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.TEMPERATURE, (float)-0.25f, (float)-0.05f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.HUMIDITY, (float)0.25f, (float)1.0f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.EROSION, (float)-1.0f, (float)0.05f)});
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9420, WWBiomes.TEMPERATE_RAINFOREST, (Criterion)criterion);
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_35113, WWBiomes.TEMPERATE_RAINFOREST, (Criterion)criterion);
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_35119, WWBiomes.TEMPERATE_RAINFOREST, (Criterion)criterion);
        }
        if (biomeGeneration.generateTundra) {
            if (!biomeGeneration.generateMapleForest) {
                criterionA = CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.TEMPERATURE, (float)-0.495f, (float)-0.295f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.HUMIDITY, (float)-1.0f, (float)-0.2f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.CONTINENTALNESS, (float)-0.11f, (float)0.03f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.EROSION, (float)-2.233f, (float)0.45f)});
                criterionB = CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.TEMPERATURE, (float)-1.0f, (float)-0.45f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.HUMIDITY, (float)0.3f, (float)0.7f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.CONTINENTALNESS, (float)-0.11f, (float)0.03f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.EROSION, (float)0.05f, (float)0.45f)});
                criterionC = CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.TEMPERATURE, (float)-0.495f, (float)-0.245f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.HUMIDITY, (float)-1.0f, (float)-0.1f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.CONTINENTALNESS, (float)0.03f, (float)0.8f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.EROSION, (float)-0.375f, (float)0.45f)});
                BiomePlacement.addSubOverworld((class_5321)class_1972.field_9451, WWBiomes.TUNDRA, (Criterion)criterionA);
                BiomePlacement.addSubOverworld((class_5321)class_1972.field_35117, WWBiomes.TUNDRA, (Criterion)criterionA);
                BiomePlacement.addSubOverworld((class_5321)class_1972.field_9451, WWBiomes.TUNDRA, (Criterion)criterionA);
                BiomePlacement.addSubOverworld((class_5321)class_1972.field_35117, WWBiomes.TUNDRA, (Criterion)criterionA);
                BiomePlacement.addSubOverworld((class_5321)class_1972.field_9451, WWBiomes.TUNDRA, (Criterion)criterionB);
                BiomePlacement.addSubOverworld((class_5321)class_1972.field_35117, WWBiomes.TUNDRA, (Criterion)criterionB);
                BiomePlacement.addSubOverworld((class_5321)class_1972.field_9451, WWBiomes.TUNDRA, (Criterion)criterionC);
                BiomePlacement.addSubOverworld((class_5321)class_1972.field_35117, WWBiomes.TUNDRA, (Criterion)criterionC);
            }
            if (biomePlacement.modifyTundraPlacement) {
                BiomePlacement.addSubOverworld((class_5321)class_1972.field_9451, WWBiomes.TUNDRA, (Criterion)BiolithIntegration.atEdgeOf((class_5321<class_1959>)class_1972.field_34472, 0.4f));
                BiomePlacement.addSubOverworld((class_5321)class_1972.field_34472, WWBiomes.TUNDRA, (Criterion)BiolithIntegration.atEdgeOf((class_5321<class_1959>)class_1972.field_9451, 0.2f));
            }
            if (biomeGeneration.generateMapleForest) {
                Criterion neighboringMapleForest = CriterionBuilder.neighbor(WWBiomes.MAPLE_FOREST);
                BiomePlacement.addSubOverworld((class_5321)class_1972.field_9451, WWBiomes.TUNDRA, (Criterion)neighboringMapleForest);
                BiomePlacement.addSubOverworld((class_5321)class_1972.field_35117, WWBiomes.TUNDRA, (Criterion)neighboringMapleForest);
                BiomePlacement.addSubOverworld((class_5321)class_1972.field_34470, WWBiomes.TUNDRA, (Criterion)neighboringMapleForest);
            }
        }
        if (biomeGeneration.generateCypressWetlands) {
            BiomePlacement.addSubOverworld((class_5321)class_1972.field_9471, WWBiomes.CYPRESS_WETLANDS, (Criterion)CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.TEMPERATURE, (float)0.2f, (float)0.55f), CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.HUMIDITY, (float)-0.1f, (float)0.3f)}));
        }
        if (biomeGeneration.generateFrozenCaves) {
            UnmodifiableIterator unmodifiableIterator = FrozenCaves.DEPTHS.iterator();
            while (unmodifiableIterator.hasNext()) {
                float depth = ((Float)unmodifiableIterator.next()).floatValue();
                Pair<class_6544.class_4762, class_6544.class_4762> biomeParameters = FrozenCaves.INSTANCE.makeParametersAt(depth);
                BiomePlacement.addOverworld(WWBiomes.FROZEN_CAVES, (class_6544.class_4762)((class_6544.class_4762)biomeParameters.getFirst()));
                BiomePlacement.addOverworld(WWBiomes.FROZEN_CAVES, (class_6544.class_4762)((class_6544.class_4762)biomeParameters.getSecond()));
            }
        }
        if (biomeGeneration.generateMagmaticCaves) {
            BiomePlacement.addOverworld(WWBiomes.MAGMATIC_CAVES, (class_6544.class_4762)new class_6544.class_4762(MagmaticCaves.TEMPERATURE, MagmaticCaves.HUMIDITY, MagmaticCaves.CONTINENTALNESS, MagmaticCaves.EROSION, class_6544.class_6546.method_38120((float)1.1f), MagmaticCaves.WEIRDNESS, 0L));
        }
        if (biomeGeneration.generateMapleForest) {
            BiolithIntegration.addSurfaceBiome(WWBiomes.MAPLE_FOREST, MapleForest.TEMPERATURE, MapleForest.HUMIDITY, MapleForest.CONTINENTALNESS, MapleForest.EROSION, MapleForest.WEIRDNESS_A);
            BiolithIntegration.addSurfaceBiome(WWBiomes.MAPLE_FOREST, MapleForest.TEMPERATURE, MapleForest.HUMIDITY, MapleForest.CONTINENTALNESS, MapleForest.EROSION, MapleForest.WEIRDNESS_B);
        }
        if (biomeGeneration.generateMesogleaCaves) {
            BiomePlacement.addOverworld(WWBiomes.MESOGLEA_CAVES, (class_6544.class_4762)new class_6544.class_4762(MesogleaCaves.TEMPERATURE, MesogleaCaves.HUMIDITY, MesogleaCaves.CONTINENTALNESS, MesogleaCaves.EROSION, class_6544.class_6546.method_38121((float)0.4f, (float)1.0f), MesogleaCaves.WEIRDNESS, 0L));
            BiomePlacement.addOverworld(WWBiomes.MESOGLEA_CAVES, (class_6544.class_4762)new class_6544.class_4762(MesogleaCaves.TEMPERATURE, MesogleaCaves.HUMIDITY, MesogleaCaves.CONTINENTALNESS, MesogleaCaves.EROSION, class_6544.class_6546.method_38121((float)0.2f, (float)0.9f), MesogleaCaves.WEIRDNESS, 0L));
        }
    }

    @Contract(value="_, _ -> new")
    @NotNull
    private static Criterion atEdgeOf(class_5321<class_1959> biome, float max) {
        return CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.ratioMax((RatioTargets)RatioTargets.EDGE, (float)max), CriterionBuilder.neighbor(biome)});
    }

    @SafeVarargs
    @NotNull
    private static Criterion atEdgeOfAny(float max, class_5321<class_1959> ... biomes) {
        ArrayList<Criterion> criterions = new ArrayList<Criterion>();
        for (class_5321<class_1959> biome : biomes) {
            criterions.add(BiolithIntegration.atEdgeOf(biome, max));
        }
        return CriterionBuilder.anyOf(criterions);
    }

    @SafeVarargs
    @NotNull
    private static Criterion neighboringAny(class_5321<class_1959> ... biomes) {
        ArrayList<Criterion> criterions = new ArrayList<Criterion>();
        for (class_5321<class_1959> biome : biomes) {
            criterions.add(CriterionBuilder.neighbor(biome));
        }
        return CriterionBuilder.anyOf(criterions);
    }

    private static void addSurfaceBiome(class_5321<class_1959> biome, class_6544.class_6546 temperature, class_6544.class_6546 humidity, class_6544.class_6546 continentalness, class_6544.class_6546 erosion, class_6544.class_6546 weirdness) {
        BiomePlacement.addOverworld(biome, (class_6544.class_4762)new class_6544.class_4762(temperature, humidity, continentalness, erosion, class_6544.class_6546.method_38120((float)0.0f), weirdness, 0L));
        BiomePlacement.addOverworld(biome, (class_6544.class_4762)new class_6544.class_4762(temperature, humidity, continentalness, erosion, class_6544.class_6546.method_38120((float)1.0f), weirdness, 0L));
    }
}

