/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.frozenblock.wilderwild.block.state.properties.GeyserType;
import net.frozenblock.wilderwild.registry.WWCriteria;
import net.minecraft.class_1297;
import net.minecraft.class_175;
import net.minecraft.class_184;
import net.minecraft.class_2048;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4558;
import net.minecraft.class_47;
import net.minecraft.class_5258;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeyserPushMobTrigger
extends class_4558<TriggerInstance> {
    public static final double TRIGGER_DISTANCE_FROM_PLAYER = class_3532.method_33723((double)16.0);

    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(@NotNull class_3222 player, class_1297 entity, boolean playerPlaced, GeyserType geyserType) {
        class_47 pushedMob = class_2048.method_27802((class_3222)player, (class_1297)entity);
        this.method_22510(player, conditions -> conditions.matches(pushedMob, playerPlaced, geyserType));
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<class_5258> pushedMob;
        private final boolean playerPlaced;
        private final Optional<GeyserType> geyserType;
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)class_2048.field_47250.optionalFieldOf("pushed_mob").forGetter(TriggerInstance::pushedMob), (App)Codec.BOOL.fieldOf("requires_player_placed_geyser").forGetter(TriggerInstance::playerPlaced), (App)GeyserType.CODEC.optionalFieldOf("geyser_type").forGetter(TriggerInstance::geyserType)).apply((Applicative)instance, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, Optional<class_5258> pushedMob, boolean playerPlaced, Optional<GeyserType> geyserType) {
            this.player = player;
            this.pushedMob = pushedMob;
            this.playerPlaced = playerPlaced;
            this.geyserType = geyserType;
        }

        @NotNull
        public static class_175<TriggerInstance> geyserPushMob(Optional<class_2048> pushedMob, boolean playerPlaced, @Nullable GeyserType geyserType) {
            return WWCriteria.GEYSER_PUSH_MOB_TRIGGER.method_53699((class_184)new TriggerInstance(Optional.empty(), class_2048.method_53137(pushedMob), playerPlaced, Optional.ofNullable(geyserType)));
        }

        public boolean matches(class_47 pushedMob, boolean playerPlaced, GeyserType geyserType) {
            if (this.playerPlaced && !playerPlaced) {
                return false;
            }
            if (this.geyserType.isPresent() && this.geyserType.get() != geyserType) {
                return false;
            }
            return this.pushedMob.isEmpty() || this.pushedMob.get().method_27806(pushedMob);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;pushedMob;playerPlaced;geyserType", "player", "pushedMob", "playerPlaced", "geyserType"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;pushedMob;playerPlaced;geyserType", "player", "pushedMob", "playerPlaced", "geyserType"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;pushedMob;playerPlaced;geyserType", "player", "pushedMob", "playerPlaced", "geyserType"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<class_5258> pushedMob() {
            return this.pushedMob;
        }

        public boolean playerPlaced() {
            return this.playerPlaced;
        }

        public Optional<GeyserType> geyserType() {
            return this.geyserType;
        }
    }
}

