/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.frozenblock.wilderwild.registry.WWBlocks;
import net.frozenblock.wilderwild.registry.WWItems;
import net.frozenblock.wilderwild.registry.WWSounds;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1297;
import net.minecraft.class_1540;
import net.minecraft.class_1542;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_8813;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoconutBlock
extends class_2346
implements class_2256 {
    public static final MapCodec<CoconutBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_8813.field_46510.fieldOf("tree").forGetter(coconutBlock -> coconutBlock.treeGrower), (App)CoconutBlock.method_54096()).apply((Applicative)instance, CoconutBlock::new));
    public static final double GROWTH_CHANCE_HANGING = 0.4;
    public static final int VALID_FROND_DISTANCE = 2;
    public static final int MAX_AGE = 2;
    public static final float FALL_DAMAGE_PER_DISTANCE = 0.5f;
    public static final int MAX_FALL_DAMAGE = 3;
    public static final class_2758 STAGE = class_2741.field_12549;
    public static final class_2758 AGE = class_2741.field_12556;
    public static final class_2746 HANGING = class_2741.field_16561;
    private static final class_265[] SHAPES = new class_265[]{class_259.method_17786((class_265)class_2248.method_9541((double)2.0, (double)9.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (class_265[])new class_265[0]), class_259.method_17786((class_265)class_2248.method_9541((double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (class_265[])new class_265[0]), class_259.method_17786((class_265)class_2248.method_9541((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0), (class_265[])new class_265[0]), class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0)};
    private final class_8813 treeGrower;

    public CoconutBlock(class_8813 treeGrower, @NotNull class_4970.class_2251 settings) {
        super(settings);
        this.treeGrower = treeGrower;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)STAGE, (Comparable)Integer.valueOf(0))).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0))).method_11657((class_2769)HANGING, (Comparable)Boolean.valueOf(false)));
    }

    private static boolean isHanging(@NotNull class_2680 state) {
        return (Boolean)state.method_11654((class_2769)HANGING);
    }

    private static boolean isFullyGrown(@NotNull class_2680 state) {
        return (Integer)state.method_11654((class_2769)AGE) == 2;
    }

    @NotNull
    public static class_2680 getDefaultHangingState() {
        return CoconutBlock.getHangingState(0);
    }

    @NotNull
    public static class_2680 getHangingState(int age) {
        return (class_2680)((class_2680)WWBlocks.COCONUT.method_9564().method_11657((class_2769)HANGING, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(age));
    }

    @NotNull
    protected MapCodec<? extends CoconutBlock> method_53969() {
        return CODEC;
    }

    public void advanceTree(@NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull class_5819 random) {
        if ((Integer)state.method_11654((class_2769)STAGE) == 0) {
            level.method_8652(pos, (class_2680)state.method_28493((class_2769)STAGE), 4);
        } else {
            this.treeGrower.method_54085(level, level.method_14178().method_12129(), pos, state, random);
        }
    }

    @NotNull
    public class_265 method_9549(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_3726 context) {
        return state.method_27852((class_2248)this) && !CoconutBlock.isHanging(state) ? class_259.method_1073() : super.method_9549(state, level, pos, context);
    }

    protected void method_9515(@NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{STAGE, AGE, HANGING});
    }

    @Nullable
    public class_2680 method_9605(@NotNull class_1750 ctx) {
        return (class_2680)Objects.requireNonNull(super.method_9605(ctx)).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(2));
    }

    @NotNull
    protected class_2680 method_9559(@NotNull class_2680 blockState, class_4538 levelReader, class_10225 scheduledTickAccess, class_2338 blockPos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 randomSource) {
        if (blockState.method_27852((class_2248)this) && !blockState.method_26184(levelReader, blockPos)) {
            if (!CoconutBlock.isHanging(blockState)) {
                return class_2246.field_10124.method_9564();
            }
            scheduledTickAccess.method_64310(blockPos, (class_2248)this, this.method_26154());
        }
        return blockState;
    }

    @NotNull
    public class_265 method_9530(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_3726 context) {
        class_243 vec3d = state.method_26226(pos);
        class_265 voxelShape = (Boolean)state.method_11654((class_2769)HANGING) == false ? SHAPES[3] : SHAPES[(Integer)state.method_11654((class_2769)AGE)];
        return voxelShape.method_1096(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
    }

    public boolean method_9558(@NotNull class_2680 state, @NotNull class_4538 level, @NotNull class_2338 pos) {
        return state.method_27852((class_2248)this) && CoconutBlock.isHanging(state) ? level.method_8320(pos.method_10084()).method_27852((class_2248)WWBlocks.PALM_FRONDS) : this.mayPlaceOn(level.method_8320(pos.method_10074()));
    }

    protected boolean mayPlaceOn(@NotNull class_2680 state) {
        return state.method_26164(class_3481.field_29822) || state.method_27852(class_2246.field_10362) || state.method_26164(class_3481.field_15466);
    }

    public void method_9514(@NotNull class_2680 state, @NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_5819 random) {
        if (state.method_27852((class_2248)this) && level.method_22339(pos.method_10084()) >= 9) {
            if (!CoconutBlock.isHanging(state)) {
                if (random.method_43048(7) == 0) {
                    this.advanceTree(level, pos, state, random);
                }
            } else if (random.method_43058() <= 0.4 && !CoconutBlock.isFullyGrown(state)) {
                level.method_8652(pos, (class_2680)state.method_28493((class_2769)AGE), 2);
            }
        }
    }

    public boolean method_9651(@NotNull class_4538 world, @NotNull class_2338 pos, @NotNull class_2680 state) {
        return state.method_27852((class_2248)this) && (!CoconutBlock.isHanging(state) || !CoconutBlock.isFullyGrown(state));
    }

    public boolean method_9650(@NotNull class_1937 level, @NotNull class_5819 random, @NotNull class_2338 pos, @NotNull class_2680 state) {
        return state.method_27852((class_2248)this) && (CoconutBlock.isHanging(state) ? !CoconutBlock.isFullyGrown(state) : (double)level.field_9229.method_43057() < (double)0.45f);
    }

    public void method_9652(@NotNull class_3218 level, @NotNull class_5819 random, @NotNull class_2338 pos, @NotNull class_2680 state) {
        if (CoconutBlock.isHanging(state) && !CoconutBlock.isFullyGrown(state)) {
            level.method_8652(pos, (class_2680)state.method_28493((class_2769)AGE), 2);
        } else {
            this.advanceTree(level, pos, state, random);
        }
    }

    public boolean method_9579(@NotNull class_2680 state) {
        return state.method_26227().method_15769();
    }

    public boolean method_9516(@NotNull class_2680 state, @NotNull class_10 type) {
        if (type == class_10.field_51 && state.method_27852((class_2248)this) && !CoconutBlock.isHanging(state)) {
            return true;
        }
        return super.method_9516(state, type);
    }

    public void method_19286(@NotNull class_1937 level, @NotNull class_2680 state, @NotNull class_3965 hit, @NotNull class_1676 projectile) {
        if (state.method_27852((class_2248)this) && CoconutBlock.isHanging(state)) {
            if (CoconutBlock.isFullyGrown(state)) {
                class_1540 fallingBlockEntity = class_1540.method_40005((class_1937)level, (class_2338)hit.method_17777(), (class_2680)state);
                this.method_10132(fallingBlockEntity);
            } else {
                level.method_22352(hit.method_17777(), true);
            }
        }
    }

    protected void method_10132(@NotNull class_1540 entity) {
        entity.method_6965(0.5f, 3);
    }

    public void method_9588(@NotNull class_2680 state, @NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_5819 random) {
        if (pos.method_10264() <= level.method_31607() || state.method_27852((class_2248)this) && !CoconutBlock.isHanging(state)) {
            return;
        }
        if (state.method_27852((class_2248)this) && CoconutBlock.isHanging(state) && !state.method_26184((class_4538)level, pos)) {
            if (CoconutBlock.isFullyGrown(state)) {
                class_1540 fallingBlockEntity = class_1540.method_40005((class_1937)level, (class_2338)pos, (class_2680)state);
                this.method_10132(fallingBlockEntity);
            } else {
                level.method_22352(pos, true);
            }
        }
    }

    public void method_10127(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull class_2680 replaceableState, @NotNull class_1540 fallingBlock) {
        if (!level.method_8608()) {
            level.method_8501(pos, replaceableState);
        }
    }

    public void method_10129(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1540 fallingBlock) {
        level.method_8649((class_1297)new class_1542(level, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, new class_1799((class_1935)WWItems.COCONUT, 3)));
        level.method_8396(null, pos, WWSounds.BLOCK_COCONUT_BREAK, class_3419.field_15245, 1.0f, 1.0f);
    }

    public void method_9496(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_5819 random) {
    }

    public int method_10130(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos) {
        return 0;
    }
}

