/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block.impl;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.frozenblock.wilderwild.block.impl.SnowloggingUtils;
import net.frozenblock.wilderwild.config.WWAmbienceAndMiscConfig;
import net.frozenblock.wilderwild.entity.FallingLeafTicker;
import net.frozenblock.wilderwild.networking.packet.WWLeavesExplosionParticlePacket;
import net.frozenblock.wilderwild.particle.options.WWFallingLeavesParticleOptions;
import net.frozenblock.wilderwild.registry.WWEntityTypes;
import net.frozenblock.wilderwild.registry.WWParticleTypes;
import net.frozenblock.wilderwild.tag.WWBlockTags;
import net.frozenblock.wilderwild.tag.WWEntityTags;
import net.minecraft.class_10595;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_5945;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9892;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FallingLeafUtil {
    private static final LeafParticleData DEFAULT_LEAF_PARTICLE_DATA = new LeafParticleData(class_2246.field_10503, 0.0125f, () -> 1.0, 4, 2.0f, 10.0f, LeafMovementType.SWIRL);
    private static final Function<Float, Float> SLIGHTLY_HEAVY_GRAVITY_MODIFIER = gravity -> Float.valueOf(Math.max(2.5f, gravity.floatValue() * 1.5f));
    private static final Map<class_2248, FallingLeafData> LEAVES_TO_FALLING_LEAF_DATA = new Object2ObjectLinkedOpenHashMap();
    private static final Map<class_2396<WWFallingLeavesParticleOptions>, LeafParticleData> PARTICLE_TO_LEAF_PARTICLE_DATA = new Object2ObjectLinkedOpenHashMap();
    private static final Map<class_2396<WWFallingLeavesParticleOptions>, LeafParticleData> PARTICLE_TO_LITTER_PARTICLE_DATA = new Object2ObjectLinkedOpenHashMap();

    public static void registerLeavesWithLitter(class_2248 block, class_10595 leafLitterBlock, float litterChance, class_2396<WWFallingLeavesParticleOptions> leafParticle, float particleChance, Supplier<Double> frequencyModifier, int textureSize, float particleGravityScale, float windScale, LeafMovementType leafMovementType) {
        FallingLeafUtil.registerLeaves(block, false, new FallingLeafData(Optional.of(leafLitterBlock), litterChance, leafParticle), leafParticle, new LeafParticleData(block, particleChance, frequencyModifier, textureSize, particleGravityScale, windScale, leafMovementType));
        FallingLeafUtil.registerLeaves((class_2248)leafLitterBlock, true, leafParticle, 1.0f, () -> 1.0, textureSize, particleGravityScale * 1.5f, windScale * 0.8f, leafMovementType.getGroundSupportingEquivalent());
    }

    public static void registerLeaves(class_2248 block, boolean isLitter, class_2396<WWFallingLeavesParticleOptions> leafParticle, float particleChance, Supplier<Double> frequencyModifier, int textureSize, float particleGravityScale, float windScale, LeafMovementType leafMovementType) {
        FallingLeafUtil.registerLeaves(block, isLitter, new FallingLeafData(Optional.empty(), 0.0f, leafParticle), leafParticle, new LeafParticleData(block, particleChance, frequencyModifier, textureSize, particleGravityScale, windScale, leafMovementType));
    }

    private static void registerLeaves(class_2248 block, boolean isLitter, FallingLeafData fallingLeafData, class_2396<WWFallingLeavesParticleOptions> leafParticle, @Nullable LeafParticleData leafParticleData) {
        LEAVES_TO_FALLING_LEAF_DATA.put(block, fallingLeafData);
        if (leafParticleData != null) {
            (isLitter ? PARTICLE_TO_LITTER_PARTICLE_DATA : PARTICLE_TO_LEAF_PARTICLE_DATA).put(leafParticle, leafParticleData);
        }
    }

    @NotNull
    public static Optional<FallingLeafData> getFallingLeafData(class_2248 block) {
        return Optional.ofNullable(LEAVES_TO_FALLING_LEAF_DATA.get(block));
    }

    public static LeafParticleData getLeafParticleData(class_2396<WWFallingLeavesParticleOptions> leafParticle) {
        return PARTICLE_TO_LEAF_PARTICLE_DATA.getOrDefault(leafParticle, DEFAULT_LEAF_PARTICLE_DATA);
    }

    public static LeafParticleData getLitterOrLeafParticleData(class_2396<WWFallingLeavesParticleOptions> leafParticle) {
        return PARTICLE_TO_LITTER_PARTICLE_DATA.getOrDefault(leafParticle, FallingLeafUtil.getLeafParticleData(leafParticle));
    }

    public static void onRandomTick(@NotNull class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        Optional<FallingLeafData> optionalFallingLeafData = FallingLeafUtil.getFallingLeafData(state.method_26204());
        if (optionalFallingLeafData.isEmpty()) {
            return;
        }
        FallingLeafData fallingLeafData = optionalFallingLeafData.get();
        class_2338 belowPos = pos.method_10074();
        class_2680 belowState = world.method_8320(belowPos);
        if (class_2248.method_9501((class_265)belowState.method_26220((class_1922)world, belowPos), (class_2350)class_2350.field_11036)) {
            return;
        }
        if (random.method_43057() > fallingLeafData.litterChance()) {
            return;
        }
        world.method_65096((class_2394)new class_2388(class_2398.field_11217, state), (double)pos.method_10263() + 0.5, (double)pos.method_10264() - 0.1, (double)pos.method_10260() + 0.5, random.method_43051(12, 24), 0.3, 0.0, 0.3, 0.05);
        FallingLeafUtil.sendLeafClusterParticle(world, pos);
        fallingLeafData.leafLitterBlock.ifPresent(leafLitterBlock -> FallingLeafTicker.createAndSpawn(WWEntityTypes.FALLING_LEAVES, (class_1937)world, pos, (class_2248)leafLitterBlock));
    }

    public static void sendLeafClusterParticle(@NotNull class_3218 world, @NotNull class_2338 pos) {
        world.method_65096((class_2394)WWParticleTypes.LEAF_CLUSTER_SPAWNER, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 1, 0.0, 0.0, 0.0, 0.0);
    }

    public static boolean isSafePosToPlaceLitter(@NotNull class_1937 world, class_2338 pos, @NotNull class_2680 stateToReplace, class_2248 leafLitterBlock) {
        if (stateToReplace.method_27852(class_2246.field_10477) || SnowloggingUtils.isSnowlogged(stateToReplace)) {
            return false;
        }
        if ((stateToReplace.method_26215() || stateToReplace.method_45474() || stateToReplace.method_27852(leafLitterBlock)) && stateToReplace.method_26227().method_15769()) {
            return leafLitterBlock.method_9558(leafLitterBlock.method_9564(), (class_4538)world, pos);
        }
        return false;
    }

    public static boolean addFallingLeafParticles(@NotNull class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        class_2338 blockPos;
        class_2680 blockState;
        if (!WWAmbienceAndMiscConfig.Client.USE_WILDER_WILD_FALLING_LEAVES) {
            return false;
        }
        Optional<FallingLeafData> optionalFallingLeafData = FallingLeafUtil.getFallingLeafData(state.method_26204());
        if (optionalFallingLeafData.isEmpty()) {
            return false;
        }
        FallingLeafData fallingLeafData = optionalFallingLeafData.get();
        class_2396<WWFallingLeavesParticleOptions> leafParticle = fallingLeafData.particle();
        LeafParticleData leafParticleData = FallingLeafUtil.getLeafParticleData(leafParticle);
        if ((double)random.method_43057() <= (double)leafParticleData.particleChance() * leafParticleData.frequencyModifier().get() && !class_2248.method_9501((class_265)(blockState = world.method_8320(blockPos = pos.method_10074())).method_26220((class_1922)world, blockPos), (class_2350)class_2350.field_11036)) {
            class_5945.method_49099((class_1937)world, (class_2338)pos, (class_5819)random, (class_2394)FallingLeafUtil.createLeafParticleOptions(fallingLeafData, false));
        }
        return true;
    }

    public static void trySpawnWalkParticles(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1297 entity, boolean checkCollision) {
        class_238 shape;
        if (checkCollision && !(shape = state.method_26172((class_1922)level, pos, class_3726.method_16195((class_1297)entity)).method_1107().method_996(pos)).method_994(entity.method_5829())) {
            return;
        }
        boolean franticSpawn = entity.method_5864().method_20210(WWEntityTags.LEAF_PARTICLES_FRANTIC_SPAWN);
        double horizontalScale = franticSpawn ? 0.1 : 0.5;
        double additionalY = franticSpawn ? 0.1 : 0.0;
        class_243 movement = entity.method_18798();
        double horizontalDistance = movement.method_37267();
        movement = new class_243(movement.field_1352 * horizontalScale, horizontalDistance * 0.1 + additionalY, movement.field_1350 * horizontalScale);
        if (!franticSpawn ? (double)level.field_9229.method_43057() > horizontalDistance * 0.5 : level.field_9229.method_43057() > 0.05f) {
            return;
        }
        FallingLeafUtil.spawnWalkingParticles(level, pos, state, movement);
    }

    private static void spawnWalkingParticles(@NotNull class_1937 level, class_2338 pos, @NotNull class_2680 state, class_243 velocity) {
        Optional<FallingLeafData> optionalFallingLeafData;
        boolean litter = false;
        if (state.method_26164(WWBlockTags.LEAF_LITTERS)) {
            litter = true;
            if (!WWAmbienceAndMiscConfig.Client.LEAF_LITTER_WALKING_PARTICLES) {
                return;
            }
        } else if (!WWAmbienceAndMiscConfig.Client.LEAF_WALKING_PARTICLES) {
            return;
        }
        if ((optionalFallingLeafData = FallingLeafUtil.getFallingLeafData(state.method_26204())).isEmpty()) {
            return;
        }
        class_5819 random = level.field_9229;
        double x = (double)pos.method_10263() + 0.5 + random.method_43059() * 0.4;
        double y = (double)pos.method_10264() + (!litter ? 1.1 : 0.1);
        double z = (double)pos.method_10260() + 0.5 + random.method_43059() * 0.4;
        WWFallingLeavesParticleOptions options = FallingLeafUtil.createLeafParticleOptions(optionalFallingLeafData.get(), velocity, litter, true, SLIGHTLY_HEAVY_GRAVITY_MODIFIER);
        if (level instanceof class_3218) {
            class_3218 server = (class_3218)level;
            server.method_65096((class_2394)options, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            return;
        }
        level.method_8406((class_2394)options, x, y, z, 0.0, 0.0, 0.0);
    }

    public static void trySendExplosionParticles(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, class_1927 explosion) {
        Supplier<Integer> count;
        if (!(level instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)level;
        if (!(explosion instanceof class_9892)) {
            return;
        }
        class_9892 serverExplosion = (class_9892)explosion;
        Optional<FallingLeafData> optionalFallingLeafData = FallingLeafUtil.getFallingLeafData(state.method_26204());
        if (optionalFallingLeafData.isEmpty()) {
            return;
        }
        float radius = serverExplosion.method_55107();
        class_243 difference = pos.method_46558().method_1020(serverExplosion.method_55109());
        double leafPower = ((double)radius - difference.method_1033()) / (double)radius;
        ArrayList<class_2350> validDirections = new ArrayList<class_2350>();
        if (state.method_26164(WWBlockTags.LEAF_LITTERS)) {
            count = () -> Math.max((int)leafPower * state.method_28500((class_2769)class_10595.field_55791).orElse(2), 1);
        } else {
            if (!serverExplosion.method_55111().method_61723()) {
                class_2338.class_2339 mutable = new class_2338.class_2339();
                for (class_2350 direction : class_2350.values()) {
                    class_2680 offsetState = level.method_8320((class_2338)mutable.method_25505((class_2382)pos, direction));
                    if (class_2248.method_9501((class_265)offsetState.method_26220((class_1922)level, (class_2338)mutable), (class_2350)direction.method_10153())) continue;
                    validDirections.add(direction);
                }
                if (validDirections.isEmpty()) {
                    return;
                }
            }
            count = () -> Math.clamp((long)((int)(leafPower * 4.0)), 1, 4);
        }
        WWLeavesExplosionParticlePacket.sendToAll(state, pos, difference.method_1021(leafPower * leafPower * 0.2), validDirections, count.get(), serverLevel);
    }

    public static void clientSpawnExplosionParticlesFromPacket(class_1937 level, @NotNull WWLeavesExplosionParticlePacket packet) {
        Supplier<class_243> posSupplier;
        if (!WWAmbienceAndMiscConfig.Client.EXPLOSION_LEAF_PARTICLES) {
            return;
        }
        class_2680 state = packet.state();
        Optional<FallingLeafData> optionalFallingLeafData = FallingLeafUtil.getFallingLeafData(state.method_26204());
        if (optionalFallingLeafData.isEmpty()) {
            return;
        }
        class_2338 pos = packet.pos();
        List<class_2350> directions = packet.directions();
        class_5819 random = level.field_9229;
        boolean litter = false;
        if (state.method_26164(WWBlockTags.LEAF_LITTERS)) {
            litter = true;
            posSupplier = () -> new class_243((double)pos.method_10263() + 0.5 + random.method_43059() * 0.4, (double)pos.method_10264() + 0.1, (double)pos.method_10260() + 0.5 + random.method_43059() * 0.4);
        } else {
            posSupplier = directions.isEmpty() ? () -> new class_243((double)pos.method_10263() + 0.5 + random.method_43059() * 0.4, (double)pos.method_10264() + 0.5 + random.method_43059() * 0.4, (double)pos.method_10260() + 0.5 + random.method_43059() * 0.4) : () -> {
                class_2350 direction = (class_2350)class_156.method_32309((List)directions, (class_5819)random);
                double x = (double)pos.method_10263() + 0.5 + random.method_43059() * 0.4;
                double y = (double)pos.method_10264() + 0.5 + random.method_43059() * 0.4;
                double z = (double)pos.method_10260() + 0.5 + random.method_43059() * 0.4;
                if (direction.method_10166() == class_2350.class_2351.field_11048) {
                    x = (double)pos.method_10263() + 0.5 + (double)direction.method_10148() * 0.6;
                }
                if (direction.method_10166() == class_2350.class_2351.field_11052) {
                    y = (double)pos.method_10264() + 0.5 + (double)direction.method_10164() * 0.6;
                }
                if (direction.method_10166() == class_2350.class_2351.field_11051) {
                    z = (double)pos.method_10260() + 0.5 + (double)direction.method_10165() * 0.6;
                }
                return new class_243(x, y, z);
            };
        }
        WWFallingLeavesParticleOptions options = FallingLeafUtil.createLeafParticleOptions(optionalFallingLeafData.get(), packet.velocity().method_1021(WWAmbienceAndMiscConfig.Client.EXPLOSION_LEAF_VELOCITY), litter, SLIGHTLY_HEAVY_GRAVITY_MODIFIER);
        for (int i = 0; i < packet.count(); ++i) {
            class_243 particlePos = posSupplier.get();
            level.method_8406((class_2394)options, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 0.0, 0.0, 0.0);
        }
    }

    @NotNull
    public static WWFallingLeavesParticleOptions createLeafParticleOptions(@NotNull FallingLeafData fallingLeafData, boolean isLitter) {
        return FallingLeafUtil.createLeafParticleOptions(fallingLeafData, isLitter, gravity -> gravity);
    }

    @NotNull
    public static WWFallingLeavesParticleOptions createLeafParticleOptions(@NotNull FallingLeafData fallingLeafData, boolean isLitter, @NotNull Function<Float, Float> gravityModifier) {
        class_2396<WWFallingLeavesParticleOptions> leafParticle = fallingLeafData.particle();
        LeafParticleData leafParticleData = isLitter ? FallingLeafUtil.getLitterOrLeafParticleData(leafParticle) : FallingLeafUtil.getLeafParticleData(leafParticle);
        return WWFallingLeavesParticleOptions.create(fallingLeafData.particle, leafParticleData.textureSize, gravityModifier.apply(Float.valueOf(leafParticleData.particleGravityScale)).floatValue(), leafParticleData.windScale, isLitter, leafParticleData.leafMovementType);
    }

    @NotNull
    public static WWFallingLeavesParticleOptions createLeafParticleOptions(@NotNull FallingLeafData fallingLeafData, class_243 velocity, boolean isLitter) {
        return FallingLeafUtil.createLeafParticleOptions(fallingLeafData, velocity, isLitter, false, gravity -> gravity);
    }

    @NotNull
    public static WWFallingLeavesParticleOptions createLeafParticleOptions(@NotNull FallingLeafData fallingLeafData, class_243 velocity, boolean isLitter, @NotNull Function<Float, Float> gravityModifier) {
        return FallingLeafUtil.createLeafParticleOptions(fallingLeafData, velocity, isLitter, false, gravityModifier);
    }

    @NotNull
    public static WWFallingLeavesParticleOptions createLeafParticleOptions(@NotNull FallingLeafData fallingLeafData, class_243 velocity, boolean isLitter, boolean useGroundSupportingMovement, @NotNull Function<Float, Float> gravityModifier) {
        class_2396<WWFallingLeavesParticleOptions> leafParticle = fallingLeafData.particle();
        LeafParticleData leafParticleData = isLitter ? FallingLeafUtil.getLitterOrLeafParticleData(leafParticle) : FallingLeafUtil.getLeafParticleData(leafParticle);
        return WWFallingLeavesParticleOptions.createControlledVelocity(fallingLeafData.particle, velocity, leafParticleData.textureSize, gravityModifier.apply(Float.valueOf(leafParticleData.particleGravityScale)).floatValue(), leafParticleData.windScale, isLitter, !useGroundSupportingMovement ? leafParticleData.leafMovementType : leafParticleData.leafMovementType.getGroundSupportingEquivalent());
    }

    public record FallingLeafData(Optional<class_10595> leafLitterBlock, float litterChance, class_2396<WWFallingLeavesParticleOptions> particle) {
    }

    public record LeafParticleData(class_2248 leavesBlock, float particleChance, Supplier<Double> frequencyModifier, int textureSize, float particleGravityScale, float windScale, LeafMovementType leafMovementType) {
    }

    public static enum LeafMovementType implements class_3542
    {
        NONE("none", false, false, false),
        SWIRL("swirl", true, false, false),
        FLOW_AWAY("flow_away", false, true, false),
        SWIRL_AND_FLOW_AWAY("swirl_and_flow_away", true, true, false),
        GROUND_SUPPORTING("ground_supporting", false, false, true),
        GROUND_SUPPORTING_SWIRL("ground_supporting_swirl", true, false, true),
        GROUND_SUPPORTING_FLOW_AWAY("ground_supporting_flow", true, false, true),
        GROUND_SUPPORTING_SWIRL_AND_FLOW_AWAY("ground_supporting_swirl_and_flow_away", true, true, true);

        public static final Codec<LeafMovementType> CODEC;
        public static final class_9139<ByteBuf, LeafMovementType> STREAM_CODEC;
        private final String name;
        private final boolean swirl;
        private final boolean flowAway;
        private final boolean bounceOnFloor;

        private LeafMovementType(String name, boolean swirl, boolean flowAway, boolean bounceOnFloor) {
            this.name = name;
            this.swirl = swirl;
            this.flowAway = flowAway;
            this.bounceOnFloor = bounceOnFloor;
        }

        public LeafMovementType getGroundSupportingEquivalent() {
            if (this == NONE) {
                return GROUND_SUPPORTING;
            }
            if (this == SWIRL) {
                return GROUND_SUPPORTING_SWIRL;
            }
            if (this == FLOW_AWAY) {
                return GROUND_SUPPORTING_FLOW_AWAY;
            }
            if (this == SWIRL_AND_FLOW_AWAY) {
                return GROUND_SUPPORTING_SWIRL_AND_FLOW_AWAY;
            }
            return this;
        }

        public boolean swirl() {
            return this.swirl;
        }

        public boolean flowAway() {
            return this.flowAway;
        }

        public boolean bounceOnFloor() {
            return this.bounceOnFloor;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(LeafMovementType::values);
            STREAM_CODEC = new class_9139<ByteBuf, LeafMovementType>(){

                @NotNull
                public LeafMovementType decode(ByteBuf byteBuf) {
                    return LeafMovementType.valueOf((String)class_9135.field_48554.decode((Object)byteBuf));
                }

                public void encode(ByteBuf byteBuf, @NotNull LeafMovementType leafMovementType) {
                    class_9135.field_48554.encode((Object)byteBuf, (Object)leafMovementType.name());
                }
            };
        }
    }
}

