/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.particle;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.math.api.AdvancedMath;
import net.frozenblock.wilderwild.registry.WWParticleTypes;
import net.frozenblock.wilderwild.registry.WWSounds;
import net.minecraft.class_1058;
import net.minecraft.class_11944;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3940;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

@Environment(value=EnvType.CLIENT)
public class MesogleaDripParticle
extends class_3940 {
    private boolean shouldTickUpXRotMultiplier;
    private float prevXRotMultiplier;
    private float xRotMultiplier;

    MesogleaDripParticle(@NotNull class_638 clientLevel, double x, double y, double z, class_1058 sprite) {
        super(clientLevel, x, y, z, sprite);
        this.method_3080(0.5f, 0.5f);
        this.field_3844 = 0.06f;
        this.field_17867 = 0.5f;
    }

    public void setBothXRotMultipliers(float f) {
        this.prevXRotMultiplier = f;
        this.xRotMultiplier = f;
    }

    public void lerpsToX(boolean b) {
        this.shouldTickUpXRotMultiplier = b;
    }

    public int method_3068(float f) {
        return 240;
    }

    public void method_3070() {
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        this.preMoveUpdate();
        if (this.field_3843) {
            return;
        }
        this.field_3869 -= (double)this.field_3844;
        this.method_3069(this.field_3852, this.field_3869, this.field_3850);
        this.postMoveUpdate();
        if (this.field_3843) {
            return;
        }
        this.prevXRotMultiplier = this.xRotMultiplier;
        this.xRotMultiplier += ((this.shouldTickUpXRotMultiplier ? 1.0f : 0.0f) - this.xRotMultiplier) * 0.25f;
        this.field_3852 *= (double)0.98f;
        this.field_3869 *= (double)0.98f;
        this.field_3850 *= (double)0.98f;
        class_2338 blockPos = class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871);
        class_3610 fluidState = this.field_3851.method_8316(blockPos);
        if (fluidState.method_15772() == class_3612.field_15910 && this.field_3854 < (double)((float)blockPos.method_10264() + fluidState.method_15763((class_1922)this.field_3851, blockPos))) {
            this.method_3085();
        }
    }

    public void method_3074(class_11944 renderState, @NotNull class_4184 camera, float partialTick) {
        Quaternionf rotation = new Quaternionf();
        this.method_55245().setRotation(rotation, camera, partialTick);
        rotation.rotateX(-camera.method_19329() * class_3532.method_16439((float)partialTick, (float)this.prevXRotMultiplier, (float)this.xRotMultiplier) * ((float)Math.PI / 180));
        if (this.field_62637 != 0.0f) {
            rotation.rotateZ(class_3532.method_16439((float)partialTick, (float)this.field_62638, (float)this.field_62637));
        }
        this.method_60373(renderState, camera, rotation, partialTick);
    }

    @NotNull
    public class_3940.class_8981 method_55245() {
        return class_3940.class_8981.field_47458;
    }

    protected void preMoveUpdate() {
        if (this.field_3847-- <= 0) {
            this.method_3085();
        }
    }

    protected void postMoveUpdate() {
    }

    @NotNull
    protected class_3940.class_11941 method_74255() {
        return class_3940.class_11941.field_62640;
    }

    @Environment(value=EnvType.CLIENT)
    static class DripHangParticle
    extends MesogleaDripParticle {
        private final class_2394 fallingParticle;
        private final class_4002 spriteSet;

        DripHangParticle(@NotNull class_638 clientLevel, double x, double y, double z, class_2394 particleOptions, class_4002 spriteSet) {
            super(clientLevel, x, y - 0.04, z, spriteSet.method_74304());
            this.fallingParticle = particleOptions;
            this.field_3844 *= 0.0f;
            this.field_3847 = 40;
            this.spriteSet = spriteSet;
            this.method_74306(this.spriteSet);
            this.method_3087(0.7f);
        }

        @Override
        protected void preMoveUpdate() {
            if (this.field_3847-- > 0) {
                return;
            }
            this.method_3085();
            this.field_3851.method_8406(this.fallingParticle, this.field_3874, this.field_3854, this.field_3871, this.field_3852, this.field_3869, this.field_3850);
        }

        @Override
        protected void postMoveUpdate() {
            if (!this.field_3843) {
                this.method_74307(this.spriteSet.method_18138((int)((double)this.field_3866 * 0.2) + 1, (int)((double)this.field_3847 * 0.2) + 1));
            }
        }
    }

    static class FallAndLandParticle
    extends FallingParticle {
        protected final class_2394 landParticle;

        FallAndLandParticle(@NotNull class_638 clientLevel, double x, double y, double z, class_2394 particleOptions, class_1058 sprite) {
            super(clientLevel, x, y, z, sprite);
            this.landParticle = particleOptions;
        }

        @Override
        protected void postMoveUpdate() {
            if (!this.field_3845) {
                return;
            }
            this.method_3085();
            this.field_3851.method_8406(this.landParticle, this.field_3874, this.field_3854, this.field_3871, 0.0, 0.0, 0.0);
            float pitch = class_3532.method_32750((class_5819)this.field_3840, (float)0.3f, (float)1.0f);
            this.field_3851.method_8486(this.field_3874, this.field_3854, this.field_3871, WWSounds.PARTICLE_MESOGLEA_DRIP_LAND, class_3419.field_15245, pitch, 1.0f, false);
        }
    }

    static class FallingParticle
    extends MesogleaDripParticle {
        FallingParticle(@NotNull class_638 level, double x, double y, double z, class_1058 sprite) {
            this(level, x, y, z, (int)(64.0 / (AdvancedMath.random().method_43058() * 0.8 + 0.2)), sprite);
            this.method_3087(0.7f);
            this.lerpsToX(true);
        }

        FallingParticle(@NotNull class_638 level, double x, double y, double z, int lifetime, class_1058 sprite) {
            super(level, x, y, z, sprite);
            this.field_3847 = lifetime;
        }

        @Override
        protected void postMoveUpdate() {
            if (this.field_3845) {
                this.method_3085();
            }
        }
    }

    static class DripLandParticle
    extends MesogleaDripParticle {
        DripLandParticle(@NotNull class_638 level, double x, double y, double z, class_1058 sprite) {
            super(level, x, y, z, sprite);
            this.field_3847 = (int)(16.0 / (AdvancedMath.random().method_43058() * 0.8 + 0.2));
            this.method_3087(0.7f);
            this.lerpsToX(true);
            this.setBothXRotMultipliers(1.0f);
        }
    }

    public record PinkHangProvider(class_4002 spriteSet) implements class_707<class_2400>
    {
        public class_703 createParticle(@NotNull class_2400 simpleParticleType, @NotNull class_638 level, double x, double y, double z, double xd, double yd, double zd, class_5819 random) {
            return new DripHangParticle(level, x, y, z, (class_2394)WWParticleTypes.FALLING_MESOGLEA_PINK, this.spriteSet);
        }
    }

    public record PinkFallProvider(class_4002 spriteSet) implements class_707<class_2400>
    {
        public class_703 createParticle(@NotNull class_2400 simpleParticleType, @NotNull class_638 level, double x, double y, double z, double xd, double yd, double zd, class_5819 random) {
            return new FallAndLandParticle(level, x, y, z, (class_2394)WWParticleTypes.LANDING_MESOGLEA_PINK, this.spriteSet.method_18139(random));
        }
    }

    public record RedHangProvider(class_4002 spriteSet) implements class_707<class_2400>
    {
        public class_703 createParticle(@NotNull class_2400 simpleParticleType, @NotNull class_638 level, double x, double y, double z, double xd, double yd, double zd, class_5819 random) {
            return new DripHangParticle(level, x, y, z, (class_2394)WWParticleTypes.FALLING_MESOGLEA_RED, this.spriteSet);
        }
    }

    public record RedFallProvider(class_4002 spriteSet) implements class_707<class_2400>
    {
        public class_703 createParticle(@NotNull class_2400 simpleParticleType, @NotNull class_638 level, double x, double y, double z, double xd, double yd, double zd, class_5819 random) {
            return new FallAndLandParticle(level, x, y, z, (class_2394)WWParticleTypes.LANDING_MESOGLEA_RED, this.spriteSet.method_18139(random));
        }
    }

    public record LimeHangProvider(class_4002 spriteSet) implements class_707<class_2400>
    {
        public class_703 createParticle(@NotNull class_2400 simpleParticleType, @NotNull class_638 level, double x, double y, double z, double xd, double yd, double zd, class_5819 random) {
            return new DripHangParticle(level, x, y, z, (class_2394)WWParticleTypes.FALLING_MESOGLEA_LIME, this.spriteSet);
        }
    }

    public record LimeFallProvider(class_4002 spriteSet) implements class_707<class_2400>
    {
        public class_703 createParticle(@NotNull class_2400 simpleParticleType, @NotNull class_638 level, double x, double y, double z, double xd, double yd, double zd, class_5819 random) {
            return new FallAndLandParticle(level, x, y, z, (class_2394)WWParticleTypes.LANDING_MESOGLEA_LIME, this.spriteSet.method_18139(random));
        }
    }

    public record YellowHangProvider(class_4002 spriteSet) implements class_707<class_2400>
    {
        public class_703 createParticle(@NotNull class_2400 simpleParticleType, @NotNull class_638 level, double x, double y, double z, double xd, double yd, double zd, class_5819 random) {
            return new DripHangParticle(level, x, y, z, (class_2394)WWParticleTypes.FALLING_MESOGLEA_YELLOW, this.spriteSet);
        }
    }

    public record YellowFallProvider(class_4002 spriteSet) implements class_707<class_2400>
    {
        public class_703 createParticle(@NotNull class_2400 simpleParticleType, @NotNull class_638 level, double x, double y, double z, double xd, double yd, double zd, class_5819 random) {
            return new FallAndLandParticle(level, x, y, z, (class_2394)WWParticleTypes.LANDING_MESOGLEA_YELLOW, this.spriteSet.method_18139(random));
        }
    }

    public record BlueHangProvider(class_4002 spriteSet) implements class_707<class_2400>
    {
        public class_703 createParticle(@NotNull class_2400 simpleParticleType, @NotNull class_638 level, double x, double y, double z, double xd, double yd, double zd, class_5819 random) {
            return new DripHangParticle(level, x, y, z, (class_2394)WWParticleTypes.FALLING_MESOGLEA_BLUE, this.spriteSet);
        }
    }

    public record BlueFallProvider(class_4002 spriteSet) implements class_707<class_2400>
    {
        public class_703 createParticle(@NotNull class_2400 simpleParticleType, @NotNull class_638 level, double x, double y, double z, double xd, double yd, double zd, class_5819 random) {
            return new FallAndLandParticle(level, x, y, z, (class_2394)WWParticleTypes.LANDING_MESOGLEA_BLUE, this.spriteSet.method_18139(random));
        }
    }

    public record PearlescentPurpleHangProvider(class_4002 spriteSet) implements class_707<class_2400>
    {
        public class_703 createParticle(@NotNull class_2400 simpleParticleType, @NotNull class_638 level, double x, double y, double z, double xd, double yd, double zd, class_5819 random) {
            return new DripHangParticle(level, x, y, z, (class_2394)WWParticleTypes.FALLING_MESOGLEA_PEARLESCENT_PURPLE, this.spriteSet);
        }
    }

    public record PearlescentPurpleFallProvider(class_4002 spriteSet) implements class_707<class_2400>
    {
        public class_703 createParticle(@NotNull class_2400 simpleParticleType, @NotNull class_638 level, double x, double y, double z, double xd, double yd, double zd, class_5819 random) {
            return new FallAndLandParticle(level, x, y, z, (class_2394)WWParticleTypes.LANDING_MESOGLEA_PEARLESCENT_PURPLE, this.spriteSet.method_18139(random));
        }
    }

    public record PearlescentBlueHangProvider(class_4002 spriteSet) implements class_707<class_2400>
    {
        public class_703 createParticle(@NotNull class_2400 simpleParticleType, @NotNull class_638 level, double x, double y, double z, double xd, double yd, double zd, class_5819 random) {
            return new DripHangParticle(level, x, y, z, (class_2394)WWParticleTypes.FALLING_MESOGLEA_PEARLESCENT_BLUE, this.spriteSet);
        }
    }

    public record PearlescentBlueFallProvider(class_4002 spriteSet) implements class_707<class_2400>
    {
        public class_703 createParticle(@NotNull class_2400 simpleParticleType, @NotNull class_638 level, double x, double y, double z, double xd, double yd, double zd, class_5819 random) {
            return new FallAndLandParticle(level, x, y, z, (class_2394)WWParticleTypes.LANDING_MESOGLEA_PEARLESCENT_BLUE, this.spriteSet.method_18139(random));
        }
    }

    public record LandProvider(class_4002 spriteSet) implements class_707<class_2400>
    {
        public class_703 createParticle(@NotNull class_2400 simpleParticleType, @NotNull class_638 level, double x, double y, double z, double xd, double yd, double zd, class_5819 random) {
            return new DripLandParticle(level, x, y, z, this.spriteSet.method_18139(random));
        }
    }
}

