/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild;

import java.util.Optional;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.frozenblock.lib.config.frozenlib_config.FrozenLibConfig;
import net.frozenblock.lib.debug.client.api.DebugRendererEvents;
import net.frozenblock.lib.debug.client.impl.DebugRenderManager;
import net.frozenblock.lib.menu.api.SplashTextAPI;
import net.frozenblock.wilderwild.WWConstants;
import net.frozenblock.wilderwild.client.WWBlockRenderLayers;
import net.frozenblock.wilderwild.client.WWClientMusicImpl;
import net.frozenblock.wilderwild.client.WWEasterEggs;
import net.frozenblock.wilderwild.client.WWFluidRendering;
import net.frozenblock.wilderwild.client.WWItemProperties;
import net.frozenblock.wilderwild.client.WWModelLayers;
import net.frozenblock.wilderwild.client.WWParticleEngine;
import net.frozenblock.wilderwild.client.WWTints;
import net.frozenblock.wilderwild.client.renderer.debug.OstrichDebugRenderer;
import net.frozenblock.wilderwild.config.WWAmbienceAndMiscConfig;
import net.frozenblock.wilderwild.networking.WWClientNetworking;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_9226;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public final class WilderWildClient
implements ClientModInitializer {
    public void onInitializeClient() {
        Optional modContainer = FabricLoader.getInstance().getModContainer("wilderwild");
        SplashTextAPI.addSplashLocation((class_2960)WWConstants.id("texts/splashes.txt"));
        WWEasterEggs.hatchEasterEggs();
        WWBlockRenderLayers.init();
        WWFluidRendering.init();
        WWItemProperties.init();
        WWModelLayers.init();
        WWParticleEngine.init();
        WWTints.initBlocks();
        WWTints.initItems();
        WWClientMusicImpl.addMusicChanges();
        WWClientNetworking.registerPacketReceivers();
        if (WWAmbienceAndMiscConfig.get().music.wilderExtraMusic) {
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)WWConstants.id("wilder_extra_music"), (ModContainer)((ModContainer)modContainer.get()), (class_2561)class_2561.method_43471((String)"pack.wilderwild.wilder_extra_music"), (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED);
        }
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(this){

            public class_2960 getFabricId() {
                return WWConstants.id("minecraft_live_sculk_sensor");
            }

            public void method_14491(@NotNull class_3300 resourceManager) {
                WWConstants.MC_LIVE_TENDRILS = resourceManager.method_29213().anyMatch(packResources -> {
                    if (packResources.method_56929().isPresent()) {
                        return ((class_9226)packResources.method_56929().get()).comp_2337().equals(WWConstants.string("mc_live_tendrils"));
                    }
                    return false;
                });
            }
        });
        DebugRendererEvents.DEBUG_RENDERERS_CREATED.register(client -> {
            OstrichDebugRenderer ostrichDebugRenderer = new OstrichDebugRenderer(client);
            ClientTickEvents.START_WORLD_TICK.register(clientLevel -> {
                if (FrozenLibConfig.IS_DEBUG) {
                    ostrichDebugRenderer.tick();
                }
            });
            DebugRenderManager.addClearRunnable(ostrichDebugRenderer::method_20414);
            DebugRenderManager.registerRenderer((class_2960)WWConstants.id("ostrich"), ostrichDebugRenderer::method_23109);
        });
    }
}

