/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block;

import com.mojang.serialization.MapCodec;
import net.frozenblock.wilderwild.registry.WWCriteria;
import net.frozenblock.wilderwild.tag.WWEntityTags;
import net.frozenblock.wilderwild.worldgen.impl.util.IcicleUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2373;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import org.jetbrains.annotations.NotNull;

public class FragileIceBlock
extends class_2373 {
    public static final MapCodec<FragileIceBlock> CODEC = FragileIceBlock.method_54094(FragileIceBlock::new);
    public static final class_2758 AGE = class_2741.field_12556;
    public static final class_6017 SHEET_SHATTER_DELAY = class_6019.method_35017((int)1, (int)5);
    public static final float NEIGHBOR_CHANGE_CHANCE = 0.55f;
    public static final int DELAY_BETWEEN_CRACKS = 20;

    @NotNull
    public MapCodec<FragileIceBlock> method_53969() {
        return CODEC;
    }

    public FragileIceBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0)));
    }

    private void crackOrDestroy(@NotNull class_2680 blockState, class_1937 level, class_2338 blockPos) {
        int age = (Integer)blockState.method_11654((class_2769)AGE);
        if (age < 2) {
            level.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            class_2498 soundType = this.method_9573(blockState);
            level.method_8396(null, blockPos, soundType.method_10595(), class_3419.field_15245, 0.1f, soundType.method_10599() + 0.2f + level.method_8409().method_43057() * 0.2f);
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                serverLevel.method_14199((class_2394)new class_2388(class_2398.field_11217, blockState), (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5, level.field_9229.method_43051(20, 30), (double)0.3f, (double)0.3f, (double)0.3f, 0.05);
            }
        } else {
            level.method_22352(blockPos, false);
        }
    }

    public void scheduleCrackIfNotScheduled(@NotNull class_1937 level, class_2338 blockPos) {
        if (!level.method_8397().method_8674(blockPos, (Object)this)) {
            level.method_39279(blockPos, (class_2248)this, 20);
        }
    }

    protected void method_9588(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        this.crackOrDestroy(blockState, (class_1937)serverLevel, blockPos);
    }

    protected void method_9612(class_2680 blockState, class_1937 level, class_2338 blockPos, @NotNull class_2248 block, class_2338 blockPos2, boolean bl) {
        if (block.method_9564().method_27852((class_2248)this) && level.method_8320(blockPos2).method_26215() && level.method_8409().method_43057() <= 0.55f) {
            this.scheduleShatter(level, blockPos, blockState, level.method_8409());
        }
        super.method_9612(blockState, level, blockPos, block, blockPos2, bl);
    }

    protected void method_9514(@NotNull class_2680 blockState, @NotNull class_3218 serverLevel, class_2338 blockPos, @NotNull class_5819 randomSource) {
        if (randomSource.method_43057() <= 0.075f) {
            IcicleUtils.growIcicleOnRandomTick(serverLevel, blockPos);
        } else {
            this.heal(blockState, (class_1937)serverLevel, blockPos);
        }
    }

    public void method_9591(class_1937 level, class_2338 blockPos, class_2680 blockState, @NotNull class_1297 entity) {
        if (entity.method_5864().method_20210(WWEntityTags.FRAGILE_ICE_UNWALKABLE_MOBS)) {
            this.scheduleCrackIfNotScheduled(level, blockPos);
        }
    }

    public void method_9554(class_1937 level, class_2680 blockState, class_2338 blockPos, class_1297 entity, float fallDistance) {
        super.method_9554(level, blockState, blockPos, entity, fallDistance);
        if (!entity.method_5864().method_20210(WWEntityTags.FRAGILE_ICE_DOESNT_CRACK_ON_FALL) && fallDistance >= 4.0f) {
            level.method_22352(blockPos, false);
            if (entity instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)entity;
                WWCriteria.FRAGILE_ICE_FAL_ONTO_AND_BREAK.trigger(serverPlayer);
            }
        }
    }

    protected void method_19286(class_1937 level, class_2680 blockState, class_3965 blockHitResult, @NotNull class_1676 projectile) {
        double velocity;
        if (!projectile.method_5864().method_20210(WWEntityTags.FRAGILE_ICE_DOESNT_CRACK_PROJECTILE) && (velocity = projectile.method_18798().method_1033()) >= 1.6) {
            level.method_22352(blockHitResult.method_17777(), false);
        }
    }

    public void scheduleShatter(@NotNull class_1937 level, class_2338 blockPos, @NotNull class_2680 blockState, class_5819 randomSource) {
        level.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(2)), 2);
        level.method_39279(blockPos, (class_2248)this, SHEET_SHATTER_DELAY.method_35008(randomSource));
    }

    private void heal(@NotNull class_2680 blockState, class_1937 level, class_2338 blockPos) {
        if ((Integer)blockState.method_11654((class_2769)AGE) > 0) {
            level.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0)), 2);
        }
    }

    protected void method_9515(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{AGE});
    }
}

